% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_provision_byoip_cidr}
\alias{ec2_provision_byoip_cidr}
\title{Provisions an IPv4 or IPv6 address range for use with your Amazon Web
Services resources through bring your own IP addresses (BYOIP) and
creates a corresponding address pool}
\usage{
ec2_provision_byoip_cidr(
  Cidr,
  CidrAuthorizationContext = NULL,
  PubliclyAdvertisable = NULL,
  Description = NULL,
  DryRun = NULL,
  PoolTagSpecifications = NULL,
  MultiRegion = NULL
)
}
\arguments{
\item{Cidr}{[required] The public IPv4 or IPv6 address range, in CIDR notation. The most
specific IPv4 prefix that you can specify is /24. The most specific IPv6
prefix you can specify is /56. The address range cannot overlap with
another address range that you've brought to this or another Region.}

\item{CidrAuthorizationContext}{A signed document that proves that you are authorized to bring the
specified IP address range to Amazon using BYOIP.}

\item{PubliclyAdvertisable}{(IPv6 only) Indicate whether the address range will be publicly
advertised to the internet.

Default: true}

\item{Description}{A description for the address range and the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PoolTagSpecifications}{The tags to apply to the address pool.}

\item{MultiRegion}{Reserved.}
}
\description{
Provisions an IPv4 or IPv6 address range for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using \code{\link[=ec2_advertise_byoip_cidr]{advertise_byoip_cidr}}.

See \url{https://paws-r.github.io/docs/ec2/provision_byoip_cidr.html} for full documentation.
}
\keyword{internal}
