% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_import_volume}
\alias{ec2_import_volume}
\title{Creates an import volume task using metadata from the specified disk
image}
\usage{
ec2_import_volume(
  AvailabilityZone,
  Description = NULL,
  DryRun = NULL,
  Image,
  Volume
)
}
\arguments{
\item{AvailabilityZone}{[required] The Availability Zone for the resulting EBS volume.}

\item{Description}{A description of the volume.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Image}{[required] The disk image.}

\item{Volume}{[required] The volume size.}
}
\description{
Creates an import volume task using metadata from the specified disk image.

See \url{https://paws-r.github.io/docs/ec2/import_volume.html} for full documentation.
}
\keyword{internal}
