# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include computeoptimizer_service.R
NULL

#' Deletes a recommendation preference, such as enhanced infrastructure
#' metrics
#'
#' @description
#' Deletes a recommendation preference, such as enhanced infrastructure metrics.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/delete_recommendation_preferences.html](https://paws-r.github.io/docs/computeoptimizer/delete_recommendation_preferences.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The target resource type of the recommendation preference to delete.
#' 
#' The `Ec2Instance` option encompasses standalone instances and instances
#' that are part of Auto Scaling groups. The `AutoScalingGroup` option
#' encompasses only instances that are part of an Auto Scaling group.
#' 
#' The valid values for this parameter are `Ec2Instance` and
#' `AutoScalingGroup`.
#' @param scope An object that describes the scope of the recommendation preference to
#' delete.
#' 
#' You can delete recommendation preferences that are created at the
#' organization level (for management accounts of an organization only),
#' account level, and resource level. For more information, see [Activating
#' enhanced infrastructure
#' metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html)
#' in the *Compute Optimizer User Guide*.
#' @param recommendationPreferenceNames &#91;required&#93; The name of the recommendation preference to delete.
#' 
#' Enhanced infrastructure metrics (`EnhancedInfrastructureMetrics`) is the
#' only feature that can be activated through preferences. Therefore, it is
#' also the only recommendation preference that can be deleted.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_delete_recommendation_preferences
computeoptimizer_delete_recommendation_preferences <- function(resourceType, scope = NULL, recommendationPreferenceNames) {
  op <- new_operation(
    name = "DeleteRecommendationPreferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$delete_recommendation_preferences_input(resourceType = resourceType, scope = scope, recommendationPreferenceNames = recommendationPreferenceNames)
  output <- .computeoptimizer$delete_recommendation_preferences_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$delete_recommendation_preferences <- computeoptimizer_delete_recommendation_preferences

#' Describes recommendation export jobs created in the last seven days
#'
#' @description
#' Describes recommendation export jobs created in the last seven days.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/describe_recommendation_export_jobs.html](https://paws-r.github.io/docs/computeoptimizer/describe_recommendation_export_jobs.html) for full documentation.
#'
#' @param jobIds The identification numbers of the export jobs to return.
#' 
#' An export job ID is returned when you create an export using the
#' [`export_auto_scaling_group_recommendations`][computeoptimizer_export_auto_scaling_group_recommendations]
#' or
#' [`export_ec2_instance_recommendations`][computeoptimizer_export_ec2_instance_recommendations]
#' actions.
#' 
#' All export jobs created in the last seven days are returned if this
#' parameter is omitted.
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of export jobs.
#' @param nextToken The token to advance to the next page of export jobs.
#' @param maxResults The maximum number of export jobs to return with a single request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_describe_recommendation_export_jobs
computeoptimizer_describe_recommendation_export_jobs <- function(jobIds = NULL, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "DescribeRecommendationExportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$describe_recommendation_export_jobs_input(jobIds = jobIds, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .computeoptimizer$describe_recommendation_export_jobs_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$describe_recommendation_export_jobs <- computeoptimizer_describe_recommendation_export_jobs

#' Exports optimization recommendations for Auto Scaling groups
#'
#' @description
#' Exports optimization recommendations for Auto Scaling groups.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/export_auto_scaling_group_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/export_auto_scaling_group_recommendations.html) for full documentation.
#'
#' @param accountIds The IDs of the Amazon Web Services accounts for which to export Auto
#' Scaling group recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to export
#' recommendations.
#' 
#' This parameter cannot be specified together with the include member
#' accounts parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the include member accounts parameter, is omitted.
#' 
#' You can specify multiple account IDs per request.
#' @param filters An array of objects to specify a filter that exports a more specific set
#' of Auto Scaling group recommendations.
#' @param fieldsToExport The recommendations data to include in the export file. For more
#' information about the fields that can be exported, see [Exported
#' files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files)
#' in the *Compute Optimizer User Guide*.
#' @param s3DestinationConfig &#91;required&#93; An object to specify the destination Amazon Simple Storage Service
#' (Amazon S3) bucket name and key prefix for the export job.
#' 
#' You must create the destination Amazon S3 bucket for your
#' recommendations export before you create the export job. Compute
#' Optimizer does not create the S3 bucket for you. After you create the S3
#' bucket, ensure that it has the required permissions policy to allow
#' Compute Optimizer to write the export file to it. If you plan to specify
#' an object prefix when you create the export job, you must include the
#' object prefix in the policy that you add to the S3 bucket. For more
#' information, see [Amazon S3 Bucket Policy for Compute
#' Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
#' in the *Compute Optimizer User Guide*.
#' @param fileFormat The format of the export file.
#' 
#' The only export file format currently supported is `Csv`.
#' @param includeMemberAccounts Indicates whether to include recommendations for resources in all member
#' accounts of the organization if your account is the management account
#' of an organization.
#' 
#' The member accounts must also be opted in to Compute Optimizer, and
#' trusted access for Compute Optimizer must be enabled in the organization
#' account. For more information, see [Compute Optimizer and Amazon Web
#' Services Organizations trusted
#' access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access)
#' in the *Compute Optimizer User Guide*.
#' 
#' Recommendations for member accounts of the organization are not included
#' in the export file if this parameter is omitted.
#' 
#' This parameter cannot be specified together with the account IDs
#' parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the account IDs parameter, is omitted.
#' @param recommendationPreferences An object to specify the preferences for the Auto Scaling group
#' recommendations to export.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_export_auto_scaling_group_recommendations
computeoptimizer_export_auto_scaling_group_recommendations <- function(accountIds = NULL, filters = NULL, fieldsToExport = NULL, s3DestinationConfig, fileFormat = NULL, includeMemberAccounts = NULL, recommendationPreferences = NULL) {
  op <- new_operation(
    name = "ExportAutoScalingGroupRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$export_auto_scaling_group_recommendations_input(accountIds = accountIds, filters = filters, fieldsToExport = fieldsToExport, s3DestinationConfig = s3DestinationConfig, fileFormat = fileFormat, includeMemberAccounts = includeMemberAccounts, recommendationPreferences = recommendationPreferences)
  output <- .computeoptimizer$export_auto_scaling_group_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$export_auto_scaling_group_recommendations <- computeoptimizer_export_auto_scaling_group_recommendations

#' Exports optimization recommendations for Amazon EBS volumes
#'
#' @description
#' Exports optimization recommendations for Amazon EBS volumes.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/export_ebs_volume_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/export_ebs_volume_recommendations.html) for full documentation.
#'
#' @param accountIds The IDs of the Amazon Web Services accounts for which to export Amazon
#' EBS volume recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to export
#' recommendations.
#' 
#' This parameter cannot be specified together with the include member
#' accounts parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the include member accounts parameter, is omitted.
#' 
#' You can specify multiple account IDs per request.
#' @param filters An array of objects to specify a filter that exports a more specific set
#' of Amazon EBS volume recommendations.
#' @param fieldsToExport The recommendations data to include in the export file. For more
#' information about the fields that can be exported, see [Exported
#' files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files)
#' in the *Compute Optimizer User Guide*.
#' @param s3DestinationConfig &#91;required&#93; 
#' @param fileFormat The format of the export file.
#' 
#' The only export file format currently supported is `Csv`.
#' @param includeMemberAccounts Indicates whether to include recommendations for resources in all member
#' accounts of the organization if your account is the management account
#' of an organization.
#' 
#' The member accounts must also be opted in to Compute Optimizer, and
#' trusted access for Compute Optimizer must be enabled in the organization
#' account. For more information, see [Compute Optimizer and Amazon Web
#' Services Organizations trusted
#' access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access)
#' in the *Compute Optimizer User Guide*.
#' 
#' Recommendations for member accounts of the organization are not included
#' in the export file if this parameter is omitted.
#' 
#' This parameter cannot be specified together with the account IDs
#' parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the account IDs parameter, is omitted.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_export_ebs_volume_recommendations
computeoptimizer_export_ebs_volume_recommendations <- function(accountIds = NULL, filters = NULL, fieldsToExport = NULL, s3DestinationConfig, fileFormat = NULL, includeMemberAccounts = NULL) {
  op <- new_operation(
    name = "ExportEBSVolumeRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$export_ebs_volume_recommendations_input(accountIds = accountIds, filters = filters, fieldsToExport = fieldsToExport, s3DestinationConfig = s3DestinationConfig, fileFormat = fileFormat, includeMemberAccounts = includeMemberAccounts)
  output <- .computeoptimizer$export_ebs_volume_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$export_ebs_volume_recommendations <- computeoptimizer_export_ebs_volume_recommendations

#' Exports optimization recommendations for Amazon EC2 instances
#'
#' @description
#' Exports optimization recommendations for Amazon EC2 instances.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/export_ec2_instance_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/export_ec2_instance_recommendations.html) for full documentation.
#'
#' @param accountIds The IDs of the Amazon Web Services accounts for which to export instance
#' recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to export
#' recommendations.
#' 
#' This parameter cannot be specified together with the include member
#' accounts parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the include member accounts parameter, is omitted.
#' 
#' You can specify multiple account IDs per request.
#' @param filters An array of objects to specify a filter that exports a more specific set
#' of instance recommendations.
#' @param fieldsToExport The recommendations data to include in the export file. For more
#' information about the fields that can be exported, see [Exported
#' files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files)
#' in the *Compute Optimizer User Guide*.
#' @param s3DestinationConfig &#91;required&#93; An object to specify the destination Amazon Simple Storage Service
#' (Amazon S3) bucket name and key prefix for the export job.
#' 
#' You must create the destination Amazon S3 bucket for your
#' recommendations export before you create the export job. Compute
#' Optimizer does not create the S3 bucket for you. After you create the S3
#' bucket, ensure that it has the required permissions policy to allow
#' Compute Optimizer to write the export file to it. If you plan to specify
#' an object prefix when you create the export job, you must include the
#' object prefix in the policy that you add to the S3 bucket. For more
#' information, see [Amazon S3 Bucket Policy for Compute
#' Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/create-s3-bucket-policy-for-compute-optimizer.html)
#' in the *Compute Optimizer User Guide*.
#' @param fileFormat The format of the export file.
#' 
#' The only export file format currently supported is `Csv`.
#' @param includeMemberAccounts Indicates whether to include recommendations for resources in all member
#' accounts of the organization if your account is the management account
#' of an organization.
#' 
#' The member accounts must also be opted in to Compute Optimizer, and
#' trusted access for Compute Optimizer must be enabled in the organization
#' account. For more information, see [Compute Optimizer and Amazon Web
#' Services Organizations trusted
#' access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access)
#' in the *Compute Optimizer User Guide*.
#' 
#' Recommendations for member accounts of the organization are not included
#' in the export file if this parameter is omitted.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the account IDs parameter, is omitted.
#' @param recommendationPreferences An object to specify the preferences for the Amazon EC2 instance
#' recommendations to export.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_export_ec2_instance_recommendations
computeoptimizer_export_ec2_instance_recommendations <- function(accountIds = NULL, filters = NULL, fieldsToExport = NULL, s3DestinationConfig, fileFormat = NULL, includeMemberAccounts = NULL, recommendationPreferences = NULL) {
  op <- new_operation(
    name = "ExportEC2InstanceRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$export_ec2_instance_recommendations_input(accountIds = accountIds, filters = filters, fieldsToExport = fieldsToExport, s3DestinationConfig = s3DestinationConfig, fileFormat = fileFormat, includeMemberAccounts = includeMemberAccounts, recommendationPreferences = recommendationPreferences)
  output <- .computeoptimizer$export_ec2_instance_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$export_ec2_instance_recommendations <- computeoptimizer_export_ec2_instance_recommendations

#' Exports optimization recommendations for Lambda functions
#'
#' @description
#' Exports optimization recommendations for Lambda functions.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/export_lambda_function_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/export_lambda_function_recommendations.html) for full documentation.
#'
#' @param accountIds The IDs of the Amazon Web Services accounts for which to export Lambda
#' function recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to export
#' recommendations.
#' 
#' This parameter cannot be specified together with the include member
#' accounts parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the include member accounts parameter, is omitted.
#' 
#' You can specify multiple account IDs per request.
#' @param filters An array of objects to specify a filter that exports a more specific set
#' of Lambda function recommendations.
#' @param fieldsToExport The recommendations data to include in the export file. For more
#' information about the fields that can be exported, see [Exported
#' files](https://docs.aws.amazon.com/compute-optimizer/latest/ug/exporting-recommendations.html#exported-files)
#' in the *Compute Optimizer User Guide*.
#' @param s3DestinationConfig &#91;required&#93; 
#' @param fileFormat The format of the export file.
#' 
#' The only export file format currently supported is `Csv`.
#' @param includeMemberAccounts Indicates whether to include recommendations for resources in all member
#' accounts of the organization if your account is the management account
#' of an organization.
#' 
#' The member accounts must also be opted in to Compute Optimizer, and
#' trusted access for Compute Optimizer must be enabled in the organization
#' account. For more information, see [Compute Optimizer and Amazon Web
#' Services Organizations trusted
#' access](https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html#trusted-service-access)
#' in the *Compute Optimizer User Guide*.
#' 
#' Recommendations for member accounts of the organization are not included
#' in the export file if this parameter is omitted.
#' 
#' This parameter cannot be specified together with the account IDs
#' parameter. The parameters are mutually exclusive.
#' 
#' Recommendations for member accounts are not included in the export if
#' this parameter, or the account IDs parameter, is omitted.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_export_lambda_function_recommendations
computeoptimizer_export_lambda_function_recommendations <- function(accountIds = NULL, filters = NULL, fieldsToExport = NULL, s3DestinationConfig, fileFormat = NULL, includeMemberAccounts = NULL) {
  op <- new_operation(
    name = "ExportLambdaFunctionRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$export_lambda_function_recommendations_input(accountIds = accountIds, filters = filters, fieldsToExport = fieldsToExport, s3DestinationConfig = s3DestinationConfig, fileFormat = fileFormat, includeMemberAccounts = includeMemberAccounts)
  output <- .computeoptimizer$export_lambda_function_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$export_lambda_function_recommendations <- computeoptimizer_export_lambda_function_recommendations

#' Returns Auto Scaling group recommendations
#'
#' @description
#' Returns Auto Scaling group recommendations.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_auto_scaling_group_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/get_auto_scaling_group_recommendations.html) for full documentation.
#'
#' @param accountIds The ID of the Amazon Web Services account for which to return Auto
#' Scaling group recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to return
#' Auto Scaling group recommendations.
#' 
#' Only one account ID can be specified per request.
#' @param autoScalingGroupArns The Amazon Resource Name (ARN) of the Auto Scaling groups for which to
#' return recommendations.
#' @param nextToken The token to advance to the next page of Auto Scaling group
#' recommendations.
#' @param maxResults The maximum number of Auto Scaling group recommendations to return with
#' a single request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of Auto Scaling group recommendations.
#' @param recommendationPreferences An object to specify the preferences for the Auto Scaling group
#' recommendations to return in the response.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_auto_scaling_group_recommendations
computeoptimizer_get_auto_scaling_group_recommendations <- function(accountIds = NULL, autoScalingGroupArns = NULL, nextToken = NULL, maxResults = NULL, filters = NULL, recommendationPreferences = NULL) {
  op <- new_operation(
    name = "GetAutoScalingGroupRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_auto_scaling_group_recommendations_input(accountIds = accountIds, autoScalingGroupArns = autoScalingGroupArns, nextToken = nextToken, maxResults = maxResults, filters = filters, recommendationPreferences = recommendationPreferences)
  output <- .computeoptimizer$get_auto_scaling_group_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_auto_scaling_group_recommendations <- computeoptimizer_get_auto_scaling_group_recommendations

#' Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations
#'
#' @description
#' Returns Amazon Elastic Block Store (Amazon EBS) volume recommendations.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_ebs_volume_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/get_ebs_volume_recommendations.html) for full documentation.
#'
#' @param volumeArns The Amazon Resource Name (ARN) of the volumes for which to return
#' recommendations.
#' @param nextToken The token to advance to the next page of volume recommendations.
#' @param maxResults The maximum number of volume recommendations to return with a single
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of volume recommendations.
#' @param accountIds The ID of the Amazon Web Services account for which to return volume
#' recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to return
#' volume recommendations.
#' 
#' Only one account ID can be specified per request.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_ebs_volume_recommendations
computeoptimizer_get_ebs_volume_recommendations <- function(volumeArns = NULL, nextToken = NULL, maxResults = NULL, filters = NULL, accountIds = NULL) {
  op <- new_operation(
    name = "GetEBSVolumeRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_ebs_volume_recommendations_input(volumeArns = volumeArns, nextToken = nextToken, maxResults = maxResults, filters = filters, accountIds = accountIds)
  output <- .computeoptimizer$get_ebs_volume_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_ebs_volume_recommendations <- computeoptimizer_get_ebs_volume_recommendations

#' Returns Amazon EC2 instance recommendations
#'
#' @description
#' Returns Amazon EC2 instance recommendations.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_ec2_instance_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/get_ec2_instance_recommendations.html) for full documentation.
#'
#' @param instanceArns The Amazon Resource Name (ARN) of the instances for which to return
#' recommendations.
#' @param nextToken The token to advance to the next page of instance recommendations.
#' @param maxResults The maximum number of instance recommendations to return with a single
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of instance recommendations.
#' @param accountIds The ID of the Amazon Web Services account for which to return instance
#' recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to return
#' instance recommendations.
#' 
#' Only one account ID can be specified per request.
#' @param recommendationPreferences An object to specify the preferences for the Amazon EC2 instance
#' recommendations to return in the response.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_ec2_instance_recommendations
computeoptimizer_get_ec2_instance_recommendations <- function(instanceArns = NULL, nextToken = NULL, maxResults = NULL, filters = NULL, accountIds = NULL, recommendationPreferences = NULL) {
  op <- new_operation(
    name = "GetEC2InstanceRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_ec2_instance_recommendations_input(instanceArns = instanceArns, nextToken = nextToken, maxResults = maxResults, filters = filters, accountIds = accountIds, recommendationPreferences = recommendationPreferences)
  output <- .computeoptimizer$get_ec2_instance_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_ec2_instance_recommendations <- computeoptimizer_get_ec2_instance_recommendations

#' Returns the projected utilization metrics of Amazon EC2 instance
#' recommendations
#'
#' @description
#' Returns the projected utilization metrics of Amazon EC2 instance recommendations.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_ec2_recommendation_projected_metrics.html](https://paws-r.github.io/docs/computeoptimizer/get_ec2_recommendation_projected_metrics.html) for full documentation.
#'
#' @param instanceArn &#91;required&#93; The Amazon Resource Name (ARN) of the instances for which to return
#' recommendation projected metrics.
#' @param stat &#91;required&#93; The statistic of the projected metrics.
#' @param period &#91;required&#93; The granularity, in seconds, of the projected metrics data points.
#' @param startTime &#91;required&#93; The timestamp of the first projected metrics data point to return.
#' @param endTime &#91;required&#93; The timestamp of the last projected metrics data point to return.
#' @param recommendationPreferences An object to specify the preferences for the Amazon EC2 recommendation
#' projected metrics to return in the response.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_ec2_recommendation_projected_metrics
computeoptimizer_get_ec2_recommendation_projected_metrics <- function(instanceArn, stat, period, startTime, endTime, recommendationPreferences = NULL) {
  op <- new_operation(
    name = "GetEC2RecommendationProjectedMetrics",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_ec2_recommendation_projected_metrics_input(instanceArn = instanceArn, stat = stat, period = period, startTime = startTime, endTime = endTime, recommendationPreferences = recommendationPreferences)
  output <- .computeoptimizer$get_ec2_recommendation_projected_metrics_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_ec2_recommendation_projected_metrics <- computeoptimizer_get_ec2_recommendation_projected_metrics

#' Returns the recommendation preferences that are in effect for a given
#' resource, such as enhanced infrastructure metrics
#'
#' @description
#' Returns the recommendation preferences that are in effect for a given resource, such as enhanced infrastructure metrics. Considers all applicable preferences that you might have set at the resource, account, and organization level.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_effective_recommendation_preferences.html](https://paws-r.github.io/docs/computeoptimizer/get_effective_recommendation_preferences.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource for which to confirm
#' effective recommendation preferences. Only EC2 instance and Auto Scaling
#' group ARNs are currently supported.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_effective_recommendation_preferences
computeoptimizer_get_effective_recommendation_preferences <- function(resourceArn) {
  op <- new_operation(
    name = "GetEffectiveRecommendationPreferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_effective_recommendation_preferences_input(resourceArn = resourceArn)
  output <- .computeoptimizer$get_effective_recommendation_preferences_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_effective_recommendation_preferences <- computeoptimizer_get_effective_recommendation_preferences

#' Returns the enrollment (opt in) status of an account to the Compute
#' Optimizer service
#'
#' @description
#' Returns the enrollment (opt in) status of an account to the Compute Optimizer service.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_enrollment_status.html](https://paws-r.github.io/docs/computeoptimizer/get_enrollment_status.html) for full documentation.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_enrollment_status
computeoptimizer_get_enrollment_status <- function() {
  op <- new_operation(
    name = "GetEnrollmentStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_enrollment_status_input()
  output <- .computeoptimizer$get_enrollment_status_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_enrollment_status <- computeoptimizer_get_enrollment_status

#' Returns the Compute Optimizer enrollment (opt-in) status of organization
#' member accounts, if your account is an organization management account
#'
#' @description
#' Returns the Compute Optimizer enrollment (opt-in) status of organization member accounts, if your account is an organization management account.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_enrollment_statuses_for_organization.html](https://paws-r.github.io/docs/computeoptimizer/get_enrollment_statuses_for_organization.html) for full documentation.
#'
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of account enrollment statuses.
#' @param nextToken The token to advance to the next page of account enrollment statuses.
#' @param maxResults The maximum number of account enrollment statuses to return with a
#' single request. You can specify up to 100 statuses to return with each
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_enrollment_statuses_for_organization
computeoptimizer_get_enrollment_statuses_for_organization <- function(filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetEnrollmentStatusesForOrganization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_enrollment_statuses_for_organization_input(filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .computeoptimizer$get_enrollment_statuses_for_organization_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_enrollment_statuses_for_organization <- computeoptimizer_get_enrollment_statuses_for_organization

#' Returns Lambda function recommendations
#'
#' @description
#' Returns Lambda function recommendations.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_lambda_function_recommendations.html](https://paws-r.github.io/docs/computeoptimizer/get_lambda_function_recommendations.html) for full documentation.
#'
#' @param functionArns The Amazon Resource Name (ARN) of the functions for which to return
#' recommendations.
#' 
#' You can specify a qualified or unqualified ARN. If you specify an
#' unqualified ARN without a function version suffix, Compute Optimizer
#' will return recommendations for the latest (`$LATEST`) version of the
#' function. If you specify a qualified ARN with a version suffix, Compute
#' Optimizer will return recommendations for the specified function
#' version. For more information about using function versions, see [Using
#' versions](https://docs.aws.amazon.com/lambda/latest/dg/configuration-versions.html#versioning-versions-using)
#' in the *Lambda Developer Guide*.
#' @param accountIds The ID of the Amazon Web Services account for which to return function
#' recommendations.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to return
#' function recommendations.
#' 
#' Only one account ID can be specified per request.
#' @param filters An array of objects to specify a filter that returns a more specific
#' list of function recommendations.
#' @param nextToken The token to advance to the next page of function recommendations.
#' @param maxResults The maximum number of function recommendations to return with a single
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_lambda_function_recommendations
computeoptimizer_get_lambda_function_recommendations <- function(functionArns = NULL, accountIds = NULL, filters = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetLambdaFunctionRecommendations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_lambda_function_recommendations_input(functionArns = functionArns, accountIds = accountIds, filters = filters, nextToken = nextToken, maxResults = maxResults)
  output <- .computeoptimizer$get_lambda_function_recommendations_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_lambda_function_recommendations <- computeoptimizer_get_lambda_function_recommendations

#' Returns existing recommendation preferences, such as enhanced
#' infrastructure metrics
#'
#' @description
#' Returns existing recommendation preferences, such as enhanced infrastructure metrics.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_recommendation_preferences.html](https://paws-r.github.io/docs/computeoptimizer/get_recommendation_preferences.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The target resource type of the recommendation preference for which to
#' return preferences.
#' 
#' The `Ec2Instance` option encompasses standalone instances and instances
#' that are part of Auto Scaling groups. The `AutoScalingGroup` option
#' encompasses only instances that are part of an Auto Scaling group.
#' 
#' The valid values for this parameter are `Ec2Instance` and
#' `AutoScalingGroup`.
#' @param scope An object that describes the scope of the recommendation preference to
#' return.
#' 
#' You can return recommendation preferences that are created at the
#' organization level (for management accounts of an organization only),
#' account level, and resource level. For more information, see [Activating
#' enhanced infrastructure
#' metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html)
#' in the *Compute Optimizer User Guide*.
#' @param nextToken The token to advance to the next page of recommendation preferences.
#' @param maxResults The maximum number of recommendation preferences to return with a single
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_recommendation_preferences
computeoptimizer_get_recommendation_preferences <- function(resourceType, scope = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetRecommendationPreferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_recommendation_preferences_input(resourceType = resourceType, scope = scope, nextToken = nextToken, maxResults = maxResults)
  output <- .computeoptimizer$get_recommendation_preferences_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_recommendation_preferences <- computeoptimizer_get_recommendation_preferences

#' Returns the optimization findings for an account
#'
#' @description
#' Returns the optimization findings for an account.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/get_recommendation_summaries.html](https://paws-r.github.io/docs/computeoptimizer/get_recommendation_summaries.html) for full documentation.
#'
#' @param accountIds The ID of the Amazon Web Services account for which to return
#' recommendation summaries.
#' 
#' If your account is the management account of an organization, use this
#' parameter to specify the member account for which you want to return
#' recommendation summaries.
#' 
#' Only one account ID can be specified per request.
#' @param nextToken The token to advance to the next page of recommendation summaries.
#' @param maxResults The maximum number of recommendation summaries to return with a single
#' request.
#' 
#' To retrieve the remaining results, make another request with the
#' returned `nextToken` value.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_get_recommendation_summaries
computeoptimizer_get_recommendation_summaries <- function(accountIds = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "GetRecommendationSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$get_recommendation_summaries_input(accountIds = accountIds, nextToken = nextToken, maxResults = maxResults)
  output <- .computeoptimizer$get_recommendation_summaries_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$get_recommendation_summaries <- computeoptimizer_get_recommendation_summaries

#' Creates a new recommendation preference or updates an existing
#' recommendation preference, such as enhanced infrastructure metrics
#'
#' @description
#' Creates a new recommendation preference or updates an existing recommendation preference, such as enhanced infrastructure metrics.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/put_recommendation_preferences.html](https://paws-r.github.io/docs/computeoptimizer/put_recommendation_preferences.html) for full documentation.
#'
#' @param resourceType &#91;required&#93; The target resource type of the recommendation preference to create.
#' 
#' The `Ec2Instance` option encompasses standalone instances and instances
#' that are part of Auto Scaling groups. The `AutoScalingGroup` option
#' encompasses only instances that are part of an Auto Scaling group.
#' 
#' The valid values for this parameter are `Ec2Instance` and
#' `AutoScalingGroup`.
#' @param scope An object that describes the scope of the recommendation preference to
#' create.
#' 
#' You can create recommendation preferences at the organization level (for
#' management accounts of an organization only), account level, and
#' resource level. For more information, see [Activating enhanced
#' infrastructure
#' metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html)
#' in the *Compute Optimizer User Guide*.
#' 
#' You cannot create recommendation preferences for Auto Scaling groups at
#' the organization and account levels. You can create recommendation
#' preferences for Auto Scaling groups only at the resource level by
#' specifying a scope name of `ResourceArn` and a scope value of the Auto
#' Scaling group Amazon Resource Name (ARN). This will configure the
#' preference for all instances that are part of the specified Auto Scaling
#' group. You also cannot create recommendation preferences at the resource
#' level for instances that are part of an Auto Scaling group. You can
#' create recommendation preferences at the resource level only for
#' standalone instances.
#' @param enhancedInfrastructureMetrics The status of the enhanced infrastructure metrics recommendation
#' preference to create or update.
#' 
#' Specify the `Active` status to activate the preference, or specify
#' `Inactive` to deactivate the preference.
#' 
#' For more information, see [Enhanced infrastructure
#' metrics](https://docs.aws.amazon.com/compute-optimizer/latest/ug/enhanced-infrastructure-metrics.html)
#' in the *Compute Optimizer User Guide*.
#' @param inferredWorkloadTypes The status of the inferred workload types recommendation preference to
#' create or update.
#' 
#' The inferred workload type feature is active by default. To deactivate
#' it, create a recommendation preference.
#' 
#' Specify the `Inactive` status to deactivate the feature, or specify
#' `Active` to activate it.
#' 
#' For more information, see [Inferred workload
#' types](https://docs.aws.amazon.com/compute-optimizer/latest/ug/) in the
#' *Compute Optimizer User Guide*.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_put_recommendation_preferences
computeoptimizer_put_recommendation_preferences <- function(resourceType, scope = NULL, enhancedInfrastructureMetrics = NULL, inferredWorkloadTypes = NULL) {
  op <- new_operation(
    name = "PutRecommendationPreferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$put_recommendation_preferences_input(resourceType = resourceType, scope = scope, enhancedInfrastructureMetrics = enhancedInfrastructureMetrics, inferredWorkloadTypes = inferredWorkloadTypes)
  output <- .computeoptimizer$put_recommendation_preferences_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$put_recommendation_preferences <- computeoptimizer_put_recommendation_preferences

#' Updates the enrollment (opt in and opt out) status of an account to the
#' Compute Optimizer service
#'
#' @description
#' Updates the enrollment (opt in and opt out) status of an account to the Compute Optimizer service.
#'
#' See [https://paws-r.github.io/docs/computeoptimizer/update_enrollment_status.html](https://paws-r.github.io/docs/computeoptimizer/update_enrollment_status.html) for full documentation.
#'
#' @param status &#91;required&#93; The new enrollment status of the account.
#' 
#' The following status options are available:
#' 
#' -   `Active` - Opts in your account to the Compute Optimizer service.
#'     Compute Optimizer begins analyzing the configuration and utilization
#'     metrics of your Amazon Web Services resources after you opt in. For
#'     more information, see [Metrics analyzed by Compute
#'     Optimizer](https://docs.aws.amazon.com/compute-optimizer/latest/ug/metrics.html)
#'     in the *Compute Optimizer User Guide*.
#' 
#' -   `Inactive` - Opts out your account from the Compute Optimizer
#'     service. Your account's recommendations and related metrics data
#'     will be deleted from Compute Optimizer after you opt out.
#' 
#' The `Pending` and `Failed` options cannot be used to update the
#' enrollment status of an account. They are returned in the response of a
#' request to update the enrollment status of an account.
#' @param includeMemberAccounts Indicates whether to enroll member accounts of the organization if the
#' account is the management account of an organization.
#'
#' @keywords internal
#'
#' @rdname computeoptimizer_update_enrollment_status
computeoptimizer_update_enrollment_status <- function(status, includeMemberAccounts = NULL) {
  op <- new_operation(
    name = "UpdateEnrollmentStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .computeoptimizer$update_enrollment_status_input(status = status, includeMemberAccounts = includeMemberAccounts)
  output <- .computeoptimizer$update_enrollment_status_output()
  config <- get_config()
  svc <- .computeoptimizer$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.computeoptimizer$operations$update_enrollment_status <- computeoptimizer_update_enrollment_status
