% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_update_relational_database_parameters}
\alias{lightsail_update_relational_database_parameters}
\title{Allows the update of one or more parameters of a database in Amazon
Lightsail}
\usage{
lightsail_update_relational_database_parameters(relationalDatabaseName,
  parameters)
}
\arguments{
\item{relationalDatabaseName}{[required] The name of your database for which to update parameters.}

\item{parameters}{[required] The database parameters to update.}
}
\description{
Allows the update of one or more parameters of a database in Amazon
Lightsail.
}
\details{
Parameter updates don\'t cause outages; therefore, their application is
not subject to the preferred maintenance window. However, there are two
ways in which parameter updates are applied: \code{dynamic} or
\code{pending-reboot}. Parameters marked with a \code{dynamic} apply type are
applied immediately. Parameters marked with a \code{pending-reboot} apply
type are applied only after the database is rebooted using the
\verb{reboot relational database} operation.

The \verb{update relational database parameters} operation supports tag-based
access control via resource tags applied to the resource identified by
relationalDatabaseName. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_relational_database_parameters(
  relationalDatabaseName = "string",
  parameters = list(
    list(
      allowedValues = "string",
      applyMethod = "string",
      applyType = "string",
      dataType = "string",
      description = "string",
      isModifiable = TRUE|FALSE,
      parameterName = "string",
      parameterValue = "string"
    )
  )
)
}
}

\keyword{internal}
