% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_regions}
\alias{lightsail_get_regions}
\title{Returns a list of all valid regions for Amazon Lightsail}
\usage{
lightsail_get_regions(includeAvailabilityZones,
  includeRelationalDatabaseAvailabilityZones)
}
\arguments{
\item{includeAvailabilityZones}{A Boolean value indicating whether to also include Availability Zones in
your get regions request. Availability Zones are indicated with a
letter: e.g., \code{us-east-2a}.}

\item{includeRelationalDatabaseAvailabilityZones}{\>A Boolean value indicating whether to also include Availability Zones
for databases in your get regions request. Availability Zones are
indicated with a letter (e.g., \code{us-east-2a}).}
}
\description{
Returns a list of all valid regions for Amazon Lightsail. Use the
\code{include availability zones} parameter to also return the Availability
Zones in a region.
}
\section{Request syntax}{
\preformatted{svc$get_regions(
  includeAvailabilityZones = TRUE|FALSE,
  includeRelationalDatabaseAvailabilityZones = TRUE|FALSE
)
}
}

\keyword{internal}
