% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_register_instance_event_notification_attributes}
\alias{ec2_register_instance_event_notification_attributes}
\title{Registers a set of tag keys to include in scheduled event notifications
for your resources}
\usage{
ec2_register_instance_event_notification_attributes(DryRun,
  InstanceTagAttribute)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{InstanceTagAttribute}{Information about the tag keys to register.}
}
\value{
A list with the following syntax:\preformatted{list(
  InstanceTagAttribute = list(
    InstanceTagKeys = list(
      "string"
    ),
    IncludeAllTagsOfInstance = TRUE|FALSE
  )
)
}
}
\description{
Registers a set of tag keys to include in scheduled event notifications
for your resources.

To remove tags, use .
}
\section{Request syntax}{
\preformatted{svc$register_instance_event_notification_attributes(
  DryRun = TRUE|FALSE,
  InstanceTagAttribute = list(
    IncludeAllTagsOfInstance = TRUE|FALSE,
    InstanceTagKeys = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
