% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_export_tasks}
\alias{ec2_describe_export_tasks}
\title{Describes the specified export instance tasks or all of your export
instance tasks}
\usage{
ec2_describe_export_tasks(ExportTaskIds, Filters)
}
\arguments{
\item{ExportTaskIds}{The export task IDs.}

\item{Filters}{the filters for the export tasks.}
}
\value{
A list with the following syntax:\preformatted{list(
  ExportTasks = list(
    list(
      Description = "string",
      ExportTaskId = "string",
      ExportToS3Task = list(
        ContainerFormat = "ova",
        DiskImageFormat = "VMDK"|"RAW"|"VHD",
        S3Bucket = "string",
        S3Key = "string"
      ),
      InstanceExportDetails = list(
        InstanceId = "string",
        TargetEnvironment = "citrix"|"vmware"|"microsoft"
      ),
      State = "active"|"cancelling"|"cancelled"|"completed",
      StatusMessage = "string",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}
\description{
Describes the specified export instance tasks or all of your export
instance tasks.
}
\section{Request syntax}{
\preformatted{svc$describe_export_tasks(
  ExportTaskIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
