% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_relational_database_from_snapshot}
\alias{lightsail_create_relational_database_from_snapshot}
\title{Creates a new database from an existing database snapshot in Amazon
Lightsail}
\usage{
lightsail_create_relational_database_from_snapshot(
  relationalDatabaseName, availabilityZone, publiclyAccessible,
  relationalDatabaseSnapshotName, relationalDatabaseBundleId,
  sourceRelationalDatabaseName, restoreTime, useLatestRestorableTime,
  tags)
}
\arguments{
\item{relationalDatabaseName}{[required] The name to use for your new database.

Constraints:
\itemize{
\item Must contain from 2 to 255 alphanumeric characters, or hyphens.
\item The first and last character must be a letter or number.
}}

\item{availabilityZone}{The Availability Zone in which to create your new database. Use the
\verb{us-east-2a} case-sensitive format.

You can get a list of Availability Zones by using the \verb{get regions}
operation. Be sure to add the
\verb{include relational database Availability Zones} parameter to your
request.}

\item{publiclyAccessible}{Specifies the accessibility options for your new database. A value of
\code{true} specifies a database that is available to resources outside of
your Lightsail account. A value of \code{false} specifies a database that is
available only to your Lightsail resources in the same region as your
database.}

\item{relationalDatabaseSnapshotName}{The name of the database snapshot from which to create your new
database.}

\item{relationalDatabaseBundleId}{The bundle ID for your new database. A bundle describes the performance
specifications for your database.

You can get a list of database bundle IDs by using the
\verb{get relational database bundles} operation.

When creating a new database from a snapshot, you cannot choose a bundle
that is smaller than the bundle of the source database.}

\item{sourceRelationalDatabaseName}{The name of the source database.}

\item{restoreTime}{The date and time to restore your database from.

Constraints:
\itemize{
\item Must be before the latest restorable time for the database.
\item Cannot be specified if the \verb{use latest restorable time} parameter is
\code{true}.
\item Specified in Coordinated Universal Time (UTC).
\item Specified in the Unix time format.

For example, if you wish to use a restore time of October 1, 2018,
at 8 PM UTC, then you input \code{1538424000} as the restore time.
}}

\item{useLatestRestorableTime}{Specifies whether your database is restored from the latest backup time.
A value of \code{true} restores from the latest backup time.

Default: \code{false}

Constraints: Cannot be specified if the \verb{restore time} parameter is
provided.}

\item{tags}{The tag keys and optional values to add to the resource during create.

Use the \code{\link[=lightsail_tag_resource]{tag_resource}} action to tag a
resource after it's created.}
}
\value{
A list with the following syntax:\preformatted{list(
  operations = list(
    list(
      id = "string",
      resourceName = "string",
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      isTerminal = TRUE|FALSE,
      operationDetails = "string",
      operationType = "DeleteKnownHostKeys"|"DeleteInstance"|"CreateInstance"|"StopInstance"|"StartInstance"|"RebootInstance"|"OpenInstancePublicPorts"|"PutInstancePublicPorts"|"CloseInstancePublicPorts"|"AllocateStaticIp"|"ReleaseStaticIp"|"AttachStaticIp"|"DetachStaticIp"|"UpdateDomainEntry"|"DeleteDomainEntry"|"CreateDomain"|"DeleteDomain"|"CreateInstanceSnapshot"|"DeleteInstanceSnapshot"|"CreateInstancesFromSnapshot"|"CreateLoadBalancer"|"DeleteLoadBalancer"|"AttachInstancesToLoadBalancer"|"DetachInstancesFromLoadBalancer"|"UpdateLoadBalancerAttribute"|"CreateLoadBalancerTlsCertificate"|"DeleteLoadBalancerTlsCertificate"|"AttachLoadBalancerTlsCertificate"|"CreateDisk"|"DeleteDisk"|"AttachDisk"|"DetachDisk"|"CreateDiskSnapshot"|"DeleteDiskSnapshot"|"CreateDiskFromSnapshot"|"CreateRelationalDatabase"|"UpdateRelationalDatabase"|"DeleteRelationalDatabase"|"CreateRelationalDatabaseFromSnapshot"|"CreateRelationalDatabaseSnapshot"|"DeleteRelationalDatabaseSnapshot"|"UpdateRelationalDatabaseParameters"|"StartRelationalDatabase"|"RebootRelationalDatabase"|"StopRelationalDatabase"|"EnableAddOn"|"DisableAddOn"|"PutAlarm"|"GetAlarms"|"DeleteAlarm"|"TestAlarm"|"CreateContactMethod"|"GetContactMethods"|"SendContactMethodVerification"|"DeleteContactMethod"|"CreateDistribution"|"UpdateDistribution"|"DeleteDistribution"|"ResetDistributionCache"|"AttachCertificateToDistribution"|"DetachCertificateFromDistribution"|"UpdateDistributionBundle"|"CreateCertificate"|"DeleteCertificate"|"CreateContainerService"|"UpdateContainerService"|"DeleteContainerService"|"CreateContainerServiceDeployment"|"CreateContainerServiceRegistryLogin"|"RegisterContainerImage"|"DeleteContainerImage",
      status = "NotStarted"|"Started"|"Failed"|"Completed"|"Succeeded",
      statusChangedAt = as.POSIXct(
        "2015-01-01"
      ),
      errorCode = "string",
      errorDetails = "string"
    )
  )
)
}
}
\description{
Creates a new database from an existing database snapshot in Amazon
Lightsail.

You can create a new database from a snapshot in if something goes wrong
with your original database, or to change it to a different plan, such
as a high availability or standard plan.

The \verb{create relational database from snapshot} operation supports
tag-based access control via request tags and resource tags applied to
the resource identified by relationalDatabaseSnapshotName. For more
information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_relational_database_from_snapshot(
  relationalDatabaseName = "string",
  availabilityZone = "string",
  publiclyAccessible = TRUE|FALSE,
  relationalDatabaseSnapshotName = "string",
  relationalDatabaseBundleId = "string",
  sourceRelationalDatabaseName = "string",
  restoreTime = as.POSIXct(
    "2015-01-01"
  ),
  useLatestRestorableTime = TRUE|FALSE,
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
