% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eks_operations.R
\name{eks_describe_cluster}
\alias{eks_describe_cluster}
\title{Returns descriptive information about an Amazon EKS cluster}
\usage{
eks_describe_cluster(name)
}
\arguments{
\item{name}{[required] The name of the cluster to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  cluster = list(
    name = "string",
    arn = "string",
    createdAt = as.POSIXct(
      "2015-01-01"
    ),
    version = "string",
    endpoint = "string",
    roleArn = "string",
    resourcesVpcConfig = list(
      subnetIds = list(
        "string"
      ),
      securityGroupIds = list(
        "string"
      ),
      clusterSecurityGroupId = "string",
      vpcId = "string",
      endpointPublicAccess = TRUE|FALSE,
      endpointPrivateAccess = TRUE|FALSE,
      publicAccessCidrs = list(
        "string"
      )
    ),
    kubernetesNetworkConfig = list(
      serviceIpv4Cidr = "string"
    ),
    logging = list(
      clusterLogging = list(
        list(
          types = list(
            "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
          ),
          enabled = TRUE|FALSE
        )
      )
    ),
    identity = list(
      oidc = list(
        issuer = "string"
      )
    ),
    status = "CREATING"|"ACTIVE"|"DELETING"|"FAILED"|"UPDATING",
    certificateAuthority = list(
      data = "string"
    ),
    clientRequestToken = "string",
    platformVersion = "string",
    tags = list(
      "string"
    ),
    encryptionConfig = list(
      list(
        resources = list(
          "string"
        ),
        provider = list(
          keyArn = "string"
        )
      )
    )
  )
)
}
}
\description{
Returns descriptive information about an Amazon EKS cluster.

The API server endpoint and certificate authority data returned by this
operation are required for \code{kubelet} and \code{kubectl} to communicate with
your Kubernetes API server. For more information, see \href{https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html}{Create a kubeconfig for Amazon EKS}.

The API server endpoint and certificate authority data aren't available
until the cluster reaches the \code{ACTIVE} state.
}
\section{Request syntax}{
\preformatted{svc$describe_cluster(
  name = "string"
)
}
}

\examples{
\dontrun{
# This example command provides a description of the specified cluster in
# your default region.
svc$describe_cluster(
  name = "devel"
)
}

}
\keyword{internal}
