% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_transit_gateway_route}
\alias{ec2_delete_transit_gateway_route}
\title{Deletes the specified route from the specified transit gateway route
table}
\usage{
ec2_delete_transit_gateway_route(TransitGatewayRouteTableId,
  DestinationCidrBlock, DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{DestinationCidrBlock}{[required] The CIDR range for the route. This must match the CIDR for the route
exactly.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Route = list(
    DestinationCidrBlock = "string",
    PrefixListId = "string",
    TransitGatewayAttachments = list(
      list(
        ResourceId = "string",
        TransitGatewayAttachmentId = "string",
        ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering"
      )
    ),
    Type = "static"|"propagated",
    State = "pending"|"active"|"blackhole"|"deleting"|"deleted"
  )
)
}
}
\description{
Deletes the specified route from the specified transit gateway route
table.
}
\section{Request syntax}{
\preformatted{svc$delete_transit_gateway_route(
  TransitGatewayRouteTableId = "string",
  DestinationCidrBlock = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
