% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridgescheduler_operations.R
\name{eventbridgescheduler_update_schedule}
\alias{eventbridgescheduler_update_schedule}
\title{Updates the specified schedule}
\usage{
eventbridgescheduler_update_schedule(
  ActionAfterCompletion = NULL,
  ClientToken = NULL,
  Description = NULL,
  EndDate = NULL,
  FlexibleTimeWindow,
  GroupName = NULL,
  KmsKeyArn = NULL,
  Name,
  ScheduleExpression,
  ScheduleExpressionTimezone = NULL,
  StartDate = NULL,
  State = NULL,
  Target
)
}
\arguments{
\item{ActionAfterCompletion}{Specifies the action that EventBridge Scheduler applies to the schedule
after the schedule completes invoking the target.}

\item{ClientToken}{Unique, case-sensitive identifier you provide to ensure the idempotency
of the request. If you do not specify a client token, EventBridge
Scheduler uses a randomly generated token for the request to ensure
idempotency.}

\item{Description}{The description you specify for the schedule.}

\item{EndDate}{The date, in UTC, before which the schedule can invoke its target.
Depending on the schedule's recurrence expression, invocations might
stop on, or before, the \code{EndDate} you specify. EventBridge Scheduler
ignores \code{EndDate} for one-time schedules.}

\item{FlexibleTimeWindow}{[required] Allows you to configure a time window during which EventBridge Scheduler
invokes the schedule.}

\item{GroupName}{The name of the schedule group with which the schedule is associated.
You must provide this value in order for EventBridge Scheduler to find
the schedule you want to update. If you omit this value, EventBridge
Scheduler assumes the group is associated to the default group.}

\item{KmsKeyArn}{The ARN for the customer managed KMS key that that you want EventBridge
Scheduler to use to encrypt and decrypt your data.}

\item{Name}{[required] The name of the schedule that you are updating.}

\item{ScheduleExpression}{[required] The expression that defines when the schedule runs. The following
formats are supported.
\itemize{
\item \code{at} expression - \code{at(yyyy-mm-ddThh:mm:ss)}
\item \code{rate} expression - \verb{rate(value unit)}
\item \code{cron} expression - \code{cron(fields)}
}

You can use \code{at} expressions to create one-time schedules that invoke a
target once, at the time and in the time zone, that you specify. You can
use \code{rate} and \code{cron} expressions to create recurring schedules.
Rate-based schedules are useful when you want to invoke a target at
regular intervals, such as every 15 minutes or every five days.
Cron-based schedules are useful when you want to invoke a target
periodically at a specific time, such as at 8:00 am (UTC+0) every 1st
day of the month.

A \code{cron} expression consists of six fields separated by white spaces:
\verb{(minutes hours day_of_month month day_of_week year)}.

A \code{rate} expression consists of a \emph{value} as a positive integer, and a
\emph{unit} with the following options: \code{minute} | \code{minutes} | \code{hour} |
\code{hours} | \code{day} | \code{days}

For more information and examples, see \href{https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html}{Schedule types on EventBridge Scheduler}
in the \emph{EventBridge Scheduler User Guide}.}

\item{ScheduleExpressionTimezone}{The timezone in which the scheduling expression is evaluated.}

\item{StartDate}{The date, in UTC, after which the schedule can begin invoking its
target. Depending on the schedule's recurrence expression, invocations
might occur on, or after, the \code{StartDate} you specify. EventBridge
Scheduler ignores \code{StartDate} for one-time schedules.}

\item{State}{Specifies whether the schedule is enabled or disabled.}

\item{Target}{[required] The schedule target. You can use this operation to change the target
that your schedule invokes.}
}
\description{
Updates the specified schedule. When you call \code{\link[=eventbridgescheduler_update_schedule]{update_schedule}}, EventBridge Scheduler uses all values, including empty values, specified in the request and overrides the existing schedule. This is by design. This means that if you do not set an optional field in your request, that field will be set to its system-default value after the update.

See \url{https://www.paws-r-sdk.com/docs/eventbridgescheduler_update_schedule/} for full documentation.
}
\keyword{internal}
