% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eventbridge_operations.R
\name{eventbridge_remove_permission}
\alias{eventbridge_remove_permission}
\title{Revokes the permission of another AWS account to be able to put events
to the specified event bus}
\usage{
eventbridge_remove_permission(StatementId, RemoveAllPermissions,
  EventBusName)
}
\arguments{
\item{StatementId}{The statement ID corresponding to the account that is no longer allowed
to put events to the default event bus.}

\item{RemoveAllPermissions}{Specifies whether to remove all permissions.}

\item{EventBusName}{The name of the event bus to revoke permissions for. If you omit this,
the default event bus is used.}
}
\description{
Revokes the permission of another AWS account to be able to put events
to the specified event bus. Specify the account to revoke by the
\code{StatementId} value that you associated with the account when you
granted it permission with \code{PutPermission}. You can find the
\code{StatementId} by using DescribeEventBus.
}
\section{Request syntax}{
\preformatted{svc$remove_permission(
  StatementId = "string",
  RemoveAllPermissions = TRUE|FALSE,
  EventBusName = "string"
)
}
}

\keyword{internal}
