% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqs_operations.R
\name{sqs_untag_queue}
\alias{sqs_untag_queue}
\title{Remove cost allocation tags from the specified Amazon SQS queue}
\usage{
sqs_untag_queue(QueueUrl, TagKeys)
}
\arguments{
\item{QueueUrl}{[required] The URL of the queue.}

\item{TagKeys}{[required] The list of tags to be removed from the specified queue.}
}
\description{
Remove cost allocation tags from the specified Amazon SQS queue. For an
overview, see \href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-queue-tags.html}{Tagging Your Amazon SQS Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\details{
When you use queue tags, keep the following guidelines in mind:
\itemize{
\item Adding more than 50 tags to a queue isn't recommended.
\item Tags don't have any semantic meaning. Amazon SQS interprets tags as
character strings.
\item Tags are case-sensitive.
\item A new tag with a key identical to that of an existing tag overwrites
the existing tag.
\item Tagging actions are limited to 5 TPS per AWS account. If your
application requires a higher throughput, file a \href{https://console.aws.amazon.com/support/home#/case/create?issueType=technical}{technical support request}.
}

For a full list of tag restrictions, see \href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-limits.html#limits-queues}{Limits Related to Queues}
in the \emph{Amazon Simple Queue Service Developer Guide}.

Cross-account permissions don't apply to this action. For more
information, see see \href{http://docs.aws.amazon.com/AWSSimpleQueueService/latest/SQSDeveloperGuide/sqs-customer-managed-policy-examples.html#grant-cross-account-permissions-to-role-and-user-name}{Grant Cross-Account Permissions to a Role and a User Name}
in the \emph{Amazon Simple Queue Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$untag_queue(
  QueueUrl = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
