% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesis_operations.R
\name{kinesis_enable_enhanced_monitoring}
\alias{kinesis_enable_enhanced_monitoring}
\title{Enables enhanced Kinesis data stream monitoring for shard-level metrics}
\usage{
kinesis_enable_enhanced_monitoring(
  StreamName = NULL,
  ShardLevelMetrics,
  StreamARN = NULL
)
}
\arguments{
\item{StreamName}{The name of the stream for which to enable enhanced monitoring.}

\item{ShardLevelMetrics}{[required] List of shard-level metrics to enable.

The following are the valid shard-level metrics. The value "\code{ALL}"
enables every metric.
\itemize{
\item \code{IncomingBytes}
\item \code{IncomingRecords}
\item \code{OutgoingBytes}
\item \code{OutgoingRecords}
\item \code{WriteProvisionedThroughputExceeded}
\item \code{ReadProvisionedThroughputExceeded}
\item \code{IteratorAgeMilliseconds}
\item \code{ALL}
}

For more information, see \href{https://docs.aws.amazon.com/streams/latest/dev/monitoring-with-cloudwatch.html}{Monitoring the Amazon Kinesis Data Streams Service with Amazon CloudWatch}
in the \emph{Amazon Kinesis Data Streams Developer Guide}.}

\item{StreamARN}{The ARN of the stream.}
}
\description{
Enables enhanced Kinesis data stream monitoring for shard-level metrics.

See \url{https://www.paws-r-sdk.com/docs/kinesis_enable_enhanced_monitoring/} for full documentation.
}
\keyword{internal}
