% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emr_operations.R
\name{emr_delete_studio_session_mapping}
\alias{emr_delete_studio_session_mapping}
\title{Removes a user or group from an Amazon EMR Studio}
\usage{
emr_delete_studio_session_mapping(
  StudioId,
  IdentityId = NULL,
  IdentityName = NULL,
  IdentityType
)
}
\arguments{
\item{StudioId}{[required] The ID of the Amazon EMR Studio.}

\item{IdentityId}{The globally unique identifier (GUID) of the user or group to remove
from the Amazon EMR Studio. For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserId}{UserId}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-GroupId}{GroupId}
in the \emph{IAM Identity Center Identity Store API Reference}. Either
\code{IdentityName} or \code{IdentityId} must be specified.}

\item{IdentityName}{The name of the user name or group to remove from the Amazon EMR Studio.
For more information, see
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_User.html#singlesignon-Type-User-UserName}{UserName}
and
\href{https://docs.aws.amazon.com/singlesignon/latest/IdentityStoreAPIReference/API_Group.html#singlesignon-Type-Group-DisplayName}{DisplayName}
in the \emph{IAM Identity Center Store API Reference}. Either \code{IdentityName}
or \code{IdentityId} must be specified.}

\item{IdentityType}{[required] Specifies whether the identity to delete from the Amazon EMR Studio is a
user or a group.}
}
\description{
Removes a user or group from an Amazon EMR Studio.

See \url{https://www.paws-r-sdk.com/docs/emr_delete_studio_session_mapping/} for full documentation.
}
\keyword{internal}
