% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_operations.R
\name{ivs_create_channel}
\alias{ivs_create_channel}
\title{Creates a new channel and an associated stream key to start streaming}
\usage{
ivs_create_channel(
  name = NULL,
  latencyMode = NULL,
  type = NULL,
  authorized = NULL,
  recordingConfigurationArn = NULL,
  tags = NULL,
  insecureIngest = NULL,
  preset = NULL,
  playbackRestrictionPolicyArn = NULL
)
}
\arguments{
\item{name}{Channel name.}

\item{latencyMode}{Channel latency mode. Use \code{NORMAL} to broadcast and deliver live video
up to Full HD. Use \code{LOW} for near-real-time interaction with viewers.
Default: \code{LOW}.}

\item{type}{Channel type, which determines the allowable resolution and bitrate. \emph{If
you exceed the allowable input resolution or bitrate, the stream
probably will disconnect immediately.} Default: \code{STANDARD}. For details,
see \href{https://docs.aws.amazon.com/ivs/latest/LowLatencyAPIReference/channel-types.html}{Channel Types}.}

\item{authorized}{Whether the channel is private (enabled for playback authorization).
Default: \code{false}.}

\item{recordingConfigurationArn}{Recording-configuration ARN. A valid ARN value here both specifies the
ARN and enables recording. Default: "" (empty string, recording is
disabled).}

\item{tags}{Array of 1-50 maps, each of the form \code{string:string (key:value)}. See
\href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}
for more information, including restrictions that apply to tags and "Tag
naming limits and requirements"; Amazon IVS has no service-specific
constraints beyond what is documented there.}

\item{insecureIngest}{Whether the channel allows insecure RTMP and SRT ingest. Default:
\code{false}.}

\item{preset}{Optional transcode preset for the channel. This is selectable only for
\code{ADVANCED_HD} and \code{ADVANCED_SD} channel types. For those channel types,
the default \code{preset} is \code{HIGHER_BANDWIDTH_DELIVERY}. For other channel
types (\code{BASIC} and \code{STANDARD}), \code{preset} is the empty string (\code{""}).}

\item{playbackRestrictionPolicyArn}{Playback-restriction-policy ARN. A valid ARN value here both specifies
the ARN and enables playback restriction. Default: "" (empty string, no
playback restriction policy is applied).}
}
\description{
Creates a new channel and an associated stream key to start streaming.

See \url{https://www.paws-r-sdk.com/docs/ivs_create_channel/} for full documentation.
}
\keyword{internal}
