% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datazone_operations.R
\name{datazone_create_domain}
\alias{datazone_create_domain}
\title{Creates an Amazon DataZone domain}
\usage{
datazone_create_domain(
  clientToken = NULL,
  description = NULL,
  domainExecutionRole,
  kmsKeyIdentifier = NULL,
  name,
  singleSignOn = NULL,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A unique, case-sensitive identifier that is provided to ensure the
idempotency of the request.}

\item{description}{The description of the Amazon DataZone domain.}

\item{domainExecutionRole}{[required] The domain execution role that is created when an Amazon DataZone domain
is created. The domain execution role is created in the Amazon Web
Services account that houses the Amazon DataZone domain.}

\item{kmsKeyIdentifier}{The identifier of the Amazon Web Services Key Management Service (KMS)
key that is used to encrypt the Amazon DataZone domain, metadata, and
reporting data.}

\item{name}{[required] The name of the Amazon DataZone domain.}

\item{singleSignOn}{The single-sign on configuration of the Amazon DataZone domain.}

\item{tags}{The tags specified for the Amazon DataZone domain.}
}
\description{
Creates an Amazon DataZone domain.

See \url{https://www.paws-r-sdk.com/docs/datazone_create_domain/} for full documentation.
}
\keyword{internal}
