# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include datazone_service.R
NULL

#' Accepts automatically generated business-friendly metadata for your
#' Amazon DataZone assets
#'
#' @description
#' Accepts automatically generated business-friendly metadata for your Amazon DataZone assets.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_accept_predictions/](https://www.paws-r-sdk.com/docs/datazone_accept_predictions/) for full documentation.
#'
#' @param acceptChoices Specifies the prediction (aka, the automatically generated piece of
#' metadata) and the target (for example, a column name) that can be
#' accepted.
#' @param acceptRule Specifies the rule (or the conditions) under which a prediction can be
#' accepted.
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request. This field is automatically populated if not provided.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param identifier &#91;required&#93; The identifier of the asset.
#' @param revision The revision that is to be made to the asset.
#'
#' @keywords internal
#'
#' @rdname datazone_accept_predictions
datazone_accept_predictions <- function(acceptChoices = NULL, acceptRule = NULL, clientToken = NULL, domainIdentifier, identifier, revision = NULL) {
  op <- new_operation(
    name = "AcceptPredictions",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}/accept-predictions",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$accept_predictions_input(acceptChoices = acceptChoices, acceptRule = acceptRule, clientToken = clientToken, domainIdentifier = domainIdentifier, identifier = identifier, revision = revision)
  output <- .datazone$accept_predictions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$accept_predictions <- datazone_accept_predictions

#' Accepts a subscription request to a specific asset
#'
#' @description
#' Accepts a subscription request to a specific asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_accept_subscription_request/](https://www.paws-r-sdk.com/docs/datazone_accept_subscription_request/) for full documentation.
#'
#' @param decisionComment A description that specifies the reason for accepting the specified
#' subscription request.
#' @param domainIdentifier &#91;required&#93; The Amazon DataZone domain where the specified subscription request is
#' being accepted.
#' @param identifier &#91;required&#93; The unique identifier of the subscription request that is to be
#' accepted.
#'
#' @keywords internal
#'
#' @rdname datazone_accept_subscription_request
datazone_accept_subscription_request <- function(decisionComment = NULL, domainIdentifier, identifier) {
  op <- new_operation(
    name = "AcceptSubscriptionRequest",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/accept",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$accept_subscription_request_input(decisionComment = decisionComment, domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$accept_subscription_request_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$accept_subscription_request <- datazone_accept_subscription_request

#' Adds the owner of an entity (a domain unit)
#'
#' @description
#' Adds the owner of an entity (a domain unit).
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_add_entity_owner/](https://www.paws-r-sdk.com/docs/datazone_add_entity_owner/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the domain in which you want to add the entity owner.
#' @param entityIdentifier &#91;required&#93; The ID of the entity to which you want to add an owner.
#' @param entityType &#91;required&#93; The type of an entity.
#' @param owner &#91;required&#93; The owner that you want to add to the entity.
#'
#' @keywords internal
#'
#' @rdname datazone_add_entity_owner
datazone_add_entity_owner <- function(clientToken = NULL, domainIdentifier, entityIdentifier, entityType, owner) {
  op <- new_operation(
    name = "AddEntityOwner",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/addOwner",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$add_entity_owner_input(clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, owner = owner)
  output <- .datazone$add_entity_owner_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$add_entity_owner <- datazone_add_entity_owner

#' Adds a policy grant (an authorization policy) to a specified entity,
#' including domain units, environment blueprint configurations, or
#' environment profiles
#'
#' @description
#' Adds a policy grant (an authorization policy) to a specified entity, including domain units, environment blueprint configurations, or environment profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_add_policy_grant/](https://www.paws-r-sdk.com/docs/datazone_add_policy_grant/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param detail &#91;required&#93; The details of the policy grant.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to add a policy grant.
#' @param entityIdentifier &#91;required&#93; The ID of the entity (resource) to which you want to add a policy grant.
#' @param entityType &#91;required&#93; The type of entity (resource) to which the grant is added.
#' @param policyType &#91;required&#93; The type of policy that you want to grant.
#' @param principal &#91;required&#93; The principal to whom the permissions are granted.
#'
#' @keywords internal
#'
#' @rdname datazone_add_policy_grant
datazone_add_policy_grant <- function(clientToken = NULL, detail, domainIdentifier, entityIdentifier, entityType, policyType, principal) {
  op <- new_operation(
    name = "AddPolicyGrant",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/addGrant",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$add_policy_grant_input(clientToken = clientToken, detail = detail, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, policyType = policyType, principal = principal)
  output <- .datazone$add_policy_grant_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$add_policy_grant <- datazone_add_policy_grant

#' Associates the environment role in Amazon DataZone
#'
#' @description
#' Associates the environment role in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_associate_environment_role/](https://www.paws-r-sdk.com/docs/datazone_associate_environment_role/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the environment role is
#' associated.
#' @param environmentIdentifier &#91;required&#93; The ID of the Amazon DataZone environment.
#' @param environmentRoleArn &#91;required&#93; The ARN of the environment role.
#'
#' @keywords internal
#'
#' @rdname datazone_associate_environment_role
datazone_associate_environment_role <- function(domainIdentifier, environmentIdentifier, environmentRoleArn) {
  op <- new_operation(
    name = "AssociateEnvironmentRole",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$associate_environment_role_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, environmentRoleArn = environmentRoleArn)
  output <- .datazone$associate_environment_role_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$associate_environment_role <- datazone_associate_environment_role

#' Cancels the metadata generation run
#'
#' @description
#' Cancels the metadata generation run.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_cancel_metadata_generation_run/](https://www.paws-r-sdk.com/docs/datazone_cancel_metadata_generation_run/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the metadata generation
#' run is to be cancelled.
#' @param identifier &#91;required&#93; The ID of the metadata generation run.
#'
#' @keywords internal
#'
#' @rdname datazone_cancel_metadata_generation_run
datazone_cancel_metadata_generation_run <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "CancelMetadataGenerationRun",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$cancel_metadata_generation_run_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$cancel_metadata_generation_run_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$cancel_metadata_generation_run <- datazone_cancel_metadata_generation_run

#' Cancels the subscription to the specified asset
#'
#' @description
#' Cancels the subscription to the specified asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_cancel_subscription/](https://www.paws-r-sdk.com/docs/datazone_cancel_subscription/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The unique identifier of the Amazon DataZone domain where the
#' subscription request is being cancelled.
#' @param identifier &#91;required&#93; The unique identifier of the subscription that is being cancelled.
#'
#' @keywords internal
#'
#' @rdname datazone_cancel_subscription
datazone_cancel_subscription <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "CancelSubscription",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/subscriptions/{identifier}/cancel",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$cancel_subscription_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$cancel_subscription_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$cancel_subscription <- datazone_cancel_subscription

#' Creates an asset in Amazon DataZone catalog
#'
#' @description
#' Creates an asset in Amazon DataZone catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_asset/](https://www.paws-r-sdk.com/docs/datazone_create_asset/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description Asset description.
#' @param domainIdentifier &#91;required&#93; Amazon DataZone domain where the asset is created.
#' @param externalIdentifier The external identifier of the asset.
#' @param formsInput Metadata forms attached to the asset.
#' @param glossaryTerms Glossary terms attached to the asset.
#' @param name &#91;required&#93; Asset name.
#' @param owningProjectIdentifier &#91;required&#93; The unique identifier of the project that owns this asset.
#' @param predictionConfiguration The configuration of the automatically generated business-friendly
#' metadata for the asset.
#' @param typeIdentifier &#91;required&#93; The unique identifier of this asset's type.
#' @param typeRevision The revision of this asset's type.
#'
#' @keywords internal
#'
#' @rdname datazone_create_asset
datazone_create_asset <- function(clientToken = NULL, description = NULL, domainIdentifier, externalIdentifier = NULL, formsInput = NULL, glossaryTerms = NULL, name, owningProjectIdentifier, predictionConfiguration = NULL, typeIdentifier, typeRevision = NULL) {
  op <- new_operation(
    name = "CreateAsset",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/assets",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_asset_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, externalIdentifier = externalIdentifier, formsInput = formsInput, glossaryTerms = glossaryTerms, name = name, owningProjectIdentifier = owningProjectIdentifier, predictionConfiguration = predictionConfiguration, typeIdentifier = typeIdentifier, typeRevision = typeRevision)
  output <- .datazone$create_asset_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_asset <- datazone_create_asset

#' Creates a data asset filter
#'
#' @description
#' Creates a data asset filter.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_asset_filter/](https://www.paws-r-sdk.com/docs/datazone_create_asset_filter/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The ID of the data asset.
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param configuration &#91;required&#93; The configuration of the asset filter.
#' @param description The description of the asset filter.
#' @param domainIdentifier &#91;required&#93; The ID of the domain in which you want to create an asset filter.
#' @param name &#91;required&#93; The name of the asset filter.
#'
#' @keywords internal
#'
#' @rdname datazone_create_asset_filter
datazone_create_asset_filter <- function(assetIdentifier, clientToken = NULL, configuration, description = NULL, domainIdentifier, name) {
  op <- new_operation(
    name = "CreateAssetFilter",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_asset_filter_input(assetIdentifier = assetIdentifier, clientToken = clientToken, configuration = configuration, description = description, domainIdentifier = domainIdentifier, name = name)
  output <- .datazone$create_asset_filter_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_asset_filter <- datazone_create_asset_filter

#' Creates a revision of the asset
#'
#' @description
#' Creates a revision of the asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_asset_revision/](https://www.paws-r-sdk.com/docs/datazone_create_asset_revision/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The revised description of the asset.
#' @param domainIdentifier &#91;required&#93; The unique identifier of the domain where the asset is being revised.
#' @param formsInput The metadata forms to be attached to the asset as part of asset
#' revision.
#' @param glossaryTerms The glossary terms to be attached to the asset as part of asset
#' revision.
#' @param identifier &#91;required&#93; The identifier of the asset.
#' @param name &#91;required&#93; Te revised name of the asset.
#' @param predictionConfiguration The configuration of the automatically generated business-friendly
#' metadata for the asset.
#' @param typeRevision The revision type of the asset.
#'
#' @keywords internal
#'
#' @rdname datazone_create_asset_revision
datazone_create_asset_revision <- function(clientToken = NULL, description = NULL, domainIdentifier, formsInput = NULL, glossaryTerms = NULL, identifier, name, predictionConfiguration = NULL, typeRevision = NULL) {
  op <- new_operation(
    name = "CreateAssetRevision",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}/revisions",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_asset_revision_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, formsInput = formsInput, glossaryTerms = glossaryTerms, identifier = identifier, name = name, predictionConfiguration = predictionConfiguration, typeRevision = typeRevision)
  output <- .datazone$create_asset_revision_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_asset_revision <- datazone_create_asset_revision

#' Creates a custom asset type
#'
#' @description
#' Creates a custom asset type.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_asset_type/](https://www.paws-r-sdk.com/docs/datazone_create_asset_type/) for full documentation.
#'
#' @param description The descripton of the custom asset type.
#' @param domainIdentifier &#91;required&#93; The unique identifier of the Amazon DataZone domain where the custom
#' asset type is being created.
#' @param formsInput &#91;required&#93; The metadata forms that are to be attached to the custom asset type.
#' @param name &#91;required&#93; The name of the custom asset type.
#' @param owningProjectIdentifier &#91;required&#93; The identifier of the Amazon DataZone project that is to own the custom
#' asset type.
#'
#' @keywords internal
#'
#' @rdname datazone_create_asset_type
datazone_create_asset_type <- function(description = NULL, domainIdentifier, formsInput, name, owningProjectIdentifier) {
  op <- new_operation(
    name = "CreateAssetType",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/asset-types",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_asset_type_input(description = description, domainIdentifier = domainIdentifier, formsInput = formsInput, name = name, owningProjectIdentifier = owningProjectIdentifier)
  output <- .datazone$create_asset_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_asset_type <- datazone_create_asset_type

#' Creates a data product
#'
#' @description
#' Creates a data product.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_data_product/](https://www.paws-r-sdk.com/docs/datazone_create_data_product/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description of the data product.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where the data product is created.
#' @param formsInput The metadata forms of the data product.
#' @param glossaryTerms The glossary terms of the data product.
#' @param items The data assets of the data product.
#' @param name &#91;required&#93; The name of the data product.
#' @param owningProjectIdentifier &#91;required&#93; The ID of the owning project of the data product.
#'
#' @keywords internal
#'
#' @rdname datazone_create_data_product
datazone_create_data_product <- function(clientToken = NULL, description = NULL, domainIdentifier, formsInput = NULL, glossaryTerms = NULL, items = NULL, name, owningProjectIdentifier) {
  op <- new_operation(
    name = "CreateDataProduct",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/data-products",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_data_product_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, formsInput = formsInput, glossaryTerms = glossaryTerms, items = items, name = name, owningProjectIdentifier = owningProjectIdentifier)
  output <- .datazone$create_data_product_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_data_product <- datazone_create_data_product

#' Creates a data product revision
#'
#' @description
#' Creates a data product revision.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_data_product_revision/](https://www.paws-r-sdk.com/docs/datazone_create_data_product_revision/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description of the data product revision.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where the data product revision is created.
#' @param formsInput The metadata forms of the data product revision.
#' @param glossaryTerms The glossary terms of the data product revision.
#' @param identifier &#91;required&#93; The ID of the data product revision.
#' @param items The data assets of the data product revision.
#' @param name &#91;required&#93; The name of the data product revision.
#'
#' @keywords internal
#'
#' @rdname datazone_create_data_product_revision
datazone_create_data_product_revision <- function(clientToken = NULL, description = NULL, domainIdentifier, formsInput = NULL, glossaryTerms = NULL, identifier, items = NULL, name) {
  op <- new_operation(
    name = "CreateDataProductRevision",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/data-products/{identifier}/revisions",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_data_product_revision_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, formsInput = formsInput, glossaryTerms = glossaryTerms, identifier = identifier, items = items, name = name)
  output <- .datazone$create_data_product_revision_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_data_product_revision <- datazone_create_data_product_revision

#' Creates an Amazon DataZone data source
#'
#' @description
#' Creates an Amazon DataZone data source.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_data_source/](https://www.paws-r-sdk.com/docs/datazone_create_data_source/) for full documentation.
#'
#' @param assetFormsInput The metadata forms that are to be attached to the assets that this data
#' source works with.
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param configuration Specifies the configuration of the data source. It can be set to either
#' `glueRunConfiguration` or `redshiftRunConfiguration`.
#' @param description The description of the data source.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where the data source is created.
#' @param enableSetting Specifies whether the data source is enabled.
#' @param environmentIdentifier &#91;required&#93; The unique identifier of the Amazon DataZone environment to which the
#' data source publishes assets.
#' @param name &#91;required&#93; The name of the data source.
#' @param projectIdentifier &#91;required&#93; The identifier of the Amazon DataZone project in which you want to add
#' this data source.
#' @param publishOnImport Specifies whether the assets that this data source creates in the
#' inventory are to be also automatically published to the catalog.
#' @param recommendation Specifies whether the business name generation is to be enabled for this
#' data source.
#' @param schedule The schedule of the data source runs.
#' @param type &#91;required&#93; The type of the data source.
#'
#' @keywords internal
#'
#' @rdname datazone_create_data_source
datazone_create_data_source <- function(assetFormsInput = NULL, clientToken = NULL, configuration = NULL, description = NULL, domainIdentifier, enableSetting = NULL, environmentIdentifier, name, projectIdentifier, publishOnImport = NULL, recommendation = NULL, schedule = NULL, type) {
  op <- new_operation(
    name = "CreateDataSource",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/data-sources",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_data_source_input(assetFormsInput = assetFormsInput, clientToken = clientToken, configuration = configuration, description = description, domainIdentifier = domainIdentifier, enableSetting = enableSetting, environmentIdentifier = environmentIdentifier, name = name, projectIdentifier = projectIdentifier, publishOnImport = publishOnImport, recommendation = recommendation, schedule = schedule, type = type)
  output <- .datazone$create_data_source_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_data_source <- datazone_create_data_source

#' Creates an Amazon DataZone domain
#'
#' @description
#' Creates an Amazon DataZone domain.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_domain/](https://www.paws-r-sdk.com/docs/datazone_create_domain/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description of the Amazon DataZone domain.
#' @param domainExecutionRole &#91;required&#93; The domain execution role that is created when an Amazon DataZone domain
#' is created. The domain execution role is created in the Amazon Web
#' Services account that houses the Amazon DataZone domain.
#' @param kmsKeyIdentifier The identifier of the Amazon Web Services Key Management Service (KMS)
#' key that is used to encrypt the Amazon DataZone domain, metadata, and
#' reporting data.
#' @param name &#91;required&#93; The name of the Amazon DataZone domain.
#' @param singleSignOn The single-sign on configuration of the Amazon DataZone domain.
#' @param tags The tags specified for the Amazon DataZone domain.
#'
#' @keywords internal
#'
#' @rdname datazone_create_domain
datazone_create_domain <- function(clientToken = NULL, description = NULL, domainExecutionRole, kmsKeyIdentifier = NULL, name, singleSignOn = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDomain",
    http_method = "POST",
    http_path = "/v2/domains",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_domain_input(clientToken = clientToken, description = description, domainExecutionRole = domainExecutionRole, kmsKeyIdentifier = kmsKeyIdentifier, name = name, singleSignOn = singleSignOn, tags = tags)
  output <- .datazone$create_domain_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_domain <- datazone_create_domain

#' Creates a domain unit in Amazon DataZone
#'
#' @description
#' Creates a domain unit in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_domain_unit/](https://www.paws-r-sdk.com/docs/datazone_create_domain_unit/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description of the domain unit.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to crate a domain unit.
#' @param name &#91;required&#93; The name of the domain unit.
#' @param parentDomainUnitIdentifier &#91;required&#93; The ID of the parent domain unit.
#'
#' @keywords internal
#'
#' @rdname datazone_create_domain_unit
datazone_create_domain_unit <- function(clientToken = NULL, description = NULL, domainIdentifier, name, parentDomainUnitIdentifier) {
  op <- new_operation(
    name = "CreateDomainUnit",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/domain-units",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_domain_unit_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, name = name, parentDomainUnitIdentifier = parentDomainUnitIdentifier)
  output <- .datazone$create_domain_unit_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_domain_unit <- datazone_create_domain_unit

#' Create an Amazon DataZone environment
#'
#' @description
#' Create an Amazon DataZone environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_environment/](https://www.paws-r-sdk.com/docs/datazone_create_environment/) for full documentation.
#'
#' @param description The description of the Amazon DataZone environment.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which the environment is
#' created.
#' @param environmentAccountIdentifier The ID of the account in which the environment is being created.
#' @param environmentAccountRegion The region of the account in which the environment is being created.
#' @param environmentBlueprintIdentifier The ID of the blueprint with which the environment is being created.
#' @param environmentProfileIdentifier &#91;required&#93; The identifier of the environment profile that is used to create this
#' Amazon DataZone environment.
#' @param glossaryTerms The glossary terms that can be used in this Amazon DataZone environment.
#' @param name &#91;required&#93; The name of the Amazon DataZone environment.
#' @param projectIdentifier &#91;required&#93; The identifier of the Amazon DataZone project in which this environment
#' is created.
#' @param userParameters The user parameters of this Amazon DataZone environment.
#'
#' @keywords internal
#'
#' @rdname datazone_create_environment
datazone_create_environment <- function(description = NULL, domainIdentifier, environmentAccountIdentifier = NULL, environmentAccountRegion = NULL, environmentBlueprintIdentifier = NULL, environmentProfileIdentifier, glossaryTerms = NULL, name, projectIdentifier, userParameters = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/environments",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_environment_input(description = description, domainIdentifier = domainIdentifier, environmentAccountIdentifier = environmentAccountIdentifier, environmentAccountRegion = environmentAccountRegion, environmentBlueprintIdentifier = environmentBlueprintIdentifier, environmentProfileIdentifier = environmentProfileIdentifier, glossaryTerms = glossaryTerms, name = name, projectIdentifier = projectIdentifier, userParameters = userParameters)
  output <- .datazone$create_environment_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_environment <- datazone_create_environment

#' Creates an action for the environment, for example, creates a console
#' link for an analytics tool that is available in this environment
#'
#' @description
#' Creates an action for the environment, for example, creates a console link for an analytics tool that is available in this environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_environment_action/](https://www.paws-r-sdk.com/docs/datazone_create_environment_action/) for full documentation.
#'
#' @param description The description of the environment action that is being created in the
#' environment.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the environment action is
#' created.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment in which the environment action is created.
#' @param name &#91;required&#93; The name of the environment action.
#' @param parameters &#91;required&#93; The parameters of the environment action.
#'
#' @keywords internal
#'
#' @rdname datazone_create_environment_action
datazone_create_environment_action <- function(description = NULL, domainIdentifier, environmentIdentifier, name, parameters) {
  op <- new_operation(
    name = "CreateEnvironmentAction",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_environment_action_input(description = description, domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, name = name, parameters = parameters)
  output <- .datazone$create_environment_action_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_environment_action <- datazone_create_environment_action

#' Creates an Amazon DataZone environment profile
#'
#' @description
#' Creates an Amazon DataZone environment profile.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_environment_profile/](https://www.paws-r-sdk.com/docs/datazone_create_environment_profile/) for full documentation.
#'
#' @param awsAccountId The Amazon Web Services account in which the Amazon DataZone environment
#' is created.
#' @param awsAccountRegion The Amazon Web Services region in which this environment profile is
#' created.
#' @param description The description of this Amazon DataZone environment profile.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this environment profile
#' is created.
#' @param environmentBlueprintIdentifier &#91;required&#93; The ID of the blueprint with which this environment profile is created.
#' @param name &#91;required&#93; The name of this Amazon DataZone environment profile.
#' @param projectIdentifier &#91;required&#93; The identifier of the project in which to create the environment
#' profile.
#' @param userParameters The user parameters of this Amazon DataZone environment profile.
#'
#' @keywords internal
#'
#' @rdname datazone_create_environment_profile
datazone_create_environment_profile <- function(awsAccountId = NULL, awsAccountRegion = NULL, description = NULL, domainIdentifier, environmentBlueprintIdentifier, name, projectIdentifier, userParameters = NULL) {
  op <- new_operation(
    name = "CreateEnvironmentProfile",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/environment-profiles",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_environment_profile_input(awsAccountId = awsAccountId, awsAccountRegion = awsAccountRegion, description = description, domainIdentifier = domainIdentifier, environmentBlueprintIdentifier = environmentBlueprintIdentifier, name = name, projectIdentifier = projectIdentifier, userParameters = userParameters)
  output <- .datazone$create_environment_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_environment_profile <- datazone_create_environment_profile

#' Creates a metadata form type
#'
#' @description
#' Creates a metadata form type.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_form_type/](https://www.paws-r-sdk.com/docs/datazone_create_form_type/) for full documentation.
#'
#' @param description The description of this Amazon DataZone metadata form type.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this metadata form type is
#' created.
#' @param model &#91;required&#93; The model of this Amazon DataZone metadata form type.
#' @param name &#91;required&#93; The name of this Amazon DataZone metadata form type.
#' @param owningProjectIdentifier &#91;required&#93; The ID of the Amazon DataZone project that owns this metadata form type.
#' @param status The status of this Amazon DataZone metadata form type.
#'
#' @keywords internal
#'
#' @rdname datazone_create_form_type
datazone_create_form_type <- function(description = NULL, domainIdentifier, model, name, owningProjectIdentifier, status = NULL) {
  op <- new_operation(
    name = "CreateFormType",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/form-types",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_form_type_input(description = description, domainIdentifier = domainIdentifier, model = model, name = name, owningProjectIdentifier = owningProjectIdentifier, status = status)
  output <- .datazone$create_form_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_form_type <- datazone_create_form_type

#' Creates an Amazon DataZone business glossary
#'
#' @description
#' Creates an Amazon DataZone business glossary.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_glossary/](https://www.paws-r-sdk.com/docs/datazone_create_glossary/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description of this business glossary.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this business glossary is
#' created.
#' @param name &#91;required&#93; The name of this business glossary.
#' @param owningProjectIdentifier &#91;required&#93; The ID of the project that currently owns business glossary.
#' @param status The status of this business glossary.
#'
#' @keywords internal
#'
#' @rdname datazone_create_glossary
datazone_create_glossary <- function(clientToken = NULL, description = NULL, domainIdentifier, name, owningProjectIdentifier, status = NULL) {
  op <- new_operation(
    name = "CreateGlossary",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/glossaries",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_glossary_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, name = name, owningProjectIdentifier = owningProjectIdentifier, status = status)
  output <- .datazone$create_glossary_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_glossary <- datazone_create_glossary

#' Creates a business glossary term
#'
#' @description
#' Creates a business glossary term.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_glossary_term/](https://www.paws-r-sdk.com/docs/datazone_create_glossary_term/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this business glossary
#' term is created.
#' @param glossaryIdentifier &#91;required&#93; The ID of the business glossary in which this term is created.
#' @param longDescription The long description of this business glossary term.
#' @param name &#91;required&#93; The name of this business glossary term.
#' @param shortDescription The short description of this business glossary term.
#' @param status The status of this business glossary term.
#' @param termRelations The term relations of this business glossary term.
#'
#' @keywords internal
#'
#' @rdname datazone_create_glossary_term
datazone_create_glossary_term <- function(clientToken = NULL, domainIdentifier, glossaryIdentifier, longDescription = NULL, name, shortDescription = NULL, status = NULL, termRelations = NULL) {
  op <- new_operation(
    name = "CreateGlossaryTerm",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/glossary-terms",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_glossary_term_input(clientToken = clientToken, domainIdentifier = domainIdentifier, glossaryIdentifier = glossaryIdentifier, longDescription = longDescription, name = name, shortDescription = shortDescription, status = status, termRelations = termRelations)
  output <- .datazone$create_glossary_term_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_glossary_term <- datazone_create_glossary_term

#' Creates a group profile in Amazon DataZone
#'
#' @description
#' Creates a group profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_group_profile/](https://www.paws-r-sdk.com/docs/datazone_create_group_profile/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which the group profile
#' is created.
#' @param groupIdentifier &#91;required&#93; The identifier of the group for which the group profile is created.
#'
#' @keywords internal
#'
#' @rdname datazone_create_group_profile
datazone_create_group_profile <- function(clientToken = NULL, domainIdentifier, groupIdentifier) {
  op <- new_operation(
    name = "CreateGroupProfile",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/group-profiles",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_group_profile_input(clientToken = clientToken, domainIdentifier = domainIdentifier, groupIdentifier = groupIdentifier)
  output <- .datazone$create_group_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_group_profile <- datazone_create_group_profile

#' Publishes a listing (a record of an asset at a given time) or removes a
#' listing from the catalog
#'
#' @description
#' Publishes a listing (a record of an asset at a given time) or removes a listing from the catalog.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_listing_change_set/](https://www.paws-r-sdk.com/docs/datazone_create_listing_change_set/) for full documentation.
#'
#' @param action &#91;required&#93; Specifies whether to publish or unpublish a listing.
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain.
#' @param entityIdentifier &#91;required&#93; The ID of the asset.
#' @param entityRevision The revision of an asset.
#' @param entityType &#91;required&#93; The type of an entity.
#'
#' @keywords internal
#'
#' @rdname datazone_create_listing_change_set
datazone_create_listing_change_set <- function(action, clientToken = NULL, domainIdentifier, entityIdentifier, entityRevision = NULL, entityType) {
  op <- new_operation(
    name = "CreateListingChangeSet",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/listings/change-set",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_listing_change_set_input(action = action, clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityRevision = entityRevision, entityType = entityType)
  output <- .datazone$create_listing_change_set_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_listing_change_set <- datazone_create_listing_change_set

#' Creates an Amazon DataZone project
#'
#' @description
#' Creates an Amazon DataZone project.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_project/](https://www.paws-r-sdk.com/docs/datazone_create_project/) for full documentation.
#'
#' @param description The description of the Amazon DataZone project.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this project is created.
#' @param domainUnitId The ID of the domain unit. This parameter is not required and if it is
#' not specified, then the project is created at the root domain unit
#' level.
#' @param glossaryTerms The glossary terms that can be used in this Amazon DataZone project.
#' @param name &#91;required&#93; The name of the Amazon DataZone project.
#'
#' @keywords internal
#'
#' @rdname datazone_create_project
datazone_create_project <- function(description = NULL, domainIdentifier, domainUnitId = NULL, glossaryTerms = NULL, name) {
  op <- new_operation(
    name = "CreateProject",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/projects",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_project_input(description = description, domainIdentifier = domainIdentifier, domainUnitId = domainUnitId, glossaryTerms = glossaryTerms, name = name)
  output <- .datazone$create_project_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_project <- datazone_create_project

#' Creates a project membership in Amazon DataZone
#'
#' @description
#' Creates a project membership in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_project_membership/](https://www.paws-r-sdk.com/docs/datazone_create_project_membership/) for full documentation.
#'
#' @param designation &#91;required&#93; The designation of the project membership.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which project membership is
#' created.
#' @param member &#91;required&#93; The project member whose project membership was created.
#' @param projectIdentifier &#91;required&#93; The ID of the project for which this project membership was created.
#'
#' @keywords internal
#'
#' @rdname datazone_create_project_membership
datazone_create_project_membership <- function(designation, domainIdentifier, member, projectIdentifier) {
  op <- new_operation(
    name = "CreateProjectMembership",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/createMembership",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_project_membership_input(designation = designation, domainIdentifier = domainIdentifier, member = member, projectIdentifier = projectIdentifier)
  output <- .datazone$create_project_membership_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_project_membership <- datazone_create_project_membership

#' Creates a subsscription grant in Amazon DataZone
#'
#' @description
#' Creates a subsscription grant in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_subscription_grant/](https://www.paws-r-sdk.com/docs/datazone_create_subscription_grant/) for full documentation.
#'
#' @param assetTargetNames The names of the assets for which the subscription grant is created.
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription grant is
#' created.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment in which the subscription grant is created.
#' @param grantedEntity &#91;required&#93; The entity to which the subscription is to be granted.
#' @param subscriptionTargetIdentifier &#91;required&#93; The ID of the subscription target for which the subscription grant is
#' created.
#'
#' @keywords internal
#'
#' @rdname datazone_create_subscription_grant
datazone_create_subscription_grant <- function(assetTargetNames = NULL, clientToken = NULL, domainIdentifier, environmentIdentifier, grantedEntity, subscriptionTargetIdentifier) {
  op <- new_operation(
    name = "CreateSubscriptionGrant",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/subscription-grants",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_subscription_grant_input(assetTargetNames = assetTargetNames, clientToken = clientToken, domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, grantedEntity = grantedEntity, subscriptionTargetIdentifier = subscriptionTargetIdentifier)
  output <- .datazone$create_subscription_grant_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_subscription_grant <- datazone_create_subscription_grant

#' Creates a subscription request in Amazon DataZone
#'
#' @description
#' Creates a subscription request in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_subscription_request/](https://www.paws-r-sdk.com/docs/datazone_create_subscription_request/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription request
#' is created.
#' @param requestReason &#91;required&#93; The reason for the subscription request.
#' @param subscribedListings &#91;required&#93; The published asset for which the subscription grant is to be created.
#' @param subscribedPrincipals &#91;required&#93; The Amazon DataZone principals for whom the subscription request is
#' created.
#'
#' @keywords internal
#'
#' @rdname datazone_create_subscription_request
datazone_create_subscription_request <- function(clientToken = NULL, domainIdentifier, requestReason, subscribedListings, subscribedPrincipals) {
  op <- new_operation(
    name = "CreateSubscriptionRequest",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_subscription_request_input(clientToken = clientToken, domainIdentifier = domainIdentifier, requestReason = requestReason, subscribedListings = subscribedListings, subscribedPrincipals = subscribedPrincipals)
  output <- .datazone$create_subscription_request_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_subscription_request <- datazone_create_subscription_request

#' Creates a subscription target in Amazon DataZone
#'
#' @description
#' Creates a subscription target in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_subscription_target/](https://www.paws-r-sdk.com/docs/datazone_create_subscription_target/) for full documentation.
#'
#' @param applicableAssetTypes &#91;required&#93; The asset types that can be included in the subscription target.
#' @param authorizedPrincipals &#91;required&#93; The authorized principals of the subscription target.
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which subscription target is
#' created.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment in which subscription target is created.
#' @param manageAccessRole &#91;required&#93; The manage access role that is used to create the subscription target.
#' @param name &#91;required&#93; The name of the subscription target.
#' @param provider The provider of the subscription target.
#' @param subscriptionTargetConfig &#91;required&#93; The configuration of the subscription target.
#' @param type &#91;required&#93; The type of the subscription target.
#'
#' @keywords internal
#'
#' @rdname datazone_create_subscription_target
datazone_create_subscription_target <- function(applicableAssetTypes, authorizedPrincipals, clientToken = NULL, domainIdentifier, environmentIdentifier, manageAccessRole, name, provider = NULL, subscriptionTargetConfig, type) {
  op <- new_operation(
    name = "CreateSubscriptionTarget",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_subscription_target_input(applicableAssetTypes = applicableAssetTypes, authorizedPrincipals = authorizedPrincipals, clientToken = clientToken, domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, manageAccessRole = manageAccessRole, name = name, provider = provider, subscriptionTargetConfig = subscriptionTargetConfig, type = type)
  output <- .datazone$create_subscription_target_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_subscription_target <- datazone_create_subscription_target

#' Creates a user profile in Amazon DataZone
#'
#' @description
#' Creates a user profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_create_user_profile/](https://www.paws-r-sdk.com/docs/datazone_create_user_profile/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a user profile is
#' created.
#' @param userIdentifier &#91;required&#93; The identifier of the user for which the user profile is created.
#' @param userType The user type of the user for which the user profile is created.
#'
#' @keywords internal
#'
#' @rdname datazone_create_user_profile
datazone_create_user_profile <- function(clientToken = NULL, domainIdentifier, userIdentifier, userType = NULL) {
  op <- new_operation(
    name = "CreateUserProfile",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/user-profiles",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$create_user_profile_input(clientToken = clientToken, domainIdentifier = domainIdentifier, userIdentifier = userIdentifier, userType = userType)
  output <- .datazone$create_user_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$create_user_profile <- datazone_create_user_profile

#' Deletes an asset in Amazon DataZone
#'
#' @description
#' Deletes an asset in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_asset/](https://www.paws-r-sdk.com/docs/datazone_delete_asset/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the asset is deleted.
#' @param identifier &#91;required&#93; The identifier of the asset that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_asset
datazone_delete_asset <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteAsset",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_asset_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_asset_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_asset <- datazone_delete_asset

#' Deletes an asset filter
#'
#' @description
#' Deletes an asset filter.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_asset_filter/](https://www.paws-r-sdk.com/docs/datazone_delete_asset_filter/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The ID of the data asset.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to delete an asset filter.
#' @param identifier &#91;required&#93; The ID of the asset filter that you want to delete.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_asset_filter
datazone_delete_asset_filter <- function(assetIdentifier, domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteAssetFilter",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_asset_filter_input(assetIdentifier = assetIdentifier, domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_asset_filter_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_asset_filter <- datazone_delete_asset_filter

#' Deletes an asset type in Amazon DataZone
#'
#' @description
#' Deletes an asset type in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_asset_type/](https://www.paws-r-sdk.com/docs/datazone_delete_asset_type/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the asset type is deleted.
#' @param identifier &#91;required&#93; The identifier of the asset type that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_asset_type
datazone_delete_asset_type <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteAssetType",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/asset-types/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_asset_type_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_asset_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_asset_type <- datazone_delete_asset_type

#' Deletes a data product in Amazon DataZone
#'
#' @description
#' Deletes a data product in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_data_product/](https://www.paws-r-sdk.com/docs/datazone_delete_data_product/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the data product is
#' deleted.
#' @param identifier &#91;required&#93; The identifier of the data product that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_data_product
datazone_delete_data_product <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteDataProduct",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/data-products/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_data_product_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_data_product_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_data_product <- datazone_delete_data_product

#' Deletes a data source in Amazon DataZone
#'
#' @description
#' Deletes a data source in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_data_source/](https://www.paws-r-sdk.com/docs/datazone_delete_data_source/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the data source is
#' deleted.
#' @param identifier &#91;required&#93; The identifier of the data source that is deleted.
#' @param retainPermissionsOnRevokeFailure Specifies that the granted permissions are retained in case of a
#' self-subscribe functionality failure for a data source.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_data_source
datazone_delete_data_source <- function(clientToken = NULL, domainIdentifier, identifier, retainPermissionsOnRevokeFailure = NULL) {
  op <- new_operation(
    name = "DeleteDataSource",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_data_source_input(clientToken = clientToken, domainIdentifier = domainIdentifier, identifier = identifier, retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure)
  output <- .datazone$delete_data_source_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_data_source <- datazone_delete_data_source

#' Deletes a Amazon DataZone domain
#'
#' @description
#' Deletes a Amazon DataZone domain.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_domain/](https://www.paws-r-sdk.com/docs/datazone_delete_domain/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param identifier &#91;required&#93; The identifier of the Amazon Web Services domain that is to be deleted.
#' @param skipDeletionCheck Specifies the optional flag to delete all child entities within the
#' domain.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_domain
datazone_delete_domain <- function(clientToken = NULL, identifier, skipDeletionCheck = NULL) {
  op <- new_operation(
    name = "DeleteDomain",
    http_method = "DELETE",
    http_path = "/v2/domains/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_domain_input(clientToken = clientToken, identifier = identifier, skipDeletionCheck = skipDeletionCheck)
  output <- .datazone$delete_domain_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_domain <- datazone_delete_domain

#' Deletes a domain unit
#'
#' @description
#' Deletes a domain unit.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_domain_unit/](https://www.paws-r-sdk.com/docs/datazone_delete_domain_unit/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to delete a domain unit.
#' @param identifier &#91;required&#93; The ID of the domain unit that you want to delete.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_domain_unit
datazone_delete_domain_unit <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteDomainUnit",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/domain-units/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_domain_unit_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_domain_unit_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_domain_unit <- datazone_delete_domain_unit

#' Deletes an environment in Amazon DataZone
#'
#' @description
#' Deletes an environment in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_environment/](https://www.paws-r-sdk.com/docs/datazone_delete_environment/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the environment is
#' deleted.
#' @param identifier &#91;required&#93; The identifier of the environment that is to be deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_environment
datazone_delete_environment <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteEnvironment",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environments/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_environment_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_environment_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_environment <- datazone_delete_environment

#' Deletes an action for the environment, for example, deletes a console
#' link for an analytics tool that is available in this environment
#'
#' @description
#' Deletes an action for the environment, for example, deletes a console link for an analytics tool that is available in this environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_environment_action/](https://www.paws-r-sdk.com/docs/datazone_delete_environment_action/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which an environment action is
#' deleted.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment where an environment action is deleted.
#' @param identifier &#91;required&#93; The ID of the environment action that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_environment_action
datazone_delete_environment_action <- function(domainIdentifier, environmentIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteEnvironmentAction",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_environment_action_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier)
  output <- .datazone$delete_environment_action_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_environment_action <- datazone_delete_environment_action

#' Deletes the blueprint configuration in Amazon DataZone
#'
#' @description
#' Deletes the blueprint configuration in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_environment_blueprint_configuration/](https://www.paws-r-sdk.com/docs/datazone_delete_environment_blueprint_configuration/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the blueprint
#' configuration is deleted.
#' @param environmentBlueprintIdentifier &#91;required&#93; The ID of the blueprint the configuration of which is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_environment_blueprint_configuration
datazone_delete_environment_blueprint_configuration <- function(domainIdentifier, environmentBlueprintIdentifier) {
  op <- new_operation(
    name = "DeleteEnvironmentBlueprintConfiguration",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_environment_blueprint_configuration_input(domainIdentifier = domainIdentifier, environmentBlueprintIdentifier = environmentBlueprintIdentifier)
  output <- .datazone$delete_environment_blueprint_configuration_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_environment_blueprint_configuration <- datazone_delete_environment_blueprint_configuration

#' Deletes an environment profile in Amazon DataZone
#'
#' @description
#' Deletes an environment profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_environment_profile/](https://www.paws-r-sdk.com/docs/datazone_delete_environment_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the environment profile is
#' deleted.
#' @param identifier &#91;required&#93; The ID of the environment profile that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_environment_profile
datazone_delete_environment_profile <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteEnvironmentProfile",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_environment_profile_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_environment_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_environment_profile <- datazone_delete_environment_profile

#' Delets and metadata form type in Amazon DataZone
#'
#' @description
#' Delets and metadata form type in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_form_type/](https://www.paws-r-sdk.com/docs/datazone_delete_form_type/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the metadata form type is
#' deleted.
#' @param formTypeIdentifier &#91;required&#93; The ID of the metadata form type that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_form_type
datazone_delete_form_type <- function(domainIdentifier, formTypeIdentifier) {
  op <- new_operation(
    name = "DeleteFormType",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_form_type_input(domainIdentifier = domainIdentifier, formTypeIdentifier = formTypeIdentifier)
  output <- .datazone$delete_form_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_form_type <- datazone_delete_form_type

#' Deletes a business glossary in Amazon DataZone
#'
#' @description
#' Deletes a business glossary in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_glossary/](https://www.paws-r-sdk.com/docs/datazone_delete_glossary/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the business glossary is
#' deleted.
#' @param identifier &#91;required&#93; The ID of the business glossary that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_glossary
datazone_delete_glossary <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteGlossary",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_glossary_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_glossary_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_glossary <- datazone_delete_glossary

#' Deletes a business glossary term in Amazon DataZone
#'
#' @description
#' Deletes a business glossary term in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_glossary_term/](https://www.paws-r-sdk.com/docs/datazone_delete_glossary_term/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the business glossary term
#' is deleted.
#' @param identifier &#91;required&#93; The ID of the business glossary term that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_glossary_term
datazone_delete_glossary_term <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteGlossaryTerm",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_glossary_term_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_glossary_term_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_glossary_term <- datazone_delete_glossary_term

#' Deletes a listing (a record of an asset at a given time)
#'
#' @description
#' Deletes a listing (a record of an asset at a given time).
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_listing/](https://www.paws-r-sdk.com/docs/datazone_delete_listing/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain.
#' @param identifier &#91;required&#93; The ID of the listing to be deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_listing
datazone_delete_listing <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteListing",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/listings/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_listing_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_listing_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_listing <- datazone_delete_listing

#' Deletes a project in Amazon DataZone
#'
#' @description
#' Deletes a project in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_project/](https://www.paws-r-sdk.com/docs/datazone_delete_project/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the project is deleted.
#' @param identifier &#91;required&#93; The identifier of the project that is to be deleted.
#' @param skipDeletionCheck Specifies the optional flag to delete all child entities within the
#' project.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_project
datazone_delete_project <- function(domainIdentifier, identifier, skipDeletionCheck = NULL) {
  op <- new_operation(
    name = "DeleteProject",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/projects/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_project_input(domainIdentifier = domainIdentifier, identifier = identifier, skipDeletionCheck = skipDeletionCheck)
  output <- .datazone$delete_project_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_project <- datazone_delete_project

#' Deletes project membership in Amazon DataZone
#'
#' @description
#' Deletes project membership in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_project_membership/](https://www.paws-r-sdk.com/docs/datazone_delete_project_membership/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where project membership is
#' deleted.
#' @param member &#91;required&#93; The project member whose project membership is deleted.
#' @param projectIdentifier &#91;required&#93; The ID of the Amazon DataZone project the membership to which is
#' deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_project_membership
datazone_delete_project_membership <- function(domainIdentifier, member, projectIdentifier) {
  op <- new_operation(
    name = "DeleteProjectMembership",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/deleteMembership",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_project_membership_input(domainIdentifier = domainIdentifier, member = member, projectIdentifier = projectIdentifier)
  output <- .datazone$delete_project_membership_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_project_membership <- datazone_delete_project_membership

#' Deletes and subscription grant in Amazon DataZone
#'
#' @description
#' Deletes and subscription grant in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_subscription_grant/](https://www.paws-r-sdk.com/docs/datazone_delete_subscription_grant/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where the subscription grant is
#' deleted.
#' @param identifier &#91;required&#93; The ID of the subscription grant that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_subscription_grant
datazone_delete_subscription_grant <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteSubscriptionGrant",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_subscription_grant_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_subscription_grant_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_subscription_grant <- datazone_delete_subscription_grant

#' Deletes a subscription request in Amazon DataZone
#'
#' @description
#' Deletes a subscription request in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_subscription_request/](https://www.paws-r-sdk.com/docs/datazone_delete_subscription_request/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription request
#' is deleted.
#' @param identifier &#91;required&#93; The ID of the subscription request that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_subscription_request
datazone_delete_subscription_request <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteSubscriptionRequest",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_subscription_request_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$delete_subscription_request_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_subscription_request <- datazone_delete_subscription_request

#' Deletes a subscription target in Amazon DataZone
#'
#' @description
#' Deletes a subscription target in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_subscription_target/](https://www.paws-r-sdk.com/docs/datazone_delete_subscription_target/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription target is
#' deleted.
#' @param environmentIdentifier &#91;required&#93; The ID of the Amazon DataZone environment in which the subscription
#' target is deleted.
#' @param identifier &#91;required&#93; The ID of the subscription target that is deleted.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_subscription_target
datazone_delete_subscription_target <- function(domainIdentifier, environmentIdentifier, identifier) {
  op <- new_operation(
    name = "DeleteSubscriptionTarget",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_subscription_target_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier)
  output <- .datazone$delete_subscription_target_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_subscription_target <- datazone_delete_subscription_target

#' Deletes the specified time series form for the specified asset
#'
#' @description
#' Deletes the specified time series form for the specified asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_delete_time_series_data_points/](https://www.paws-r-sdk.com/docs/datazone_delete_time_series_data_points/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request. This field is automatically populated if not provided.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain that houses the asset for which you
#' want to delete a time series form.
#' @param entityIdentifier &#91;required&#93; The ID of the asset for which you want to delete a time series form.
#' @param entityType &#91;required&#93; The type of the asset for which you want to delete a time series form.
#' @param formName &#91;required&#93; The name of the time series form that you want to delete.
#'
#' @keywords internal
#'
#' @rdname datazone_delete_time_series_data_points
datazone_delete_time_series_data_points <- function(clientToken = NULL, domainIdentifier, entityIdentifier, entityType, formName) {
  op <- new_operation(
    name = "DeleteTimeSeriesDataPoints",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$delete_time_series_data_points_input(clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, formName = formName)
  output <- .datazone$delete_time_series_data_points_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$delete_time_series_data_points <- datazone_delete_time_series_data_points

#' Disassociates the environment role in Amazon DataZone
#'
#' @description
#' Disassociates the environment role in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_disassociate_environment_role/](https://www.paws-r-sdk.com/docs/datazone_disassociate_environment_role/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which an environment role is
#' disassociated.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment.
#' @param environmentRoleArn &#91;required&#93; The ARN of the environment role.
#'
#' @keywords internal
#'
#' @rdname datazone_disassociate_environment_role
datazone_disassociate_environment_role <- function(domainIdentifier, environmentIdentifier, environmentRoleArn) {
  op <- new_operation(
    name = "DisassociateEnvironmentRole",
    http_method = "DELETE",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/roles/{environmentRoleArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$disassociate_environment_role_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, environmentRoleArn = environmentRoleArn)
  output <- .datazone$disassociate_environment_role_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$disassociate_environment_role <- datazone_disassociate_environment_role

#' Gets an Amazon DataZone asset
#'
#' @description
#' Gets an Amazon DataZone asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_asset/](https://www.paws-r-sdk.com/docs/datazone_get_asset/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain to which the asset belongs.
#' @param identifier &#91;required&#93; The ID of the Amazon DataZone asset.
#' @param revision The revision of the Amazon DataZone asset.
#'
#' @keywords internal
#'
#' @rdname datazone_get_asset
datazone_get_asset <- function(domainIdentifier, identifier, revision = NULL) {
  op <- new_operation(
    name = "GetAsset",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_asset_input(domainIdentifier = domainIdentifier, identifier = identifier, revision = revision)
  output <- .datazone$get_asset_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_asset <- datazone_get_asset

#' Gets an asset filter
#'
#' @description
#' Gets an asset filter.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_asset_filter/](https://www.paws-r-sdk.com/docs/datazone_get_asset_filter/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The ID of the data asset.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to get an asset filter.
#' @param identifier &#91;required&#93; The ID of the asset filter.
#'
#' @keywords internal
#'
#' @rdname datazone_get_asset_filter
datazone_get_asset_filter <- function(assetIdentifier, domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetAssetFilter",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_asset_filter_input(assetIdentifier = assetIdentifier, domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_asset_filter_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_asset_filter <- datazone_get_asset_filter

#' Gets an Amazon DataZone asset type
#'
#' @description
#' Gets an Amazon DataZone asset type.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_asset_type/](https://www.paws-r-sdk.com/docs/datazone_get_asset_type/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the asset type exists.
#' @param identifier &#91;required&#93; The ID of the asset type.
#' @param revision The revision of the asset type.
#'
#' @keywords internal
#'
#' @rdname datazone_get_asset_type
datazone_get_asset_type <- function(domainIdentifier, identifier, revision = NULL) {
  op <- new_operation(
    name = "GetAssetType",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/asset-types/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_asset_type_input(domainIdentifier = domainIdentifier, identifier = identifier, revision = revision)
  output <- .datazone$get_asset_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_asset_type <- datazone_get_asset_type

#' Gets the data product
#'
#' @description
#' Gets the data product.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_data_product/](https://www.paws-r-sdk.com/docs/datazone_get_data_product/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain where the data product lives.
#' @param identifier &#91;required&#93; The ID of the data product.
#' @param revision The revision of the data product.
#'
#' @keywords internal
#'
#' @rdname datazone_get_data_product
datazone_get_data_product <- function(domainIdentifier, identifier, revision = NULL) {
  op <- new_operation(
    name = "GetDataProduct",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-products/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_data_product_input(domainIdentifier = domainIdentifier, identifier = identifier, revision = revision)
  output <- .datazone$get_data_product_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_data_product <- datazone_get_data_product

#' Gets an Amazon DataZone data source
#'
#' @description
#' Gets an Amazon DataZone data source.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_data_source/](https://www.paws-r-sdk.com/docs/datazone_get_data_source/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the data source exists.
#' @param identifier &#91;required&#93; The ID of the Amazon DataZone data source.
#'
#' @keywords internal
#'
#' @rdname datazone_get_data_source
datazone_get_data_source <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetDataSource",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_data_source_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_data_source_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_data_source <- datazone_get_data_source

#' Gets an Amazon DataZone data source run
#'
#' @description
#' Gets an Amazon DataZone data source run.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_data_source_run/](https://www.paws-r-sdk.com/docs/datazone_get_data_source_run/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain in which this data source run was performed.
#' @param identifier &#91;required&#93; The ID of the data source run.
#'
#' @keywords internal
#'
#' @rdname datazone_get_data_source_run
datazone_get_data_source_run <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetDataSourceRun",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-source-runs/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_data_source_run_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_data_source_run_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_data_source_run <- datazone_get_data_source_run

#' Gets an Amazon DataZone domain
#'
#' @description
#' Gets an Amazon DataZone domain.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_domain/](https://www.paws-r-sdk.com/docs/datazone_get_domain/) for full documentation.
#'
#' @param identifier &#91;required&#93; The identifier of the specified Amazon DataZone domain.
#'
#' @keywords internal
#'
#' @rdname datazone_get_domain
datazone_get_domain <- function(identifier) {
  op <- new_operation(
    name = "GetDomain",
    http_method = "GET",
    http_path = "/v2/domains/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_domain_input(identifier = identifier)
  output <- .datazone$get_domain_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_domain <- datazone_get_domain

#' Gets the details of the specified domain unit
#'
#' @description
#' Gets the details of the specified domain unit.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_domain_unit/](https://www.paws-r-sdk.com/docs/datazone_get_domain_unit/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to get a domain unit.
#' @param identifier &#91;required&#93; The identifier of the domain unit that you want to get.
#'
#' @keywords internal
#'
#' @rdname datazone_get_domain_unit
datazone_get_domain_unit <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetDomainUnit",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/domain-units/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_domain_unit_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_domain_unit_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_domain_unit <- datazone_get_domain_unit

#' Gets an Amazon DataZone environment
#'
#' @description
#' Gets an Amazon DataZone environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment/](https://www.paws-r-sdk.com/docs/datazone_get_environment/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where the environment exists.
#' @param identifier &#91;required&#93; The ID of the Amazon DataZone environment.
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment
datazone_get_environment <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetEnvironment",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_environment_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment <- datazone_get_environment

#' Gets the specified environment action
#'
#' @description
#' Gets the specified environment action.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment_action/](https://www.paws-r-sdk.com/docs/datazone_get_environment_action/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the
#' [`get_environment_action`][datazone_get_environment_action] API is
#' invoked.
#' @param environmentIdentifier &#91;required&#93; The environment ID of the environment action.
#' @param identifier &#91;required&#93; The ID of the environment action
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment_action
datazone_get_environment_action <- function(domainIdentifier, environmentIdentifier, identifier) {
  op <- new_operation(
    name = "GetEnvironmentAction",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_action_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier)
  output <- .datazone$get_environment_action_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment_action <- datazone_get_environment_action

#' Gets an Amazon DataZone blueprint
#'
#' @description
#' Gets an Amazon DataZone blueprint.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment_blueprint/](https://www.paws-r-sdk.com/docs/datazone_get_environment_blueprint/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the domain in which this blueprint exists.
#' @param identifier &#91;required&#93; The ID of this Amazon DataZone blueprint.
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment_blueprint
datazone_get_environment_blueprint <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetEnvironmentBlueprint",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprints/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_blueprint_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_environment_blueprint_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment_blueprint <- datazone_get_environment_blueprint

#' Gets the blueprint configuration in Amazon DataZone
#'
#' @description
#' Gets the blueprint configuration in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment_blueprint_configuration/](https://www.paws-r-sdk.com/docs/datazone_get_environment_blueprint_configuration/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where this blueprint exists.
#' @param environmentBlueprintIdentifier &#91;required&#93; He ID of the blueprint.
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment_blueprint_configuration
datazone_get_environment_blueprint_configuration <- function(domainIdentifier, environmentBlueprintIdentifier) {
  op <- new_operation(
    name = "GetEnvironmentBlueprintConfiguration",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_blueprint_configuration_input(domainIdentifier = domainIdentifier, environmentBlueprintIdentifier = environmentBlueprintIdentifier)
  output <- .datazone$get_environment_blueprint_configuration_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment_blueprint_configuration <- datazone_get_environment_blueprint_configuration

#' Gets the credentials of an environment in Amazon DataZone
#'
#' @description
#' Gets the credentials of an environment in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment_credentials/](https://www.paws-r-sdk.com/docs/datazone_get_environment_credentials/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this environment and its
#' credentials exist.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment whose credentials this operation gets.
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment_credentials
datazone_get_environment_credentials <- function(domainIdentifier, environmentIdentifier) {
  op <- new_operation(
    name = "GetEnvironmentCredentials",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/credentials",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_credentials_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier)
  output <- .datazone$get_environment_credentials_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment_credentials <- datazone_get_environment_credentials

#' Gets an evinronment profile in Amazon DataZone
#'
#' @description
#' Gets an evinronment profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_environment_profile/](https://www.paws-r-sdk.com/docs/datazone_get_environment_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this environment profile
#' exists.
#' @param identifier &#91;required&#93; The ID of the environment profile.
#'
#' @keywords internal
#'
#' @rdname datazone_get_environment_profile
datazone_get_environment_profile <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetEnvironmentProfile",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_environment_profile_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_environment_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_environment_profile <- datazone_get_environment_profile

#' Gets a metadata form type in Amazon DataZone
#'
#' @description
#' Gets a metadata form type in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_form_type/](https://www.paws-r-sdk.com/docs/datazone_get_form_type/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this metadata form type
#' exists.
#' @param formTypeIdentifier &#91;required&#93; The ID of the metadata form type.
#' @param revision The revision of this metadata form type.
#'
#' @keywords internal
#'
#' @rdname datazone_get_form_type
datazone_get_form_type <- function(domainIdentifier, formTypeIdentifier, revision = NULL) {
  op <- new_operation(
    name = "GetFormType",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/form-types/{formTypeIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_form_type_input(domainIdentifier = domainIdentifier, formTypeIdentifier = formTypeIdentifier, revision = revision)
  output <- .datazone$get_form_type_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_form_type <- datazone_get_form_type

#' Gets a business glossary in Amazon DataZone
#'
#' @description
#' Gets a business glossary in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_glossary/](https://www.paws-r-sdk.com/docs/datazone_get_glossary/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this business glossary
#' exists.
#' @param identifier &#91;required&#93; The ID of the business glossary.
#'
#' @keywords internal
#'
#' @rdname datazone_get_glossary
datazone_get_glossary <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetGlossary",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_glossary_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_glossary_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_glossary <- datazone_get_glossary

#' Gets a business glossary term in Amazon DataZone
#'
#' @description
#' Gets a business glossary term in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_glossary_term/](https://www.paws-r-sdk.com/docs/datazone_get_glossary_term/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which this business glossary
#' term exists.
#' @param identifier &#91;required&#93; The ID of the business glossary term.
#'
#' @keywords internal
#'
#' @rdname datazone_get_glossary_term
datazone_get_glossary_term <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetGlossaryTerm",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_glossary_term_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_glossary_term_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_glossary_term <- datazone_get_glossary_term

#' Gets a group profile in Amazon DataZone
#'
#' @description
#' Gets a group profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_group_profile/](https://www.paws-r-sdk.com/docs/datazone_get_group_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which the group profile
#' exists.
#' @param groupIdentifier &#91;required&#93; The identifier of the group profile.
#'
#' @keywords internal
#'
#' @rdname datazone_get_group_profile
datazone_get_group_profile <- function(domainIdentifier, groupIdentifier) {
  op <- new_operation(
    name = "GetGroupProfile",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_group_profile_input(domainIdentifier = domainIdentifier, groupIdentifier = groupIdentifier)
  output <- .datazone$get_group_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_group_profile <- datazone_get_group_profile

#' Gets the data portal URL for the specified Amazon DataZone domain
#'
#' @description
#' Gets the data portal URL for the specified Amazon DataZone domain.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_iam_portal_login_url/](https://www.paws-r-sdk.com/docs/datazone_get_iam_portal_login_url/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; the ID of the Amazon DataZone domain the data portal of which you want
#' to get.
#'
#' @keywords internal
#'
#' @rdname datazone_get_iam_portal_login_url
datazone_get_iam_portal_login_url <- function(domainIdentifier) {
  op <- new_operation(
    name = "GetIamPortalLoginUrl",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/get-portal-login-url",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_iam_portal_login_url_input(domainIdentifier = domainIdentifier)
  output <- .datazone$get_iam_portal_login_url_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_iam_portal_login_url <- datazone_get_iam_portal_login_url

#' Gets the data lineage node
#'
#' @description
#' Gets the data lineage node.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_lineage_node/](https://www.paws-r-sdk.com/docs/datazone_get_lineage_node/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain in which you want to get the data lineage node.
#' @param eventTimestamp The event time stamp for which you want to get the data lineage node.
#' @param identifier &#91;required&#93; The ID of the data lineage node that you want to get.
#' 
#' Both, a lineage node identifier generated by Amazon DataZone and a
#' `sourceIdentifier` of the lineage node are supported. If
#' `sourceIdentifier` is greater than 1800 characters, you can use lineage
#' node identifier generated by Amazon DataZone to get the node details.
#'
#' @keywords internal
#'
#' @rdname datazone_get_lineage_node
datazone_get_lineage_node <- function(domainIdentifier, eventTimestamp = NULL, identifier) {
  op <- new_operation(
    name = "GetLineageNode",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_lineage_node_input(domainIdentifier = domainIdentifier, eventTimestamp = eventTimestamp, identifier = identifier)
  output <- .datazone$get_lineage_node_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_lineage_node <- datazone_get_lineage_node

#' Gets a listing (a record of an asset at a given time)
#'
#' @description
#' Gets a listing (a record of an asset at a given time). If you specify a listing version, only details that are specific to that version are returned.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_listing/](https://www.paws-r-sdk.com/docs/datazone_get_listing/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain.
#' @param identifier &#91;required&#93; The ID of the listing.
#' @param listingRevision The revision of the listing.
#'
#' @keywords internal
#'
#' @rdname datazone_get_listing
datazone_get_listing <- function(domainIdentifier, identifier, listingRevision = NULL) {
  op <- new_operation(
    name = "GetListing",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/listings/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_listing_input(domainIdentifier = domainIdentifier, identifier = identifier, listingRevision = listingRevision)
  output <- .datazone$get_listing_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_listing <- datazone_get_listing

#' Gets a metadata generation run in Amazon DataZone
#'
#' @description
#' Gets a metadata generation run in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_metadata_generation_run/](https://www.paws-r-sdk.com/docs/datazone_get_metadata_generation_run/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain the metadata generation run of
#' which you want to get.
#' @param identifier &#91;required&#93; The identifier of the metadata generation run.
#'
#' @keywords internal
#'
#' @rdname datazone_get_metadata_generation_run
datazone_get_metadata_generation_run <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetMetadataGenerationRun",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/metadata-generation-runs/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_metadata_generation_run_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_metadata_generation_run_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_metadata_generation_run <- datazone_get_metadata_generation_run

#' Gets a project in Amazon DataZone
#'
#' @description
#' Gets a project in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_project/](https://www.paws-r-sdk.com/docs/datazone_get_project/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the project exists.
#' @param identifier &#91;required&#93; The ID of the project.
#'
#' @keywords internal
#'
#' @rdname datazone_get_project
datazone_get_project <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetProject",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/projects/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_project_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_project_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_project <- datazone_get_project

#' Gets a subscription in Amazon DataZone
#'
#' @description
#' Gets a subscription in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_subscription/](https://www.paws-r-sdk.com/docs/datazone_get_subscription/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription exists.
#' @param identifier &#91;required&#93; The ID of the subscription.
#'
#' @keywords internal
#'
#' @rdname datazone_get_subscription
datazone_get_subscription <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetSubscription",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscriptions/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_subscription_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_subscription_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_subscription <- datazone_get_subscription

#' Gets the subscription grant in Amazon DataZone
#'
#' @description
#' Gets the subscription grant in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_subscription_grant/](https://www.paws-r-sdk.com/docs/datazone_get_subscription_grant/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription grant
#' exists.
#' @param identifier &#91;required&#93; The ID of the subscription grant.
#'
#' @keywords internal
#'
#' @rdname datazone_get_subscription_grant
datazone_get_subscription_grant <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetSubscriptionGrant",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_subscription_grant_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_subscription_grant_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_subscription_grant <- datazone_get_subscription_grant

#' Gets the details of the specified subscription request
#'
#' @description
#' Gets the details of the specified subscription request.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_subscription_request_details/](https://www.paws-r-sdk.com/docs/datazone_get_subscription_request_details/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to get the
#' subscription request details.
#' @param identifier &#91;required&#93; The identifier of the subscription request the details of which to get.
#'
#' @keywords internal
#'
#' @rdname datazone_get_subscription_request_details
datazone_get_subscription_request_details <- function(domainIdentifier, identifier) {
  op <- new_operation(
    name = "GetSubscriptionRequestDetails",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_subscription_request_details_input(domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$get_subscription_request_details_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_subscription_request_details <- datazone_get_subscription_request_details

#' Gets the subscription target in Amazon DataZone
#'
#' @description
#' Gets the subscription target in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_subscription_target/](https://www.paws-r-sdk.com/docs/datazone_get_subscription_target/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the subscription target
#' exists.
#' @param environmentIdentifier &#91;required&#93; The ID of the environment associated with the subscription target.
#' @param identifier &#91;required&#93; The ID of the subscription target.
#'
#' @keywords internal
#'
#' @rdname datazone_get_subscription_target
datazone_get_subscription_target <- function(domainIdentifier, environmentIdentifier, identifier) {
  op <- new_operation(
    name = "GetSubscriptionTarget",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_subscription_target_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier)
  output <- .datazone$get_subscription_target_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_subscription_target <- datazone_get_subscription_target

#' Gets the existing data point for the asset
#'
#' @description
#' Gets the existing data point for the asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_time_series_data_point/](https://www.paws-r-sdk.com/docs/datazone_get_time_series_data_point/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain that houses the asset for which you
#' want to get the data point.
#' @param entityIdentifier &#91;required&#93; The ID of the asset for which you want to get the data point.
#' @param entityType &#91;required&#93; The type of the asset for which you want to get the data point.
#' @param formName &#91;required&#93; The name of the time series form that houses the data point that you
#' want to get.
#' @param identifier &#91;required&#93; The ID of the data point that you want to get.
#'
#' @keywords internal
#'
#' @rdname datazone_get_time_series_data_point
datazone_get_time_series_data_point <- function(domainIdentifier, entityIdentifier, entityType, formName, identifier) {
  op <- new_operation(
    name = "GetTimeSeriesDataPoint",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_time_series_data_point_input(domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, formName = formName, identifier = identifier)
  output <- .datazone$get_time_series_data_point_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_time_series_data_point <- datazone_get_time_series_data_point

#' Gets a user profile in Amazon DataZone
#'
#' @description
#' Gets a user profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_get_user_profile/](https://www.paws-r-sdk.com/docs/datazone_get_user_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; the ID of the Amazon DataZone domain the data portal of which you want
#' to get.
#' @param type The type of the user profile.
#' @param userIdentifier &#91;required&#93; The identifier of the user for which you want to get the user profile.
#'
#' @keywords internal
#'
#' @rdname datazone_get_user_profile
datazone_get_user_profile <- function(domainIdentifier, type = NULL, userIdentifier) {
  op <- new_operation(
    name = "GetUserProfile",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$get_user_profile_input(domainIdentifier = domainIdentifier, type = type, userIdentifier = userIdentifier)
  output <- .datazone$get_user_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$get_user_profile <- datazone_get_user_profile

#' Lists asset filters
#'
#' @description
#' Lists asset filters.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_asset_filters/](https://www.paws-r-sdk.com/docs/datazone_list_asset_filters/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The ID of the data asset.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to list asset filters.
#' @param maxResults The maximum number of asset filters to return in a single call to
#' [`list_asset_filters`][datazone_list_asset_filters]. When the number of
#' asset filters to be listed is greater than the value of `MaxResults`,
#' the response contains a `NextToken` value that you can use in a
#' subsequent call to [`list_asset_filters`][datazone_list_asset_filters]
#' to list the next set of asset filters.
#' @param nextToken When the number of asset filters is greater than the default value for
#' the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of asset filters, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_asset_filters`][datazone_list_asset_filters] to list the next set
#' of asset filters.
#' @param status The status of the asset filter.
#'
#' @keywords internal
#'
#' @rdname datazone_list_asset_filters
datazone_list_asset_filters <- function(assetIdentifier, domainIdentifier, maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListAssetFilters",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_asset_filters_input(assetIdentifier = assetIdentifier, domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .datazone$list_asset_filters_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_asset_filters <- datazone_list_asset_filters

#' Lists the revisions for the asset
#'
#' @description
#' Lists the revisions for the asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_asset_revisions/](https://www.paws-r-sdk.com/docs/datazone_list_asset_revisions/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the domain.
#' @param identifier &#91;required&#93; The identifier of the asset.
#' @param maxResults The maximum number of revisions to return in a single call to
#' [`list_asset_revisions`][datazone_list_asset_revisions]. When the number
#' of revisions to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`list_asset_revisions`][datazone_list_asset_revisions] to list
#' the next set of revisions.
#' @param nextToken When the number of revisions is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of revisions, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_asset_revisions`][datazone_list_asset_revisions] to list the next
#' set of revisions.
#'
#' @keywords internal
#'
#' @rdname datazone_list_asset_revisions
datazone_list_asset_revisions <- function(domainIdentifier, identifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAssetRevisions",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}/revisions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_asset_revisions_input(domainIdentifier = domainIdentifier, identifier = identifier, maxResults = maxResults, nextToken = nextToken)
  output <- .datazone$list_asset_revisions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_asset_revisions <- datazone_list_asset_revisions

#' Lists data product revisions
#'
#' @description
#' Lists data product revisions.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_data_product_revisions/](https://www.paws-r-sdk.com/docs/datazone_list_data_product_revisions/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain of the data product revisions that you want to
#' list.
#' @param identifier &#91;required&#93; The ID of the data product revision.
#' @param maxResults The maximum number of asset filters to return in a single call to
#' [`list_data_product_revisions`][datazone_list_data_product_revisions].
#' When the number of data product revisions to be listed is greater than
#' the value of `MaxResults`, the response contains a `NextToken` value
#' that you can use in a subsequent call to
#' [`list_data_product_revisions`][datazone_list_data_product_revisions] to
#' list the next set of data product revisions.
#' @param nextToken When the number of data product revisions is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of data product
#' revisions, the response includes a pagination token named `NextToken`.
#' You can specify this `NextToken` value in a subsequent call to
#' [`list_data_product_revisions`][datazone_list_data_product_revisions] to
#' list the next set of data product revisions.
#'
#' @keywords internal
#'
#' @rdname datazone_list_data_product_revisions
datazone_list_data_product_revisions <- function(domainIdentifier, identifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDataProductRevisions",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-products/{identifier}/revisions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_data_product_revisions_input(domainIdentifier = domainIdentifier, identifier = identifier, maxResults = maxResults, nextToken = nextToken)
  output <- .datazone$list_data_product_revisions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_data_product_revisions <- datazone_list_data_product_revisions

#' Lists data source run activities
#'
#' @description
#' Lists data source run activities.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_data_source_run_activities/](https://www.paws-r-sdk.com/docs/datazone_list_data_source_run_activities/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to list data
#' source run activities.
#' @param identifier &#91;required&#93; The identifier of the data source run.
#' @param maxResults The maximum number of activities to return in a single call to
#' [`list_data_source_run_activities`][datazone_list_data_source_run_activities].
#' When the number of activities to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to
#' [`list_data_source_run_activities`][datazone_list_data_source_run_activities]
#' to list the next set of activities.
#' @param nextToken When the number of activities is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of activities, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_data_source_run_activities`][datazone_list_data_source_run_activities]
#' to list the next set of activities.
#' @param status The status of the data source run.
#'
#' @keywords internal
#'
#' @rdname datazone_list_data_source_run_activities
datazone_list_data_source_run_activities <- function(domainIdentifier, identifier, maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListDataSourceRunActivities",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-source-runs/{identifier}/activities",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_data_source_run_activities_input(domainIdentifier = domainIdentifier, identifier = identifier, maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .datazone$list_data_source_run_activities_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_data_source_run_activities <- datazone_list_data_source_run_activities

#' Lists data source runs in Amazon DataZone
#'
#' @description
#' Lists data source runs in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_data_source_runs/](https://www.paws-r-sdk.com/docs/datazone_list_data_source_runs/) for full documentation.
#'
#' @param dataSourceIdentifier &#91;required&#93; The identifier of the data source.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to invoke the
#' [`list_data_source_runs`][datazone_list_data_source_runs] action.
#' @param maxResults The maximum number of runs to return in a single call to
#' [`list_data_source_runs`][datazone_list_data_source_runs]. When the
#' number of runs to be listed is greater than the value of `MaxResults`,
#' the response contains a `NextToken` value that you can use in a
#' subsequent call to
#' [`list_data_source_runs`][datazone_list_data_source_runs] to list the
#' next set of runs.
#' @param nextToken When the number of runs is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of runs, the response includes
#' a pagination token named `NextToken`. You can specify this `NextToken`
#' value in a subsequent call to
#' [`list_data_source_runs`][datazone_list_data_source_runs] to list the
#' next set of runs.
#' @param status The status of the data source.
#'
#' @keywords internal
#'
#' @rdname datazone_list_data_source_runs
datazone_list_data_source_runs <- function(dataSourceIdentifier, domainIdentifier, maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListDataSourceRuns",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_data_source_runs_input(dataSourceIdentifier = dataSourceIdentifier, domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .datazone$list_data_source_runs_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_data_source_runs <- datazone_list_data_source_runs

#' Lists data sources in Amazon DataZone
#'
#' @description
#' Lists data sources in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_data_sources/](https://www.paws-r-sdk.com/docs/datazone_list_data_sources/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to list the data
#' sources.
#' @param environmentIdentifier The identifier of the environment in which to list the data sources.
#' @param maxResults The maximum number of data sources to return in a single call to
#' [`list_data_sources`][datazone_list_data_sources]. When the number of
#' data sources to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`list_data_sources`][datazone_list_data_sources] to list the
#' next set of data sources.
#' @param name The name of the data source.
#' @param nextToken When the number of data sources is greater than the default value for
#' the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of data sources, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_data_sources`][datazone_list_data_sources] to list the next set
#' of data sources.
#' @param projectIdentifier &#91;required&#93; The identifier of the project in which to list data sources.
#' @param status The status of the data source.
#' @param type The type of the data source.
#'
#' @keywords internal
#'
#' @rdname datazone_list_data_sources
datazone_list_data_sources <- function(domainIdentifier, environmentIdentifier = NULL, maxResults = NULL, name = NULL, nextToken = NULL, projectIdentifier, status = NULL, type = NULL) {
  op <- new_operation(
    name = "ListDataSources",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/data-sources",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_data_sources_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, maxResults = maxResults, name = name, nextToken = nextToken, projectIdentifier = projectIdentifier, status = status, type = type)
  output <- .datazone$list_data_sources_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_data_sources <- datazone_list_data_sources

#' Lists child domain units for the specified parent domain unit
#'
#' @description
#' Lists child domain units for the specified parent domain unit.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_domain_units_for_parent/](https://www.paws-r-sdk.com/docs/datazone_list_domain_units_for_parent/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain in which you want to list domain units for a parent
#' domain unit.
#' @param maxResults The maximum number of domain units to return in a single call to
#' ListDomainUnitsForParent. When the number of domain units to be listed
#' is greater than the value of MaxResults, the response contains a
#' NextToken value that you can use in a subsequent call to
#' ListDomainUnitsForParent to list the next set of domain units.
#' @param nextToken When the number of domain units is greater than the default value for
#' the MaxResults parameter, or if you explicitly specify a value for
#' MaxResults that is less than the number of domain units, the response
#' includes a pagination token named NextToken. You can specify this
#' NextToken value in a subsequent call to ListDomainUnitsForParent to list
#' the next set of domain units.
#' @param parentDomainUnitIdentifier &#91;required&#93; The ID of the parent domain unit.
#'
#' @keywords internal
#'
#' @rdname datazone_list_domain_units_for_parent
datazone_list_domain_units_for_parent <- function(domainIdentifier, maxResults = NULL, nextToken = NULL, parentDomainUnitIdentifier) {
  op <- new_operation(
    name = "ListDomainUnitsForParent",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/domain-units",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_domain_units_for_parent_input(domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, parentDomainUnitIdentifier = parentDomainUnitIdentifier)
  output <- .datazone$list_domain_units_for_parent_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_domain_units_for_parent <- datazone_list_domain_units_for_parent

#' Lists Amazon DataZone domains
#'
#' @description
#' Lists Amazon DataZone domains.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_domains/](https://www.paws-r-sdk.com/docs/datazone_list_domains/) for full documentation.
#'
#' @param maxResults The maximum number of domains to return in a single call to
#' [`list_domains`][datazone_list_domains]. When the number of domains to
#' be listed is greater than the value of `MaxResults`, the response
#' contains a `NextToken` value that you can use in a subsequent call to
#' [`list_domains`][datazone_list_domains] to list the next set of domains.
#' @param nextToken When the number of domains is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of domains, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_domains`][datazone_list_domains] to list the next set of domains.
#' @param status The status of the data source.
#'
#' @keywords internal
#'
#' @rdname datazone_list_domains
datazone_list_domains <- function(maxResults = NULL, nextToken = NULL, status = NULL) {
  op <- new_operation(
    name = "ListDomains",
    http_method = "GET",
    http_path = "/v2/domains",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_domains_input(maxResults = maxResults, nextToken = nextToken, status = status)
  output <- .datazone$list_domains_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_domains <- datazone_list_domains

#' Lists the entity (domain units) owners
#'
#' @description
#' Lists the entity (domain units) owners.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_entity_owners/](https://www.paws-r-sdk.com/docs/datazone_list_entity_owners/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to list entity owners.
#' @param entityIdentifier &#91;required&#93; The ID of the entity that you want to list.
#' @param entityType &#91;required&#93; The type of the entity that you want to list.
#' @param maxResults The maximum number of entities to return in a single call to
#' [`list_entity_owners`][datazone_list_entity_owners]. When the number of
#' entities to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`list_entity_owners`][datazone_list_entity_owners] to list the
#' next set of entities.
#' @param nextToken When the number of entities is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of entities, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_entity_owners`][datazone_list_entity_owners] to list the next set
#' of entities.
#'
#' @keywords internal
#'
#' @rdname datazone_list_entity_owners
datazone_list_entity_owners <- function(domainIdentifier, entityIdentifier, entityType, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEntityOwners",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/owners",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "owners")
  )
  input <- .datazone$list_entity_owners_input(domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, maxResults = maxResults, nextToken = nextToken)
  output <- .datazone$list_entity_owners_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_entity_owners <- datazone_list_entity_owners

#' Lists existing environment actions
#'
#' @description
#' Lists existing environment actions.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_environment_actions/](https://www.paws-r-sdk.com/docs/datazone_list_environment_actions/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which the environment actions
#' are listed.
#' @param environmentIdentifier &#91;required&#93; The ID of the envrironment whose environment actions are listed.
#' @param maxResults The maximum number of environment actions to return in a single call to
#' [`list_environment_actions`][datazone_list_environment_actions]. When
#' the number of environment actions to be listed is greater than the value
#' of `MaxResults`, the response contains a `NextToken` value that you can
#' use in a subsequent call to
#' [`list_environment_actions`][datazone_list_environment_actions] to list
#' the next set of environment actions.
#' @param nextToken When the number of environment actions is greater than the default value
#' for the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of environment actions, the
#' response includes a pagination token named `NextToken`. You can specify
#' this `NextToken` value in a subsequent call to
#' [`list_environment_actions`][datazone_list_environment_actions] to list
#' the next set of environment actions.
#'
#' @keywords internal
#'
#' @rdname datazone_list_environment_actions
datazone_list_environment_actions <- function(domainIdentifier, environmentIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentActions",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_environment_actions_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .datazone$list_environment_actions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_environment_actions <- datazone_list_environment_actions

#' Lists blueprint configurations for a Amazon DataZone environment
#'
#' @description
#' Lists blueprint configurations for a Amazon DataZone environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_environment_blueprint_configurations/](https://www.paws-r-sdk.com/docs/datazone_list_environment_blueprint_configurations/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param maxResults The maximum number of blueprint configurations to return in a single
#' call to
#' [`list_environment_blueprint_configurations`][datazone_list_environment_blueprint_configurations].
#' When the number of configurations to be listed is greater than the value
#' of `MaxResults`, the response contains a `NextToken` value that you can
#' use in a subsequent call to
#' [`list_environment_blueprint_configurations`][datazone_list_environment_blueprint_configurations]
#' to list the next set of configurations.
#' @param nextToken When the number of blueprint configurations is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of configurations,
#' the response includes a pagination token named `NextToken`. You can
#' specify this `NextToken` value in a subsequent call to
#' [`list_environment_blueprint_configurations`][datazone_list_environment_blueprint_configurations]
#' to list the next set of configurations.
#'
#' @keywords internal
#'
#' @rdname datazone_list_environment_blueprint_configurations
datazone_list_environment_blueprint_configurations <- function(domainIdentifier, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentBlueprintConfigurations",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprint-configurations",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_environment_blueprint_configurations_input(domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken)
  output <- .datazone$list_environment_blueprint_configurations_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_environment_blueprint_configurations <- datazone_list_environment_blueprint_configurations

#' Lists blueprints in an Amazon DataZone environment
#'
#' @description
#' Lists blueprints in an Amazon DataZone environment.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_environment_blueprints/](https://www.paws-r-sdk.com/docs/datazone_list_environment_blueprints/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param managed Specifies whether the environment blueprint is managed by Amazon
#' DataZone.
#' @param maxResults The maximum number of blueprints to return in a single call to
#' [`list_environment_blueprints`][datazone_list_environment_blueprints].
#' When the number of blueprints to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to
#' [`list_environment_blueprints`][datazone_list_environment_blueprints] to
#' list the next set of blueprints.
#' @param name The name of the Amazon DataZone environment.
#' @param nextToken When the number of blueprints in the environment is greater than the
#' default value for the `MaxResults` parameter, or if you explicitly
#' specify a value for `MaxResults` that is less than the number of
#' blueprints in the environment, the response includes a pagination token
#' named `NextToken`. You can specify this `NextToken` value in a
#' subsequent call to
#' [`list_environment_blueprints`][datazone_list_environment_blueprints]to
#' list the next set of blueprints.
#'
#' @keywords internal
#'
#' @rdname datazone_list_environment_blueprints
datazone_list_environment_blueprints <- function(domainIdentifier, managed = NULL, maxResults = NULL, name = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListEnvironmentBlueprints",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprints",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_environment_blueprints_input(domainIdentifier = domainIdentifier, managed = managed, maxResults = maxResults, name = name, nextToken = nextToken)
  output <- .datazone$list_environment_blueprints_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_environment_blueprints <- datazone_list_environment_blueprints

#' Lists Amazon DataZone environment profiles
#'
#' @description
#' Lists Amazon DataZone environment profiles.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_environment_profiles/](https://www.paws-r-sdk.com/docs/datazone_list_environment_profiles/) for full documentation.
#'
#' @param awsAccountId The identifier of the Amazon Web Services account where you want to list
#' environment profiles.
#' @param awsAccountRegion The Amazon Web Services region where you want to list environment
#' profiles.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param environmentBlueprintIdentifier The identifier of the blueprint that was used to create the environment
#' profiles that you want to list.
#' @param maxResults The maximum number of environment profiles to return in a single call to
#' [`list_environment_profiles`][datazone_list_environment_profiles]. When
#' the number of environment profiles to be listed is greater than the
#' value of `MaxResults`, the response contains a `NextToken` value that
#' you can use in a subsequent call to
#' [`list_environment_profiles`][datazone_list_environment_profiles] to
#' list the next set of environment profiles.
#' @param name 
#' @param nextToken When the number of environment profiles is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of environment
#' profiles, the response includes a pagination token named `NextToken`.
#' You can specify this `NextToken` value in a subsequent call to
#' [`list_environment_profiles`][datazone_list_environment_profiles] to
#' list the next set of environment profiles.
#' @param projectIdentifier The identifier of the Amazon DataZone project.
#'
#' @keywords internal
#'
#' @rdname datazone_list_environment_profiles
datazone_list_environment_profiles <- function(awsAccountId = NULL, awsAccountRegion = NULL, domainIdentifier, environmentBlueprintIdentifier = NULL, maxResults = NULL, name = NULL, nextToken = NULL, projectIdentifier = NULL) {
  op <- new_operation(
    name = "ListEnvironmentProfiles",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environment-profiles",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_environment_profiles_input(awsAccountId = awsAccountId, awsAccountRegion = awsAccountRegion, domainIdentifier = domainIdentifier, environmentBlueprintIdentifier = environmentBlueprintIdentifier, maxResults = maxResults, name = name, nextToken = nextToken, projectIdentifier = projectIdentifier)
  output <- .datazone$list_environment_profiles_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_environment_profiles <- datazone_list_environment_profiles

#' Lists Amazon DataZone environments
#'
#' @description
#' Lists Amazon DataZone environments.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_environments/](https://www.paws-r-sdk.com/docs/datazone_list_environments/) for full documentation.
#'
#' @param awsAccountId The identifier of the Amazon Web Services account where you want to list
#' environments.
#' @param awsAccountRegion The Amazon Web Services region where you want to list environments.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param environmentBlueprintIdentifier The identifier of the Amazon DataZone blueprint.
#' @param environmentProfileIdentifier The identifier of the environment profile.
#' @param maxResults The maximum number of environments to return in a single call to
#' [`list_environments`][datazone_list_environments]. When the number of
#' environments to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`list_environments`][datazone_list_environments] to list the
#' next set of environments.
#' @param name The name of the environment.
#' @param nextToken When the number of environments is greater than the default value for
#' the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of environments, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_environments`][datazone_list_environments] to list the next set
#' of environments.
#' @param projectIdentifier &#91;required&#93; The identifier of the Amazon DataZone project.
#' @param provider The provider of the environment.
#' @param status The status of the environments that you want to list.
#'
#' @keywords internal
#'
#' @rdname datazone_list_environments
datazone_list_environments <- function(awsAccountId = NULL, awsAccountRegion = NULL, domainIdentifier, environmentBlueprintIdentifier = NULL, environmentProfileIdentifier = NULL, maxResults = NULL, name = NULL, nextToken = NULL, projectIdentifier, provider = NULL, status = NULL) {
  op <- new_operation(
    name = "ListEnvironments",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_environments_input(awsAccountId = awsAccountId, awsAccountRegion = awsAccountRegion, domainIdentifier = domainIdentifier, environmentBlueprintIdentifier = environmentBlueprintIdentifier, environmentProfileIdentifier = environmentProfileIdentifier, maxResults = maxResults, name = name, nextToken = nextToken, projectIdentifier = projectIdentifier, provider = provider, status = status)
  output <- .datazone$list_environments_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_environments <- datazone_list_environments

#' Lists the history of the specified data lineage node
#'
#' @description
#' Lists the history of the specified data lineage node.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_lineage_node_history/](https://www.paws-r-sdk.com/docs/datazone_list_lineage_node_history/) for full documentation.
#'
#' @param direction The direction of the data lineage node refers to the lineage node having
#' neighbors in that direction. For example, if direction is `UPSTREAM`,
#' the [`list_lineage_node_history`][datazone_list_lineage_node_history]
#' API responds with historical versions with upstream neighbors only.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to list the history of the specified
#' data lineage node.
#' @param eventTimestampGTE Specifies whether the action is to return data lineage node history from
#' the time after the event timestamp.
#' @param eventTimestampLTE Specifies whether the action is to return data lineage node history from
#' the time prior of the event timestamp.
#' @param identifier &#91;required&#93; The ID of the data lineage node whose history you want to list.
#' @param maxResults The maximum number of history items to return in a single call to
#' ListLineageNodeHistory. When the number of memberships to be listed is
#' greater than the value of MaxResults, the response contains a NextToken
#' value that you can use in a subsequent call to ListLineageNodeHistory to
#' list the next set of items.
#' @param nextToken When the number of history items is greater than the default value for
#' the MaxResults parameter, or if you explicitly specify a value for
#' MaxResults that is less than the number of items, the response includes
#' a pagination token named NextToken. You can specify this NextToken value
#' in a subsequent call to ListLineageNodeHistory to list the next set of
#' items.
#' @param sortOrder The order by which you want data lineage node history to be sorted.
#'
#' @keywords internal
#'
#' @rdname datazone_list_lineage_node_history
datazone_list_lineage_node_history <- function(direction = NULL, domainIdentifier, eventTimestampGTE = NULL, eventTimestampLTE = NULL, identifier, maxResults = NULL, nextToken = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListLineageNodeHistory",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/lineage/nodes/{identifier}/history",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "nodes")
  )
  input <- .datazone$list_lineage_node_history_input(direction = direction, domainIdentifier = domainIdentifier, eventTimestampGTE = eventTimestampGTE, eventTimestampLTE = eventTimestampLTE, identifier = identifier, maxResults = maxResults, nextToken = nextToken, sortOrder = sortOrder)
  output <- .datazone$list_lineage_node_history_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_lineage_node_history <- datazone_list_lineage_node_history

#' Lists all metadata generation runs
#'
#' @description
#' Lists all metadata generation runs.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_metadata_generation_runs/](https://www.paws-r-sdk.com/docs/datazone_list_metadata_generation_runs/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where you want to list metadata
#' generation runs.
#' @param maxResults The maximum number of metadata generation runs to return in a single
#' call to ListMetadataGenerationRuns. When the number of metadata
#' generation runs to be listed is greater than the value of MaxResults,
#' the response contains a NextToken value that you can use in a subsequent
#' call to ListMetadataGenerationRuns to list the next set of revisions.
#' @param nextToken When the number of metadata generation runs is greater than the default
#' value for the MaxResults parameter, or if you explicitly specify a value
#' for MaxResults that is less than the number of metadata generation runs,
#' the response includes a pagination token named NextToken. You can
#' specify this NextToken value in a subsequent call to
#' ListMetadataGenerationRuns to list the next set of revisions.
#' @param status The status of the metadata generation runs.
#' @param type The type of the metadata generation runs.
#'
#' @keywords internal
#'
#' @rdname datazone_list_metadata_generation_runs
datazone_list_metadata_generation_runs <- function(domainIdentifier, maxResults = NULL, nextToken = NULL, status = NULL, type = NULL) {
  op <- new_operation(
    name = "ListMetadataGenerationRuns",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/metadata-generation-runs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_metadata_generation_runs_input(domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, status = status, type = type)
  output <- .datazone$list_metadata_generation_runs_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_metadata_generation_runs <- datazone_list_metadata_generation_runs

#' Lists all Amazon DataZone notifications
#'
#' @description
#' Lists all Amazon DataZone notifications.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_notifications/](https://www.paws-r-sdk.com/docs/datazone_list_notifications/) for full documentation.
#'
#' @param afterTimestamp The time after which you want to list notifications.
#' @param beforeTimestamp The time before which you want to list notifications.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param maxResults The maximum number of notifications to return in a single call to
#' [`list_notifications`][datazone_list_notifications]. When the number of
#' notifications to be listed is greater than the value of `MaxResults`,
#' the response contains a `NextToken` value that you can use in a
#' subsequent call to [`list_notifications`][datazone_list_notifications]
#' to list the next set of notifications.
#' @param nextToken When the number of notifications is greater than the default value for
#' the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of notifications, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_notifications`][datazone_list_notifications] to list the next set
#' of notifications.
#' @param subjects The subjects of notifications.
#' @param taskStatus The task status of notifications.
#' @param type &#91;required&#93; The type of notifications.
#'
#' @keywords internal
#'
#' @rdname datazone_list_notifications
datazone_list_notifications <- function(afterTimestamp = NULL, beforeTimestamp = NULL, domainIdentifier, maxResults = NULL, nextToken = NULL, subjects = NULL, taskStatus = NULL, type) {
  op <- new_operation(
    name = "ListNotifications",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/notifications",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "notifications")
  )
  input <- .datazone$list_notifications_input(afterTimestamp = afterTimestamp, beforeTimestamp = beforeTimestamp, domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, subjects = subjects, taskStatus = taskStatus, type = type)
  output <- .datazone$list_notifications_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_notifications <- datazone_list_notifications

#' Lists policy grants
#'
#' @description
#' Lists policy grants.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_policy_grants/](https://www.paws-r-sdk.com/docs/datazone_list_policy_grants/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to list policy grants.
#' @param entityIdentifier &#91;required&#93; The ID of the entity for which you want to list policy grants.
#' @param entityType &#91;required&#93; The type of entity for which you want to list policy grants.
#' @param maxResults The maximum number of grants to return in a single call to
#' [`list_policy_grants`][datazone_list_policy_grants]. When the number of
#' grants to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`list_policy_grants`][datazone_list_policy_grants] to list the
#' next set of grants.
#' @param nextToken When the number of grants is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of grants, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_policy_grants`][datazone_list_policy_grants] to list the next set
#' of grants.
#' @param policyType &#91;required&#93; The type of policy that you want to list.
#'
#' @keywords internal
#'
#' @rdname datazone_list_policy_grants
datazone_list_policy_grants <- function(domainIdentifier, entityIdentifier, entityType, maxResults = NULL, nextToken = NULL, policyType) {
  op <- new_operation(
    name = "ListPolicyGrants",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/grants",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "grantList")
  )
  input <- .datazone$list_policy_grants_input(domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, maxResults = maxResults, nextToken = nextToken, policyType = policyType)
  output <- .datazone$list_policy_grants_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_policy_grants <- datazone_list_policy_grants

#' Lists all members of the specified project
#'
#' @description
#' Lists all members of the specified project.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_project_memberships/](https://www.paws-r-sdk.com/docs/datazone_list_project_memberships/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which you want to list
#' project memberships.
#' @param maxResults The maximum number of memberships to return in a single call to
#' [`list_project_memberships`][datazone_list_project_memberships]. When
#' the number of memberships to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to
#' [`list_project_memberships`][datazone_list_project_memberships] to list
#' the next set of memberships.
#' @param nextToken When the number of memberships is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of memberships, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_project_memberships`][datazone_list_project_memberships] to list
#' the next set of memberships.
#' @param projectIdentifier &#91;required&#93; The identifier of the project whose memberships you want to list.
#' @param sortBy The method by which you want to sort the project memberships.
#' @param sortOrder The sort order of the project memberships.
#'
#' @keywords internal
#'
#' @rdname datazone_list_project_memberships
datazone_list_project_memberships <- function(domainIdentifier, maxResults = NULL, nextToken = NULL, projectIdentifier, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListProjectMemberships",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/projects/{projectIdentifier}/memberships",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "members")
  )
  input <- .datazone$list_project_memberships_input(domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, projectIdentifier = projectIdentifier, sortBy = sortBy, sortOrder = sortOrder)
  output <- .datazone$list_project_memberships_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_project_memberships <- datazone_list_project_memberships

#' Lists Amazon DataZone projects
#'
#' @description
#' Lists Amazon DataZone projects.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_projects/](https://www.paws-r-sdk.com/docs/datazone_list_projects/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param groupIdentifier The identifier of a group.
#' @param maxResults The maximum number of projects to return in a single call to
#' [`list_projects`][datazone_list_projects]. When the number of projects
#' to be listed is greater than the value of `MaxResults`, the response
#' contains a `NextToken` value that you can use in a subsequent call to
#' [`list_projects`][datazone_list_projects] to list the next set of
#' projects.
#' @param name The name of the project.
#' @param nextToken When the number of projects is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of projects, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_projects`][datazone_list_projects] to list the next set of
#' projects.
#' @param userIdentifier The identifier of the Amazon DataZone user.
#'
#' @keywords internal
#'
#' @rdname datazone_list_projects
datazone_list_projects <- function(domainIdentifier, groupIdentifier = NULL, maxResults = NULL, name = NULL, nextToken = NULL, userIdentifier = NULL) {
  op <- new_operation(
    name = "ListProjects",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/projects",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_projects_input(domainIdentifier = domainIdentifier, groupIdentifier = groupIdentifier, maxResults = maxResults, name = name, nextToken = nextToken, userIdentifier = userIdentifier)
  output <- .datazone$list_projects_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_projects <- datazone_list_projects

#' Lists subscription grants
#'
#' @description
#' Lists subscription grants.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_subscription_grants/](https://www.paws-r-sdk.com/docs/datazone_list_subscription_grants/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param environmentId The identifier of the Amazon DataZone environment.
#' @param maxResults The maximum number of subscription grants to return in a single call to
#' [`list_subscription_grants`][datazone_list_subscription_grants]. When
#' the number of subscription grants to be listed is greater than the value
#' of `MaxResults`, the response contains a `NextToken` value that you can
#' use in a subsequent call to
#' [`list_subscription_grants`][datazone_list_subscription_grants] to list
#' the next set of subscription grants.
#' @param nextToken When the number of subscription grants is greater than the default value
#' for the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of subscription grants, the
#' response includes a pagination token named `NextToken`. You can specify
#' this `NextToken` value in a subsequent call to
#' [`list_subscription_grants`][datazone_list_subscription_grants] to list
#' the next set of subscription grants.
#' @param owningProjectId The ID of the owning project of the subscription grants.
#' @param sortBy Specifies the way of sorting the results of this action.
#' @param sortOrder Specifies the sort order of this action.
#' @param subscribedListingId The identifier of the subscribed listing.
#' @param subscriptionId The identifier of the subscription.
#' @param subscriptionTargetId The identifier of the subscription target.
#'
#' @keywords internal
#'
#' @rdname datazone_list_subscription_grants
datazone_list_subscription_grants <- function(domainIdentifier, environmentId = NULL, maxResults = NULL, nextToken = NULL, owningProjectId = NULL, sortBy = NULL, sortOrder = NULL, subscribedListingId = NULL, subscriptionId = NULL, subscriptionTargetId = NULL) {
  op <- new_operation(
    name = "ListSubscriptionGrants",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscription-grants",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_subscription_grants_input(domainIdentifier = domainIdentifier, environmentId = environmentId, maxResults = maxResults, nextToken = nextToken, owningProjectId = owningProjectId, sortBy = sortBy, sortOrder = sortOrder, subscribedListingId = subscribedListingId, subscriptionId = subscriptionId, subscriptionTargetId = subscriptionTargetId)
  output <- .datazone$list_subscription_grants_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_subscription_grants <- datazone_list_subscription_grants

#' Lists Amazon DataZone subscription requests
#'
#' @description
#' Lists Amazon DataZone subscription requests.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_subscription_requests/](https://www.paws-r-sdk.com/docs/datazone_list_subscription_requests/) for full documentation.
#'
#' @param approverProjectId The identifier of the subscription request approver's project.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param maxResults The maximum number of subscription requests to return in a single call
#' to [`list_subscription_requests`][datazone_list_subscription_requests].
#' When the number of subscription requests to be listed is greater than
#' the value of `MaxResults`, the response contains a `NextToken` value
#' that you can use in a subsequent call to
#' [`list_subscription_requests`][datazone_list_subscription_requests] to
#' list the next set of subscription requests.
#' @param nextToken When the number of subscription requests is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of subscription
#' requests, the response includes a pagination token named `NextToken`.
#' You can specify this `NextToken` value in a subsequent call to
#' [`list_subscription_requests`][datazone_list_subscription_requests] to
#' list the next set of subscription requests.
#' @param owningProjectId The identifier of the project for the subscription requests.
#' @param sortBy Specifies the way to sort the results of this action.
#' @param sortOrder Specifies the sort order for the results of this action.
#' @param status Specifies the status of the subscription requests.
#' 
#' This is not a required parameter, but if not specified, by default,
#' Amazon DataZone returns only `PENDING` subscription requests.
#' @param subscribedListingId The identifier of the subscribed listing.
#'
#' @keywords internal
#'
#' @rdname datazone_list_subscription_requests
datazone_list_subscription_requests <- function(approverProjectId = NULL, domainIdentifier, maxResults = NULL, nextToken = NULL, owningProjectId = NULL, sortBy = NULL, sortOrder = NULL, status = NULL, subscribedListingId = NULL) {
  op <- new_operation(
    name = "ListSubscriptionRequests",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_subscription_requests_input(approverProjectId = approverProjectId, domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, owningProjectId = owningProjectId, sortBy = sortBy, sortOrder = sortOrder, status = status, subscribedListingId = subscribedListingId)
  output <- .datazone$list_subscription_requests_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_subscription_requests <- datazone_list_subscription_requests

#' Lists subscription targets in Amazon DataZone
#'
#' @description
#' Lists subscription targets in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_subscription_targets/](https://www.paws-r-sdk.com/docs/datazone_list_subscription_targets/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain where you want to list
#' subscription targets.
#' @param environmentIdentifier &#91;required&#93; The identifier of the environment where you want to list subscription
#' targets.
#' @param maxResults The maximum number of subscription targets to return in a single call to
#' [`list_subscription_targets`][datazone_list_subscription_targets]. When
#' the number of subscription targets to be listed is greater than the
#' value of `MaxResults`, the response contains a `NextToken` value that
#' you can use in a subsequent call to
#' [`list_subscription_targets`][datazone_list_subscription_targets] to
#' list the next set of subscription targets.
#' @param nextToken When the number of subscription targets is greater than the default
#' value for the `MaxResults` parameter, or if you explicitly specify a
#' value for `MaxResults` that is less than the number of subscription
#' targets, the response includes a pagination token named `NextToken`. You
#' can specify this `NextToken` value in a subsequent call to
#' [`list_subscription_targets`][datazone_list_subscription_targets] to
#' list the next set of subscription targets.
#' @param sortBy Specifies the way in which the results of this action are to be sorted.
#' @param sortOrder Specifies the sort order for the results of this action.
#'
#' @keywords internal
#'
#' @rdname datazone_list_subscription_targets
datazone_list_subscription_targets <- function(domainIdentifier, environmentIdentifier, maxResults = NULL, nextToken = NULL, sortBy = NULL, sortOrder = NULL) {
  op <- new_operation(
    name = "ListSubscriptionTargets",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_subscription_targets_input(domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, maxResults = maxResults, nextToken = nextToken, sortBy = sortBy, sortOrder = sortOrder)
  output <- .datazone$list_subscription_targets_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_subscription_targets <- datazone_list_subscription_targets

#' Lists subscriptions in Amazon DataZone
#'
#' @description
#' Lists subscriptions in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_subscriptions/](https://www.paws-r-sdk.com/docs/datazone_list_subscriptions/) for full documentation.
#'
#' @param approverProjectId The identifier of the project for the subscription's approver.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param maxResults The maximum number of subscriptions to return in a single call to
#' [`list_subscriptions`][datazone_list_subscriptions]. When the number of
#' subscriptions to be listed is greater than the value of `MaxResults`,
#' the response contains a `NextToken` value that you can use in a
#' subsequent call to [`list_subscriptions`][datazone_list_subscriptions]
#' to list the next set of Subscriptions.
#' @param nextToken When the number of subscriptions is greater than the default value for
#' the `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of subscriptions, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`list_subscriptions`][datazone_list_subscriptions] to list the next set
#' of subscriptions.
#' @param owningProjectId The identifier of the owning project.
#' @param sortBy Specifies the way in which the results of this action are to be sorted.
#' @param sortOrder Specifies the sort order for the results of this action.
#' @param status The status of the subscriptions that you want to list.
#' 
#' This is not a required parameter, but if not provided, by default,
#' Amazon DataZone returns only `APPROVED` subscriptions.
#' @param subscribedListingId The identifier of the subscribed listing for the subscriptions that you
#' want to list.
#' @param subscriptionRequestIdentifier The identifier of the subscription request for the subscriptions that
#' you want to list.
#'
#' @keywords internal
#'
#' @rdname datazone_list_subscriptions
datazone_list_subscriptions <- function(approverProjectId = NULL, domainIdentifier, maxResults = NULL, nextToken = NULL, owningProjectId = NULL, sortBy = NULL, sortOrder = NULL, status = NULL, subscribedListingId = NULL, subscriptionRequestIdentifier = NULL) {
  op <- new_operation(
    name = "ListSubscriptions",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/subscriptions",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_subscriptions_input(approverProjectId = approverProjectId, domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, owningProjectId = owningProjectId, sortBy = sortBy, sortOrder = sortOrder, status = status, subscribedListingId = subscribedListingId, subscriptionRequestIdentifier = subscriptionRequestIdentifier)
  output <- .datazone$list_subscriptions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_subscriptions <- datazone_list_subscriptions

#' Lists tags for the specified resource in Amazon DataZone
#'
#' @description
#' Lists tags for the specified resource in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/datazone_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource whose tags you want to list.
#'
#' @keywords internal
#'
#' @rdname datazone_list_tags_for_resource
datazone_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .datazone$list_tags_for_resource_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_tags_for_resource <- datazone_list_tags_for_resource

#' Lists time series data points
#'
#' @description
#' Lists time series data points.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_list_time_series_data_points/](https://www.paws-r-sdk.com/docs/datazone_list_time_series_data_points/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain that houses the assets for which
#' you want to list time series data points.
#' @param endedAt The timestamp at which the data points that you wanted to list ended.
#' @param entityIdentifier &#91;required&#93; The ID of the asset for which you want to list data points.
#' @param entityType &#91;required&#93; The type of the asset for which you want to list data points.
#' @param formName &#91;required&#93; The name of the time series data points form.
#' @param maxResults The maximum number of data points to return in a single call to
#' ListTimeSeriesDataPoints. When the number of data points to be listed is
#' greater than the value of MaxResults, the response contains a NextToken
#' value that you can use in a subsequent call to ListTimeSeriesDataPoints
#' to list the next set of data points.
#' @param nextToken When the number of data points is greater than the default value for the
#' MaxResults parameter, or if you explicitly specify a value for
#' MaxResults that is less than the number of data points, the response
#' includes a pagination token named NextToken. You can specify this
#' NextToken value in a subsequent call to ListTimeSeriesDataPoints to list
#' the next set of data points.
#' @param startedAt The timestamp at which the data points that you want to list started.
#'
#' @keywords internal
#'
#' @rdname datazone_list_time_series_data_points
datazone_list_time_series_data_points <- function(domainIdentifier, endedAt = NULL, entityIdentifier, entityType, formName, maxResults = NULL, nextToken = NULL, startedAt = NULL) {
  op <- new_operation(
    name = "ListTimeSeriesDataPoints",
    http_method = "GET",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$list_time_series_data_points_input(domainIdentifier = domainIdentifier, endedAt = endedAt, entityIdentifier = entityIdentifier, entityType = entityType, formName = formName, maxResults = maxResults, nextToken = nextToken, startedAt = startedAt)
  output <- .datazone$list_time_series_data_points_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$list_time_series_data_points <- datazone_list_time_series_data_points

#' Posts a data lineage event
#'
#' @description
#' Posts a data lineage event.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_post_lineage_event/](https://www.paws-r-sdk.com/docs/datazone_post_lineage_event/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to post a data lineage event.
#' @param event &#91;required&#93; The data lineage event that you want to post. Only open-lineage run
#' event are supported as events.
#'
#' @keywords internal
#'
#' @rdname datazone_post_lineage_event
datazone_post_lineage_event <- function(clientToken = NULL, domainIdentifier, event) {
  op <- new_operation(
    name = "PostLineageEvent",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/lineage/events",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$post_lineage_event_input(clientToken = clientToken, domainIdentifier = domainIdentifier, event = event)
  output <- .datazone$post_lineage_event_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$post_lineage_event <- datazone_post_lineage_event

#' Posts time series data points to Amazon DataZone for the specified asset
#'
#' @description
#' Posts time series data points to Amazon DataZone for the specified asset.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_post_time_series_data_points/](https://www.paws-r-sdk.com/docs/datazone_post_time_series_data_points/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain in which you want to post time
#' series data points.
#' @param entityIdentifier &#91;required&#93; The ID of the asset for which you want to post time series data points.
#' @param entityType &#91;required&#93; The type of the asset for which you want to post data points.
#' @param forms &#91;required&#93; The forms that contain the data points that you want to post.
#'
#' @keywords internal
#'
#' @rdname datazone_post_time_series_data_points
datazone_post_time_series_data_points <- function(clientToken = NULL, domainIdentifier, entityIdentifier, entityType, forms) {
  op <- new_operation(
    name = "PostTimeSeriesDataPoints",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/time-series-data-points",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$post_time_series_data_points_input(clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, forms = forms)
  output <- .datazone$post_time_series_data_points_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$post_time_series_data_points <- datazone_post_time_series_data_points

#' Writes the configuration for the specified environment blueprint in
#' Amazon DataZone
#'
#' @description
#' Writes the configuration for the specified environment blueprint in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_put_environment_blueprint_configuration/](https://www.paws-r-sdk.com/docs/datazone_put_environment_blueprint_configuration/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param enabledRegions &#91;required&#93; Specifies the enabled Amazon Web Services Regions.
#' @param environmentBlueprintIdentifier &#91;required&#93; The identifier of the environment blueprint.
#' @param manageAccessRoleArn The ARN of the manage access role.
#' @param provisioningConfigurations The provisioning configuration of a blueprint.
#' @param provisioningRoleArn The ARN of the provisioning role.
#' @param regionalParameters The regional parameters in the environment blueprint.
#'
#' @keywords internal
#'
#' @rdname datazone_put_environment_blueprint_configuration
datazone_put_environment_blueprint_configuration <- function(domainIdentifier, enabledRegions, environmentBlueprintIdentifier, manageAccessRoleArn = NULL, provisioningConfigurations = NULL, provisioningRoleArn = NULL, regionalParameters = NULL) {
  op <- new_operation(
    name = "PutEnvironmentBlueprintConfiguration",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/environment-blueprint-configurations/{environmentBlueprintIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$put_environment_blueprint_configuration_input(domainIdentifier = domainIdentifier, enabledRegions = enabledRegions, environmentBlueprintIdentifier = environmentBlueprintIdentifier, manageAccessRoleArn = manageAccessRoleArn, provisioningConfigurations = provisioningConfigurations, provisioningRoleArn = provisioningRoleArn, regionalParameters = regionalParameters)
  output <- .datazone$put_environment_blueprint_configuration_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$put_environment_blueprint_configuration <- datazone_put_environment_blueprint_configuration

#' Rejects automatically generated business-friendly metadata for your
#' Amazon DataZone assets
#'
#' @description
#' Rejects automatically generated business-friendly metadata for your Amazon DataZone assets.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_reject_predictions/](https://www.paws-r-sdk.com/docs/datazone_reject_predictions/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param identifier &#91;required&#93; The identifier of the prediction.
#' @param rejectChoices Specifies the prediction (aka, the automatically generated piece of
#' metadata) and the target (for example, a column name) that can be
#' rejected.
#' @param rejectRule Specifies the rule (or the conditions) under which a prediction can be
#' rejected.
#' @param revision The revision that is to be made to the asset.
#'
#' @keywords internal
#'
#' @rdname datazone_reject_predictions
datazone_reject_predictions <- function(clientToken = NULL, domainIdentifier, identifier, rejectChoices = NULL, rejectRule = NULL, revision = NULL) {
  op <- new_operation(
    name = "RejectPredictions",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/assets/{identifier}/reject-predictions",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$reject_predictions_input(clientToken = clientToken, domainIdentifier = domainIdentifier, identifier = identifier, rejectChoices = rejectChoices, rejectRule = rejectRule, revision = revision)
  output <- .datazone$reject_predictions_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$reject_predictions <- datazone_reject_predictions

#' Rejects the specified subscription request
#'
#' @description
#' Rejects the specified subscription request.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_reject_subscription_request/](https://www.paws-r-sdk.com/docs/datazone_reject_subscription_request/) for full documentation.
#'
#' @param decisionComment The decision comment of the rejected subscription request.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which the subscription
#' request was rejected.
#' @param identifier &#91;required&#93; The identifier of the subscription request that was rejected.
#'
#' @keywords internal
#'
#' @rdname datazone_reject_subscription_request
datazone_reject_subscription_request <- function(decisionComment = NULL, domainIdentifier, identifier) {
  op <- new_operation(
    name = "RejectSubscriptionRequest",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}/reject",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$reject_subscription_request_input(decisionComment = decisionComment, domainIdentifier = domainIdentifier, identifier = identifier)
  output <- .datazone$reject_subscription_request_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$reject_subscription_request <- datazone_reject_subscription_request

#' Removes an owner from an entity
#'
#' @description
#' Removes an owner from an entity.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_remove_entity_owner/](https://www.paws-r-sdk.com/docs/datazone_remove_entity_owner/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to remove an owner from an entity.
#' @param entityIdentifier &#91;required&#93; The ID of the entity from which you want to remove an owner.
#' @param entityType &#91;required&#93; The type of the entity from which you want to remove an owner.
#' @param owner &#91;required&#93; The owner that you want to remove from an entity.
#'
#' @keywords internal
#'
#' @rdname datazone_remove_entity_owner
datazone_remove_entity_owner <- function(clientToken = NULL, domainIdentifier, entityIdentifier, entityType, owner) {
  op <- new_operation(
    name = "RemoveEntityOwner",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/entities/{entityType}/{entityIdentifier}/removeOwner",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$remove_entity_owner_input(clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, owner = owner)
  output <- .datazone$remove_entity_owner_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$remove_entity_owner <- datazone_remove_entity_owner

#' Removes a policy grant
#'
#' @description
#' Removes a policy grant.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_remove_policy_grant/](https://www.paws-r-sdk.com/docs/datazone_remove_policy_grant/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to remove a policy grant.
#' @param entityIdentifier &#91;required&#93; The ID of the entity from which you want to remove a policy grant.
#' @param entityType &#91;required&#93; The type of the entity from which you want to remove a policy grant.
#' @param policyType &#91;required&#93; The type of the policy that you want to remove.
#' @param principal &#91;required&#93; The principal from which you want to remove a policy grant.
#'
#' @keywords internal
#'
#' @rdname datazone_remove_policy_grant
datazone_remove_policy_grant <- function(clientToken = NULL, domainIdentifier, entityIdentifier, entityType, policyType, principal) {
  op <- new_operation(
    name = "RemovePolicyGrant",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/policies/managed/{entityType}/{entityIdentifier}/removeGrant",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$remove_policy_grant_input(clientToken = clientToken, domainIdentifier = domainIdentifier, entityIdentifier = entityIdentifier, entityType = entityType, policyType = policyType, principal = principal)
  output <- .datazone$remove_policy_grant_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$remove_policy_grant <- datazone_remove_policy_grant

#' Revokes a specified subscription in Amazon DataZone
#'
#' @description
#' Revokes a specified subscription in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_revoke_subscription/](https://www.paws-r-sdk.com/docs/datazone_revoke_subscription/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain where you want to revoke a
#' subscription.
#' @param identifier &#91;required&#93; The identifier of the revoked subscription.
#' @param retainPermissions Specifies whether permissions are retained when the subscription is
#' revoked.
#'
#' @keywords internal
#'
#' @rdname datazone_revoke_subscription
datazone_revoke_subscription <- function(domainIdentifier, identifier, retainPermissions = NULL) {
  op <- new_operation(
    name = "RevokeSubscription",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/subscriptions/{identifier}/revoke",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$revoke_subscription_input(domainIdentifier = domainIdentifier, identifier = identifier, retainPermissions = retainPermissions)
  output <- .datazone$revoke_subscription_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$revoke_subscription <- datazone_revoke_subscription

#' Searches for assets in Amazon DataZone
#'
#' @description
#' Searches for assets in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_search/](https://www.paws-r-sdk.com/docs/datazone_search/) for full documentation.
#'
#' @param additionalAttributes Specifies additional attributes for the [`search`][datazone_search]
#' action.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain.
#' @param filters Specifies the search filters.
#' @param maxResults The maximum number of results to return in a single call to
#' [`search`][datazone_search]. When the number of results to be listed is
#' greater than the value of `MaxResults`, the response contains a
#' `NextToken` value that you can use in a subsequent call to
#' [`search`][datazone_search] to list the next set of results.
#' @param nextToken When the number of results is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of results, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to [`search`][datazone_search] to
#' list the next set of results.
#' @param owningProjectIdentifier The identifier of the owning project specified for the search.
#' @param searchIn The details of the search.
#' @param searchScope &#91;required&#93; The scope of the search.
#' @param searchText Specifies the text for which to search.
#' @param sort Specifies the way in which the search results are to be sorted.
#'
#' @keywords internal
#'
#' @rdname datazone_search
datazone_search <- function(additionalAttributes = NULL, domainIdentifier, filters = NULL, maxResults = NULL, nextToken = NULL, owningProjectIdentifier = NULL, searchIn = NULL, searchScope, searchText = NULL, sort = NULL) {
  op <- new_operation(
    name = "Search",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/search",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$search_input(additionalAttributes = additionalAttributes, domainIdentifier = domainIdentifier, filters = filters, maxResults = maxResults, nextToken = nextToken, owningProjectIdentifier = owningProjectIdentifier, searchIn = searchIn, searchScope = searchScope, searchText = searchText, sort = sort)
  output <- .datazone$search_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$search <- datazone_search

#' Searches group profiles in Amazon DataZone
#'
#' @description
#' Searches group profiles in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_search_group_profiles/](https://www.paws-r-sdk.com/docs/datazone_search_group_profiles/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which you want to search
#' group profiles.
#' @param groupType &#91;required&#93; The group type for which to search.
#' @param maxResults The maximum number of results to return in a single call to
#' [`search_group_profiles`][datazone_search_group_profiles]. When the
#' number of results to be listed is greater than the value of
#' `MaxResults`, the response contains a `NextToken` value that you can use
#' in a subsequent call to
#' [`search_group_profiles`][datazone_search_group_profiles] to list the
#' next set of results.
#' @param nextToken When the number of results is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of results, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`search_group_profiles`][datazone_search_group_profiles] to list the
#' next set of results.
#' @param searchText Specifies the text for which to search.
#'
#' @keywords internal
#'
#' @rdname datazone_search_group_profiles
datazone_search_group_profiles <- function(domainIdentifier, groupType, maxResults = NULL, nextToken = NULL, searchText = NULL) {
  op <- new_operation(
    name = "SearchGroupProfiles",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/search-group-profiles",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$search_group_profiles_input(domainIdentifier = domainIdentifier, groupType = groupType, maxResults = maxResults, nextToken = nextToken, searchText = searchText)
  output <- .datazone$search_group_profiles_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$search_group_profiles <- datazone_search_group_profiles

#' Searches listings (records of an asset at a given time) in Amazon
#' DataZone
#'
#' @description
#' Searches listings (records of an asset at a given time) in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_search_listings/](https://www.paws-r-sdk.com/docs/datazone_search_listings/) for full documentation.
#'
#' @param additionalAttributes Specifies additional attributes for the search.
#' @param domainIdentifier &#91;required&#93; The identifier of the domain in which to search listings.
#' @param filters Specifies the filters for the search of listings.
#' @param maxResults The maximum number of results to return in a single call to
#' [`search_listings`][datazone_search_listings]. When the number of
#' results to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`search_listings`][datazone_search_listings] to list the next
#' set of results.
#' @param nextToken When the number of results is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of results, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`search_listings`][datazone_search_listings] to list the next set of
#' results.
#' @param searchIn The details of the search.
#' @param searchText Specifies the text for which to search.
#' @param sort Specifies the way for sorting the search results.
#'
#' @keywords internal
#'
#' @rdname datazone_search_listings
datazone_search_listings <- function(additionalAttributes = NULL, domainIdentifier, filters = NULL, maxResults = NULL, nextToken = NULL, searchIn = NULL, searchText = NULL, sort = NULL) {
  op <- new_operation(
    name = "SearchListings",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/listings/search",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$search_listings_input(additionalAttributes = additionalAttributes, domainIdentifier = domainIdentifier, filters = filters, maxResults = maxResults, nextToken = nextToken, searchIn = searchIn, searchText = searchText, sort = sort)
  output <- .datazone$search_listings_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$search_listings <- datazone_search_listings

#' Searches for types in Amazon DataZone
#'
#' @description
#' Searches for types in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_search_types/](https://www.paws-r-sdk.com/docs/datazone_search_types/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to invoke the
#' [`search_types`][datazone_search_types] action.
#' @param filters The filters for the [`search_types`][datazone_search_types] action.
#' @param managed &#91;required&#93; Specifies whether the search is managed.
#' @param maxResults The maximum number of results to return in a single call to
#' [`search_types`][datazone_search_types]. When the number of results to
#' be listed is greater than the value of `MaxResults`, the response
#' contains a `NextToken` value that you can use in a subsequent call to
#' [`search_types`][datazone_search_types] to list the next set of results.
#' @param nextToken When the number of results is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of results, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`search_types`][datazone_search_types] to list the next set of results.
#' @param searchIn The details of the search.
#' @param searchScope &#91;required&#93; Specifies the scope of the search for types.
#' @param searchText Specifies the text for which to search.
#' @param sort The specifies the way to sort the
#' [`search_types`][datazone_search_types] results.
#'
#' @keywords internal
#'
#' @rdname datazone_search_types
datazone_search_types <- function(domainIdentifier, filters = NULL, managed, maxResults = NULL, nextToken = NULL, searchIn = NULL, searchScope, searchText = NULL, sort = NULL) {
  op <- new_operation(
    name = "SearchTypes",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/types-search",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$search_types_input(domainIdentifier = domainIdentifier, filters = filters, managed = managed, maxResults = maxResults, nextToken = nextToken, searchIn = searchIn, searchScope = searchScope, searchText = searchText, sort = sort)
  output <- .datazone$search_types_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$search_types <- datazone_search_types

#' Searches user profiles in Amazon DataZone
#'
#' @description
#' Searches user profiles in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_search_user_profiles/](https://www.paws-r-sdk.com/docs/datazone_search_user_profiles/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which you want to search
#' user profiles.
#' @param maxResults The maximum number of results to return in a single call to
#' [`search_user_profiles`][datazone_search_user_profiles]. When the number
#' of results to be listed is greater than the value of `MaxResults`, the
#' response contains a `NextToken` value that you can use in a subsequent
#' call to [`search_user_profiles`][datazone_search_user_profiles] to list
#' the next set of results.
#' @param nextToken When the number of results is greater than the default value for the
#' `MaxResults` parameter, or if you explicitly specify a value for
#' `MaxResults` that is less than the number of results, the response
#' includes a pagination token named `NextToken`. You can specify this
#' `NextToken` value in a subsequent call to
#' [`search_user_profiles`][datazone_search_user_profiles] to list the next
#' set of results.
#' @param searchText Specifies the text for which to search.
#' @param userType &#91;required&#93; Specifies the user type for the
#' [`search_user_profiles`][datazone_search_user_profiles] action.
#'
#' @keywords internal
#'
#' @rdname datazone_search_user_profiles
datazone_search_user_profiles <- function(domainIdentifier, maxResults = NULL, nextToken = NULL, searchText = NULL, userType) {
  op <- new_operation(
    name = "SearchUserProfiles",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/search-user-profiles",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .datazone$search_user_profiles_input(domainIdentifier = domainIdentifier, maxResults = maxResults, nextToken = nextToken, searchText = searchText, userType = userType)
  output <- .datazone$search_user_profiles_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$search_user_profiles <- datazone_search_user_profiles

#' Start the run of the specified data source in Amazon DataZone
#'
#' @description
#' Start the run of the specified data source in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_start_data_source_run/](https://www.paws-r-sdk.com/docs/datazone_start_data_source_run/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param dataSourceIdentifier &#91;required&#93; The identifier of the data source.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which to start a data
#' source run.
#'
#' @keywords internal
#'
#' @rdname datazone_start_data_source_run
datazone_start_data_source_run <- function(clientToken = NULL, dataSourceIdentifier, domainIdentifier) {
  op <- new_operation(
    name = "StartDataSourceRun",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/data-sources/{dataSourceIdentifier}/runs",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$start_data_source_run_input(clientToken = clientToken, dataSourceIdentifier = dataSourceIdentifier, domainIdentifier = domainIdentifier)
  output <- .datazone$start_data_source_run_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$start_data_source_run <- datazone_start_data_source_run

#' Starts the metadata generation run
#'
#' @description
#' Starts the metadata generation run.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_start_metadata_generation_run/](https://www.paws-r-sdk.com/docs/datazone_start_metadata_generation_run/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier to ensure idempotency of the
#' request. This field is automatically populated if not provided.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where you want to start a metadata
#' generation run.
#' @param owningProjectIdentifier &#91;required&#93; The ID of the project that owns the asset for which you want to start a
#' metadata generation run.
#' @param target &#91;required&#93; The asset for which you want to start a metadata generation run.
#' @param type &#91;required&#93; The type of the metadata generation run.
#'
#' @keywords internal
#'
#' @rdname datazone_start_metadata_generation_run
datazone_start_metadata_generation_run <- function(clientToken = NULL, domainIdentifier, owningProjectIdentifier, target, type) {
  op <- new_operation(
    name = "StartMetadataGenerationRun",
    http_method = "POST",
    http_path = "/v2/domains/{domainIdentifier}/metadata-generation-runs",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$start_metadata_generation_run_input(clientToken = clientToken, domainIdentifier = domainIdentifier, owningProjectIdentifier = owningProjectIdentifier, target = target, type = type)
  output <- .datazone$start_metadata_generation_run_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$start_metadata_generation_run <- datazone_start_metadata_generation_run

#' Tags a resource in Amazon DataZone
#'
#' @description
#' Tags a resource in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_tag_resource/](https://www.paws-r-sdk.com/docs/datazone_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be tagged in Amazon DataZone.
#' @param tags &#91;required&#93; Specifies the tags for the [`tag_resource`][datazone_tag_resource]
#' action.
#'
#' @keywords internal
#'
#' @rdname datazone_tag_resource
datazone_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .datazone$tag_resource_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$tag_resource <- datazone_tag_resource

#' Untags a resource in Amazon DataZone
#'
#' @description
#' Untags a resource in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_untag_resource/](https://www.paws-r-sdk.com/docs/datazone_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource to be untagged in Amazon DataZone.
#' @param tagKeys &#91;required&#93; Specifies the tag keys for the
#' [`untag_resource`][datazone_untag_resource] action.
#'
#' @keywords internal
#'
#' @rdname datazone_untag_resource
datazone_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .datazone$untag_resource_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$untag_resource <- datazone_untag_resource

#' Updates an asset filter
#'
#' @description
#' Updates an asset filter.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_asset_filter/](https://www.paws-r-sdk.com/docs/datazone_update_asset_filter/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The ID of the data asset.
#' @param configuration The configuration of the asset filter.
#' @param description The description of the asset filter.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to update an asset filter.
#' @param identifier &#91;required&#93; The ID of the asset filter.
#' @param name The name of the asset filter.
#'
#' @keywords internal
#'
#' @rdname datazone_update_asset_filter
datazone_update_asset_filter <- function(assetIdentifier, configuration = NULL, description = NULL, domainIdentifier, identifier, name = NULL) {
  op <- new_operation(
    name = "UpdateAssetFilter",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/assets/{assetIdentifier}/filters/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_asset_filter_input(assetIdentifier = assetIdentifier, configuration = configuration, description = description, domainIdentifier = domainIdentifier, identifier = identifier, name = name)
  output <- .datazone$update_asset_filter_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_asset_filter <- datazone_update_asset_filter

#' Updates the specified data source in Amazon DataZone
#'
#' @description
#' Updates the specified data source in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_data_source/](https://www.paws-r-sdk.com/docs/datazone_update_data_source/) for full documentation.
#'
#' @param assetFormsInput The asset forms to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param configuration The configuration to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param description The description to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param domainIdentifier &#91;required&#93; The identifier of the domain in which to update a data source.
#' @param enableSetting The enable setting to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param identifier &#91;required&#93; The identifier of the data source to be updated.
#' @param name The name to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param publishOnImport The publish on import setting to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param recommendation The recommendation to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#' @param retainPermissionsOnRevokeFailure Specifies that the granted permissions are retained in case of a
#' self-subscribe functionality failure for a data source.
#' @param schedule The schedule to be updated as part of the
#' [`update_data_source`][datazone_update_data_source] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_data_source
datazone_update_data_source <- function(assetFormsInput = NULL, configuration = NULL, description = NULL, domainIdentifier, enableSetting = NULL, identifier, name = NULL, publishOnImport = NULL, recommendation = NULL, retainPermissionsOnRevokeFailure = NULL, schedule = NULL) {
  op <- new_operation(
    name = "UpdateDataSource",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/data-sources/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_data_source_input(assetFormsInput = assetFormsInput, configuration = configuration, description = description, domainIdentifier = domainIdentifier, enableSetting = enableSetting, identifier = identifier, name = name, publishOnImport = publishOnImport, recommendation = recommendation, retainPermissionsOnRevokeFailure = retainPermissionsOnRevokeFailure, schedule = schedule)
  output <- .datazone$update_data_source_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_data_source <- datazone_update_data_source

#' Updates a Amazon DataZone domain
#'
#' @description
#' Updates a Amazon DataZone domain.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_domain/](https://www.paws-r-sdk.com/docs/datazone_update_domain/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description to be updated as part of the
#' [`update_domain`][datazone_update_domain] action.
#' @param domainExecutionRole The domain execution role to be updated as part of the
#' [`update_domain`][datazone_update_domain] action.
#' @param identifier &#91;required&#93; The ID of the Amazon Web Services domain that is to be updated.
#' @param name The name to be updated as part of the
#' [`update_domain`][datazone_update_domain] action.
#' @param singleSignOn The single sign-on option to be updated as part of the
#' [`update_domain`][datazone_update_domain] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_domain
datazone_update_domain <- function(clientToken = NULL, description = NULL, domainExecutionRole = NULL, identifier, name = NULL, singleSignOn = NULL) {
  op <- new_operation(
    name = "UpdateDomain",
    http_method = "PUT",
    http_path = "/v2/domains/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_domain_input(clientToken = clientToken, description = description, domainExecutionRole = domainExecutionRole, identifier = identifier, name = name, singleSignOn = singleSignOn)
  output <- .datazone$update_domain_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_domain <- datazone_update_domain

#' Updates the domain unit
#'
#' @description
#' Updates the domain unit.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_domain_unit/](https://www.paws-r-sdk.com/docs/datazone_update_domain_unit/) for full documentation.
#'
#' @param description The description of the domain unit that you want to update.
#' @param domainIdentifier &#91;required&#93; The ID of the domain where you want to update a domain unit.
#' @param identifier &#91;required&#93; The ID of the domain unit that you want to update.
#' @param name The name of the domain unit that you want to update.
#'
#' @keywords internal
#'
#' @rdname datazone_update_domain_unit
datazone_update_domain_unit <- function(description = NULL, domainIdentifier, identifier, name = NULL) {
  op <- new_operation(
    name = "UpdateDomainUnit",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/domain-units/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_domain_unit_input(description = description, domainIdentifier = domainIdentifier, identifier = identifier, name = name)
  output <- .datazone$update_domain_unit_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_domain_unit <- datazone_update_domain_unit

#' Updates the specified environment in Amazon DataZone
#'
#' @description
#' Updates the specified environment in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_environment/](https://www.paws-r-sdk.com/docs/datazone_update_environment/) for full documentation.
#'
#' @param description The description to be updated as part of the
#' [`update_environment`][datazone_update_environment] action.
#' @param domainIdentifier &#91;required&#93; The identifier of the domain in which the environment is to be updated.
#' @param glossaryTerms The glossary terms to be updated as part of the
#' [`update_environment`][datazone_update_environment] action.
#' @param identifier &#91;required&#93; The identifier of the environment that is to be updated.
#' @param name The name to be updated as part of the
#' [`update_environment`][datazone_update_environment] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_environment
datazone_update_environment <- function(description = NULL, domainIdentifier, glossaryTerms = NULL, identifier, name = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/environments/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_environment_input(description = description, domainIdentifier = domainIdentifier, glossaryTerms = glossaryTerms, identifier = identifier, name = name)
  output <- .datazone$update_environment_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_environment <- datazone_update_environment

#' Updates an environment action
#'
#' @description
#' Updates an environment action.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_environment_action/](https://www.paws-r-sdk.com/docs/datazone_update_environment_action/) for full documentation.
#'
#' @param description The description of the environment action.
#' @param domainIdentifier &#91;required&#93; The domain ID of the environment action.
#' @param environmentIdentifier &#91;required&#93; The environment ID of the environment action.
#' @param identifier &#91;required&#93; The ID of the environment action.
#' @param name The name of the environment action.
#' @param parameters The parameters of the environment action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_environment_action
datazone_update_environment_action <- function(description = NULL, domainIdentifier, environmentIdentifier, identifier, name = NULL, parameters = NULL) {
  op <- new_operation(
    name = "UpdateEnvironmentAction",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/actions/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_environment_action_input(description = description, domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier, name = name, parameters = parameters)
  output <- .datazone$update_environment_action_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_environment_action <- datazone_update_environment_action

#' Updates the specified environment profile in Amazon DataZone
#'
#' @description
#' Updates the specified environment profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_environment_profile/](https://www.paws-r-sdk.com/docs/datazone_update_environment_profile/) for full documentation.
#'
#' @param awsAccountId The Amazon Web Services account in which a specified environment profile
#' is to be udpated.
#' @param awsAccountRegion The Amazon Web Services Region in which a specified environment profile
#' is to be updated.
#' @param description The description to be updated as part of the
#' [`update_environment_profile`][datazone_update_environment_profile]
#' action.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which an environment
#' profile is to be updated.
#' @param identifier &#91;required&#93; The identifier of the environment profile that is to be updated.
#' @param name The name to be updated as part of the
#' [`update_environment_profile`][datazone_update_environment_profile]
#' action.
#' @param userParameters The user parameters to be updated as part of the
#' [`update_environment_profile`][datazone_update_environment_profile]
#' action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_environment_profile
datazone_update_environment_profile <- function(awsAccountId = NULL, awsAccountRegion = NULL, description = NULL, domainIdentifier, identifier, name = NULL, userParameters = NULL) {
  op <- new_operation(
    name = "UpdateEnvironmentProfile",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/environment-profiles/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_environment_profile_input(awsAccountId = awsAccountId, awsAccountRegion = awsAccountRegion, description = description, domainIdentifier = domainIdentifier, identifier = identifier, name = name, userParameters = userParameters)
  output <- .datazone$update_environment_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_environment_profile <- datazone_update_environment_profile

#' Updates the business glossary in Amazon DataZone
#'
#' @description
#' Updates the business glossary in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_glossary/](https://www.paws-r-sdk.com/docs/datazone_update_glossary/) for full documentation.
#'
#' @param clientToken A unique, case-sensitive identifier that is provided to ensure the
#' idempotency of the request.
#' @param description The description to be updated as part of the
#' [`update_glossary`][datazone_update_glossary] action.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a business
#' glossary is to be updated.
#' @param identifier &#91;required&#93; The identifier of the business glossary to be updated.
#' @param name The name to be updated as part of the
#' [`update_glossary`][datazone_update_glossary] action.
#' @param status The status to be updated as part of the
#' [`update_glossary`][datazone_update_glossary] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_glossary
datazone_update_glossary <- function(clientToken = NULL, description = NULL, domainIdentifier, identifier, name = NULL, status = NULL) {
  op <- new_operation(
    name = "UpdateGlossary",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/glossaries/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_glossary_input(clientToken = clientToken, description = description, domainIdentifier = domainIdentifier, identifier = identifier, name = name, status = status)
  output <- .datazone$update_glossary_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_glossary <- datazone_update_glossary

#' Updates a business glossary term in Amazon DataZone
#'
#' @description
#' Updates a business glossary term in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_glossary_term/](https://www.paws-r-sdk.com/docs/datazone_update_glossary_term/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a business
#' glossary term is to be updated.
#' @param glossaryIdentifier The identifier of the business glossary in which a term is to be
#' updated.
#' @param identifier &#91;required&#93; The identifier of the business glossary term that is to be updated.
#' @param longDescription The long description to be updated as part of the
#' [`update_glossary_term`][datazone_update_glossary_term] action.
#' @param name The name to be updated as part of the
#' [`update_glossary_term`][datazone_update_glossary_term] action.
#' @param shortDescription The short description to be updated as part of the
#' [`update_glossary_term`][datazone_update_glossary_term] action.
#' @param status The status to be updated as part of the
#' [`update_glossary_term`][datazone_update_glossary_term] action.
#' @param termRelations The term relations to be updated as part of the
#' [`update_glossary_term`][datazone_update_glossary_term] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_glossary_term
datazone_update_glossary_term <- function(domainIdentifier, glossaryIdentifier = NULL, identifier, longDescription = NULL, name = NULL, shortDescription = NULL, status = NULL, termRelations = NULL) {
  op <- new_operation(
    name = "UpdateGlossaryTerm",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/glossary-terms/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_glossary_term_input(domainIdentifier = domainIdentifier, glossaryIdentifier = glossaryIdentifier, identifier = identifier, longDescription = longDescription, name = name, shortDescription = shortDescription, status = status, termRelations = termRelations)
  output <- .datazone$update_glossary_term_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_glossary_term <- datazone_update_glossary_term

#' Updates the specified group profile in Amazon DataZone
#'
#' @description
#' Updates the specified group profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_group_profile/](https://www.paws-r-sdk.com/docs/datazone_update_group_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a group profile is
#' updated.
#' @param groupIdentifier &#91;required&#93; The identifier of the group profile that is updated.
#' @param status &#91;required&#93; The status of the group profile that is updated.
#'
#' @keywords internal
#'
#' @rdname datazone_update_group_profile
datazone_update_group_profile <- function(domainIdentifier, groupIdentifier, status) {
  op <- new_operation(
    name = "UpdateGroupProfile",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/group-profiles/{groupIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_group_profile_input(domainIdentifier = domainIdentifier, groupIdentifier = groupIdentifier, status = status)
  output <- .datazone$update_group_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_group_profile <- datazone_update_group_profile

#' Updates the specified project in Amazon DataZone
#'
#' @description
#' Updates the specified project in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_project/](https://www.paws-r-sdk.com/docs/datazone_update_project/) for full documentation.
#'
#' @param description The description to be updated as part of the
#' [`update_project`][datazone_update_project] action.
#' @param domainIdentifier &#91;required&#93; The ID of the Amazon DataZone domain where a project is being updated.
#' @param glossaryTerms The glossary terms to be updated as part of the
#' [`update_project`][datazone_update_project] action.
#' @param identifier &#91;required&#93; The identifier of the project that is to be updated.
#' @param name The name to be updated as part of the
#' [`update_project`][datazone_update_project] action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_project
datazone_update_project <- function(description = NULL, domainIdentifier, glossaryTerms = NULL, identifier, name = NULL) {
  op <- new_operation(
    name = "UpdateProject",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/projects/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_project_input(description = description, domainIdentifier = domainIdentifier, glossaryTerms = glossaryTerms, identifier = identifier, name = name)
  output <- .datazone$update_project_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_project <- datazone_update_project

#' Updates the status of the specified subscription grant status in Amazon
#' DataZone
#'
#' @description
#' Updates the status of the specified subscription grant status in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_subscription_grant_status/](https://www.paws-r-sdk.com/docs/datazone_update_subscription_grant_status/) for full documentation.
#'
#' @param assetIdentifier &#91;required&#93; The identifier of the asset the subscription grant status of which is to
#' be updated.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a subscription
#' grant status is to be updated.
#' @param failureCause Specifies the error message that is returned if the operation cannot be
#' successfully completed.
#' @param identifier &#91;required&#93; The identifier of the subscription grant the status of which is to be
#' updated.
#' @param status &#91;required&#93; The status to be updated as part of the
#' [`update_subscription_grant_status`][datazone_update_subscription_grant_status]
#' action.
#' @param targetName The target name to be updated as part of the
#' [`update_subscription_grant_status`][datazone_update_subscription_grant_status]
#' action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_subscription_grant_status
datazone_update_subscription_grant_status <- function(assetIdentifier, domainIdentifier, failureCause = NULL, identifier, status, targetName = NULL) {
  op <- new_operation(
    name = "UpdateSubscriptionGrantStatus",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/subscription-grants/{identifier}/status/{assetIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_subscription_grant_status_input(assetIdentifier = assetIdentifier, domainIdentifier = domainIdentifier, failureCause = failureCause, identifier = identifier, status = status, targetName = targetName)
  output <- .datazone$update_subscription_grant_status_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_subscription_grant_status <- datazone_update_subscription_grant_status

#' Updates a specified subscription request in Amazon DataZone
#'
#' @description
#' Updates a specified subscription request in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_subscription_request/](https://www.paws-r-sdk.com/docs/datazone_update_subscription_request/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a subscription
#' request is to be updated.
#' @param identifier &#91;required&#93; The identifier of the subscription request that is to be updated.
#' @param requestReason &#91;required&#93; The reason for the
#' [`update_subscription_request`][datazone_update_subscription_request]
#' action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_subscription_request
datazone_update_subscription_request <- function(domainIdentifier, identifier, requestReason) {
  op <- new_operation(
    name = "UpdateSubscriptionRequest",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/subscription-requests/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_subscription_request_input(domainIdentifier = domainIdentifier, identifier = identifier, requestReason = requestReason)
  output <- .datazone$update_subscription_request_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_subscription_request <- datazone_update_subscription_request

#' Updates the specified subscription target in Amazon DataZone
#'
#' @description
#' Updates the specified subscription target in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_subscription_target/](https://www.paws-r-sdk.com/docs/datazone_update_subscription_target/) for full documentation.
#'
#' @param applicableAssetTypes The applicable asset types to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#' @param authorizedPrincipals The authorized principals to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a subscription
#' target is to be updated.
#' @param environmentIdentifier &#91;required&#93; The identifier of the environment in which a subscription target is to
#' be updated.
#' @param identifier &#91;required&#93; Identifier of the subscription target that is to be updated.
#' @param manageAccessRole The manage access role to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#' @param name The name to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#' @param provider The provider to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#' @param subscriptionTargetConfig The configuration to be updated as part of the
#' [`update_subscription_target`][datazone_update_subscription_target]
#' action.
#'
#' @keywords internal
#'
#' @rdname datazone_update_subscription_target
datazone_update_subscription_target <- function(applicableAssetTypes = NULL, authorizedPrincipals = NULL, domainIdentifier, environmentIdentifier, identifier, manageAccessRole = NULL, name = NULL, provider = NULL, subscriptionTargetConfig = NULL) {
  op <- new_operation(
    name = "UpdateSubscriptionTarget",
    http_method = "PATCH",
    http_path = "/v2/domains/{domainIdentifier}/environments/{environmentIdentifier}/subscription-targets/{identifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_subscription_target_input(applicableAssetTypes = applicableAssetTypes, authorizedPrincipals = authorizedPrincipals, domainIdentifier = domainIdentifier, environmentIdentifier = environmentIdentifier, identifier = identifier, manageAccessRole = manageAccessRole, name = name, provider = provider, subscriptionTargetConfig = subscriptionTargetConfig)
  output <- .datazone$update_subscription_target_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_subscription_target <- datazone_update_subscription_target

#' Updates the specified user profile in Amazon DataZone
#'
#' @description
#' Updates the specified user profile in Amazon DataZone.
#'
#' See [https://www.paws-r-sdk.com/docs/datazone_update_user_profile/](https://www.paws-r-sdk.com/docs/datazone_update_user_profile/) for full documentation.
#'
#' @param domainIdentifier &#91;required&#93; The identifier of the Amazon DataZone domain in which a user profile is
#' updated.
#' @param status &#91;required&#93; The status of the user profile that are to be updated.
#' @param type The type of the user profile that are to be updated.
#' @param userIdentifier &#91;required&#93; The identifier of the user whose user profile is to be updated.
#'
#' @keywords internal
#'
#' @rdname datazone_update_user_profile
datazone_update_user_profile <- function(domainIdentifier, status, type = NULL, userIdentifier) {
  op <- new_operation(
    name = "UpdateUserProfile",
    http_method = "PUT",
    http_path = "/v2/domains/{domainIdentifier}/user-profiles/{userIdentifier}",
    host_prefix = "",
    paginator = list()
  )
  input <- .datazone$update_user_profile_input(domainIdentifier = domainIdentifier, status = status, type = type, userIdentifier = userIdentifier)
  output <- .datazone$update_user_profile_output()
  config <- get_config()
  svc <- .datazone$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.datazone$operations$update_user_profile <- datazone_update_user_profile
