% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_get_plan}
\alias{glue_get_plan}
\title{Gets code to perform a specified mapping}
\usage{
glue_get_plan(
  Mapping,
  Source,
  Sinks = NULL,
  Location = NULL,
  Language = NULL,
  AdditionalPlanOptionsMap = NULL
)
}
\arguments{
\item{Mapping}{[required] The list of mappings from a source table to target tables.}

\item{Source}{[required] The source table.}

\item{Sinks}{The target tables.}

\item{Location}{The parameters for the mapping.}

\item{Language}{The programming language of the code to perform the mapping.}

\item{AdditionalPlanOptionsMap}{A map to hold additional optional key-value parameters.

Currently, these key-value pairs are supported:
\itemize{
\item \code{inferSchema}  —  Specifies whether to set \code{inferSchema} to true or
false for the default script generated by an Glue job. For example,
to set \code{inferSchema} to true, pass the following key value pair:

\verb{--additional-plan-options-map '\{"inferSchema":"true"\}'}
}}
}
\description{
Gets code to perform a specified mapping.

See \url{https://paws-r.github.io/docs/glue/get_plan.html} for full documentation.
}
\keyword{internal}
