# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include kafkaconnect_service.R
NULL

#' Creates a connector using the specified properties
#'
#' @description
#' Creates a connector using the specified properties.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/create_connector.html](https://paws-r.github.io/docs/kafkaconnect/create_connector.html) for full documentation.
#'
#' @param capacity &#91;required&#93; Information about the capacity allocated to the connector. Exactly one
#' of the two properties must be specified.
#' @param connectorConfiguration &#91;required&#93; A map of keys to values that represent the configuration for the
#' connector.
#' @param connectorDescription A summary description of the connector.
#' @param connectorName &#91;required&#93; The name of the connector.
#' @param kafkaCluster &#91;required&#93; Specifies which Apache Kafka cluster to connect to.
#' @param kafkaClusterClientAuthentication &#91;required&#93; Details of the client authentication used by the Apache Kafka cluster.
#' @param kafkaClusterEncryptionInTransit &#91;required&#93; Details of encryption in transit to the Apache Kafka cluster.
#' @param kafkaConnectVersion &#91;required&#93; The version of Kafka Connect. It has to be compatible with both the
#' Apache Kafka cluster's version and the plugins.
#' @param logDelivery Details about log delivery.
#' @param plugins &#91;required&#93; Specifies which plugins to use for the connector.
#' @param serviceExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role used by the connector to
#' access the Amazon Web Services resources that it needs. The types of
#' resources depends on the logic of the connector. For example, a
#' connector that has Amazon S3 as a destination must have permissions that
#' allow it to write to the S3 destination bucket.
#' @param workerConfiguration Specifies which worker configuration to use with the connector.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_create_connector
kafkaconnect_create_connector <- function(capacity, connectorConfiguration, connectorDescription = NULL, connectorName, kafkaCluster, kafkaClusterClientAuthentication, kafkaClusterEncryptionInTransit, kafkaConnectVersion, logDelivery = NULL, plugins, serviceExecutionRoleArn, workerConfiguration = NULL) {
  op <- new_operation(
    name = "CreateConnector",
    http_method = "POST",
    http_path = "/v1/connectors",
    paginator = list()
  )
  input <- .kafkaconnect$create_connector_input(capacity = capacity, connectorConfiguration = connectorConfiguration, connectorDescription = connectorDescription, connectorName = connectorName, kafkaCluster = kafkaCluster, kafkaClusterClientAuthentication = kafkaClusterClientAuthentication, kafkaClusterEncryptionInTransit = kafkaClusterEncryptionInTransit, kafkaConnectVersion = kafkaConnectVersion, logDelivery = logDelivery, plugins = plugins, serviceExecutionRoleArn = serviceExecutionRoleArn, workerConfiguration = workerConfiguration)
  output <- .kafkaconnect$create_connector_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$create_connector <- kafkaconnect_create_connector

#' Creates a custom plugin using the specified properties
#'
#' @description
#' Creates a custom plugin using the specified properties.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/create_custom_plugin.html](https://paws-r.github.io/docs/kafkaconnect/create_custom_plugin.html) for full documentation.
#'
#' @param contentType &#91;required&#93; The type of the plugin file.
#' @param description A summary description of the custom plugin.
#' @param location &#91;required&#93; Information about the location of a custom plugin.
#' @param name &#91;required&#93; The name of the custom plugin.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_create_custom_plugin
kafkaconnect_create_custom_plugin <- function(contentType, description = NULL, location, name) {
  op <- new_operation(
    name = "CreateCustomPlugin",
    http_method = "POST",
    http_path = "/v1/custom-plugins",
    paginator = list()
  )
  input <- .kafkaconnect$create_custom_plugin_input(contentType = contentType, description = description, location = location, name = name)
  output <- .kafkaconnect$create_custom_plugin_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$create_custom_plugin <- kafkaconnect_create_custom_plugin

#' Creates a worker configuration using the specified properties
#'
#' @description
#' Creates a worker configuration using the specified properties.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/create_worker_configuration.html](https://paws-r.github.io/docs/kafkaconnect/create_worker_configuration.html) for full documentation.
#'
#' @param description A summary description of the worker configuration.
#' @param name &#91;required&#93; The name of the worker configuration.
#' @param propertiesFileContent &#91;required&#93; Base64 encoded contents of connect-distributed.properties file.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_create_worker_configuration
kafkaconnect_create_worker_configuration <- function(description = NULL, name, propertiesFileContent) {
  op <- new_operation(
    name = "CreateWorkerConfiguration",
    http_method = "POST",
    http_path = "/v1/worker-configurations",
    paginator = list()
  )
  input <- .kafkaconnect$create_worker_configuration_input(description = description, name = name, propertiesFileContent = propertiesFileContent)
  output <- .kafkaconnect$create_worker_configuration_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$create_worker_configuration <- kafkaconnect_create_worker_configuration

#' Deletes the specified connector
#'
#' @description
#' Deletes the specified connector.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/delete_connector.html](https://paws-r.github.io/docs/kafkaconnect/delete_connector.html) for full documentation.
#'
#' @param connectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the connector that you want to delete.
#' @param currentVersion The current version of the connector that you want to delete.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_delete_connector
kafkaconnect_delete_connector <- function(connectorArn, currentVersion = NULL) {
  op <- new_operation(
    name = "DeleteConnector",
    http_method = "DELETE",
    http_path = "/v1/connectors/{connectorArn}",
    paginator = list()
  )
  input <- .kafkaconnect$delete_connector_input(connectorArn = connectorArn, currentVersion = currentVersion)
  output <- .kafkaconnect$delete_connector_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$delete_connector <- kafkaconnect_delete_connector

#' Deletes a custom plugin
#'
#' @description
#' Deletes a custom plugin.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/delete_custom_plugin.html](https://paws-r.github.io/docs/kafkaconnect/delete_custom_plugin.html) for full documentation.
#'
#' @param customPluginArn &#91;required&#93; The Amazon Resource Name (ARN) of the custom plugin that you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_delete_custom_plugin
kafkaconnect_delete_custom_plugin <- function(customPluginArn) {
  op <- new_operation(
    name = "DeleteCustomPlugin",
    http_method = "DELETE",
    http_path = "/v1/custom-plugins/{customPluginArn}",
    paginator = list()
  )
  input <- .kafkaconnect$delete_custom_plugin_input(customPluginArn = customPluginArn)
  output <- .kafkaconnect$delete_custom_plugin_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$delete_custom_plugin <- kafkaconnect_delete_custom_plugin

#' Returns summary information about the connector
#'
#' @description
#' Returns summary information about the connector.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/describe_connector.html](https://paws-r.github.io/docs/kafkaconnect/describe_connector.html) for full documentation.
#'
#' @param connectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the connector that you want to
#' describe.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_describe_connector
kafkaconnect_describe_connector <- function(connectorArn) {
  op <- new_operation(
    name = "DescribeConnector",
    http_method = "GET",
    http_path = "/v1/connectors/{connectorArn}",
    paginator = list()
  )
  input <- .kafkaconnect$describe_connector_input(connectorArn = connectorArn)
  output <- .kafkaconnect$describe_connector_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$describe_connector <- kafkaconnect_describe_connector

#' A summary description of the custom plugin
#'
#' @description
#' A summary description of the custom plugin.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/describe_custom_plugin.html](https://paws-r.github.io/docs/kafkaconnect/describe_custom_plugin.html) for full documentation.
#'
#' @param customPluginArn &#91;required&#93; Returns information about a custom plugin.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_describe_custom_plugin
kafkaconnect_describe_custom_plugin <- function(customPluginArn) {
  op <- new_operation(
    name = "DescribeCustomPlugin",
    http_method = "GET",
    http_path = "/v1/custom-plugins/{customPluginArn}",
    paginator = list()
  )
  input <- .kafkaconnect$describe_custom_plugin_input(customPluginArn = customPluginArn)
  output <- .kafkaconnect$describe_custom_plugin_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$describe_custom_plugin <- kafkaconnect_describe_custom_plugin

#' Returns information about a worker configuration
#'
#' @description
#' Returns information about a worker configuration.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/describe_worker_configuration.html](https://paws-r.github.io/docs/kafkaconnect/describe_worker_configuration.html) for full documentation.
#'
#' @param workerConfigurationArn &#91;required&#93; The Amazon Resource Name (ARN) of the worker configuration that you want
#' to get information about.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_describe_worker_configuration
kafkaconnect_describe_worker_configuration <- function(workerConfigurationArn) {
  op <- new_operation(
    name = "DescribeWorkerConfiguration",
    http_method = "GET",
    http_path = "/v1/worker-configurations/{workerConfigurationArn}",
    paginator = list()
  )
  input <- .kafkaconnect$describe_worker_configuration_input(workerConfigurationArn = workerConfigurationArn)
  output <- .kafkaconnect$describe_worker_configuration_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$describe_worker_configuration <- kafkaconnect_describe_worker_configuration

#' Returns a list of all the connectors in this account and Region
#'
#' @description
#' Returns a list of all the connectors in this account and Region. The list is limited to connectors whose name starts with the specified prefix. The response also includes a description of each of the listed connectors.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/list_connectors.html](https://paws-r.github.io/docs/kafkaconnect/list_connectors.html) for full documentation.
#'
#' @param connectorNamePrefix The name prefix that you want to use to search for and list connectors.
#' @param maxResults The maximum number of connectors to list in one response.
#' @param nextToken If the response of a ListConnectors operation is truncated, it will
#' include a NextToken. Send this NextToken in a subsequent request to
#' continue listing from where the previous operation left off.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_list_connectors
kafkaconnect_list_connectors <- function(connectorNamePrefix = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListConnectors",
    http_method = "GET",
    http_path = "/v1/connectors",
    paginator = list()
  )
  input <- .kafkaconnect$list_connectors_input(connectorNamePrefix = connectorNamePrefix, maxResults = maxResults, nextToken = nextToken)
  output <- .kafkaconnect$list_connectors_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$list_connectors <- kafkaconnect_list_connectors

#' Returns a list of all of the custom plugins in this account and Region
#'
#' @description
#' Returns a list of all of the custom plugins in this account and Region.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/list_custom_plugins.html](https://paws-r.github.io/docs/kafkaconnect/list_custom_plugins.html) for full documentation.
#'
#' @param maxResults The maximum number of custom plugins to list in one response.
#' @param nextToken If the response of a ListCustomPlugins operation is truncated, it will
#' include a NextToken. Send this NextToken in a subsequent request to
#' continue listing from where the previous operation left off.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_list_custom_plugins
kafkaconnect_list_custom_plugins <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListCustomPlugins",
    http_method = "GET",
    http_path = "/v1/custom-plugins",
    paginator = list()
  )
  input <- .kafkaconnect$list_custom_plugins_input(maxResults = maxResults, nextToken = nextToken)
  output <- .kafkaconnect$list_custom_plugins_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$list_custom_plugins <- kafkaconnect_list_custom_plugins

#' Returns a list of all of the worker configurations in this account and
#' Region
#'
#' @description
#' Returns a list of all of the worker configurations in this account and Region.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/list_worker_configurations.html](https://paws-r.github.io/docs/kafkaconnect/list_worker_configurations.html) for full documentation.
#'
#' @param maxResults The maximum number of worker configurations to list in one response.
#' @param nextToken If the response of a ListWorkerConfigurations operation is truncated, it
#' will include a NextToken. Send this NextToken in a subsequent request to
#' continue listing from where the previous operation left off.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_list_worker_configurations
kafkaconnect_list_worker_configurations <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListWorkerConfigurations",
    http_method = "GET",
    http_path = "/v1/worker-configurations",
    paginator = list()
  )
  input <- .kafkaconnect$list_worker_configurations_input(maxResults = maxResults, nextToken = nextToken)
  output <- .kafkaconnect$list_worker_configurations_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$list_worker_configurations <- kafkaconnect_list_worker_configurations

#' Updates the specified connector
#'
#' @description
#' Updates the specified connector.
#'
#' See [https://paws-r.github.io/docs/kafkaconnect/update_connector.html](https://paws-r.github.io/docs/kafkaconnect/update_connector.html) for full documentation.
#'
#' @param capacity &#91;required&#93; The target capacity.
#' @param connectorArn &#91;required&#93; The Amazon Resource Name (ARN) of the connector that you want to update.
#' @param currentVersion &#91;required&#93; The current version of the connector that you want to update.
#'
#' @keywords internal
#'
#' @rdname kafkaconnect_update_connector
kafkaconnect_update_connector <- function(capacity, connectorArn, currentVersion) {
  op <- new_operation(
    name = "UpdateConnector",
    http_method = "PUT",
    http_path = "/v1/connectors/{connectorArn}",
    paginator = list()
  )
  input <- .kafkaconnect$update_connector_input(capacity = capacity, connectorArn = connectorArn, currentVersion = currentVersion)
  output <- .kafkaconnect$update_connector_output()
  config <- get_config()
  svc <- .kafkaconnect$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kafkaconnect$operations$update_connector <- kafkaconnect_update_connector
