% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_list_applications}
\alias{kinesisanalytics_list_applications}
\title{This documentation is for version 1 of the Amazon Kinesis Data Analytics
API, which only supports SQL applications}
\usage{
kinesisanalytics_list_applications(Limit, ExclusiveStartApplicationName)
}
\arguments{
\item{Limit}{Maximum number of applications to list.}

\item{ExclusiveStartApplicationName}{Name of the application to start the list with. When using pagination to
retrieve the list, you don\'t need to specify this parameter in the
first request. However, in subsequent requests, you add the last
application name from the previous response to get the next page of
applications.}
}
\description{
This documentation is for version 1 of the Amazon Kinesis Data Analytics
API, which only supports SQL applications. Version 2 of the API supports
SQL and Java applications. For more information about version 2, see
Amazon Kinesis Data Analytics API V2 Documentation.
}
\details{
Returns a list of Amazon Kinesis Analytics applications in your account.
For each application, the response includes the application name, Amazon
Resource Name (ARN), and status. If the response returns the
\code{HasMoreApplications} value as true, you can send another request by
adding the \code{ExclusiveStartApplicationName} in the request body, and set
the value of this to the last application name from the previous
response.

If you want detailed information about a specific application, use
\href{https://docs.aws.amazon.com/kinesisanalytics/latest/dev/API_DescribeApplication.html}{DescribeApplication}.

This operation requires permissions to perform the
\code{kinesisanalytics:ListApplications} action.
}
\section{Request syntax}{
\preformatted{svc$list_applications(
  Limit = 123,
  ExclusiveStartApplicationName = "string"
)
}
}

\keyword{internal}
