% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mturk_operations.R
\name{mturk_get_hit}
\alias{mturk_get_hit}
\title{The GetHIT operation retrieves the details of the specified HIT}
\usage{
mturk_get_hit(HITId)
}
\arguments{
\item{HITId}{[required] The ID of the HIT to be retrieved.}
}
\value{
A list with the following syntax:\preformatted{list(
  HIT = list(
    HITId = "string",
    HITTypeId = "string",
    HITGroupId = "string",
    HITLayoutId = "string",
    CreationTime = as.POSIXct(
      "2015-01-01"
    ),
    Title = "string",
    Description = "string",
    Question = "string",
    Keywords = "string",
    HITStatus = "Assignable"|"Unassignable"|"Reviewable"|"Reviewing"|"Disposed",
    MaxAssignments = 123,
    Reward = "string",
    AutoApprovalDelayInSeconds = 123,
    Expiration = as.POSIXct(
      "2015-01-01"
    ),
    AssignmentDurationInSeconds = 123,
    RequesterAnnotation = "string",
    QualificationRequirements = list(
      list(
        QualificationTypeId = "string",
        Comparator = "LessThan"|"LessThanOrEqualTo"|"GreaterThan"|"GreaterThanOrEqualTo"|"EqualTo"|"NotEqualTo"|"Exists"|"DoesNotExist"|"In"|"NotIn",
        IntegerValues = list(
          123
        ),
        LocaleValues = list(
          list(
            Country = "string",
            Subdivision = "string"
          )
        ),
        RequiredToPreview = TRUE|FALSE,
        ActionsGuarded = "Accept"|"PreviewAndAccept"|"DiscoverPreviewAndAccept"
      )
    ),
    HITReviewStatus = "NotReviewed"|"MarkedForReview"|"ReviewedAppropriate"|"ReviewedInappropriate",
    NumberOfAssignmentsPending = 123,
    NumberOfAssignmentsAvailable = 123,
    NumberOfAssignmentsCompleted = 123
  )
)
}
}
\description{
The \code{\link[=mturk_get_hit]{get_hit}} operation retrieves the details of the
specified HIT.
}
\section{Request syntax}{
\preformatted{svc$get_hit(
  HITId = "string"
)
}
}

\keyword{internal}
