% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_output}
\alias{kinesisanalyticsv2_add_application_output}
\title{Adds an external destination to your SQL-based Kinesis Data Analytics
application}
\usage{
kinesisanalyticsv2_add_application_output(ApplicationName,
  CurrentApplicationVersionId, Output)
}
\arguments{
\item{ApplicationName}{[required] The name of the application to which you want to add the output
configuration.}

\item{CurrentApplicationVersionId}{[required] The version of the application to which you want to add the output
configuration. You can use the DescribeApplication operation to get the
current application version. If the version specified is not the current
version, the \code{ConcurrentModificationException} is returned.}

\item{Output}{[required] An array of objects, each describing one output configuration. In the
output configuration, you specify the name of an in-application stream,
a destination (that is, a Kinesis data stream, a Kinesis Data Firehose
delivery stream, or an AWS Lambda function), and record the formation to
use when writing to the destination.}
}
\description{
Adds an external destination to your SQL-based Kinesis Data Analytics
application.

If you want Kinesis Data Analytics to deliver data from an
in-application stream within your application to an external destination
(such as an Kinesis data stream, a Kinesis Data Firehose delivery
stream, or an AWS Lambda function), you add the relevant configuration
to your application using this operation. You can configure one or more
outputs for your application. Each output configuration maps an
in-application stream and an external destination.

You can use one of the output configurations to deliver data from your
in-application error stream to an external destination so that you can
analyze the errors.

Any configuration update, including adding a streaming source using this
operation, results in a new version of the application. You can use the
DescribeApplication operation to find the current application version.
}
\section{Request syntax}{
\preformatted{svc$add_application_output(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  Output = list(
    Name = "string",
    KinesisStreamsOutput = list(
      ResourceARN = "string"
    ),
    KinesisFirehoseOutput = list(
      ResourceARN = "string"
    ),
    LambdaOutput = list(
      ResourceARN = "string"
    ),
    DestinationSchema = list(
      RecordFormatType = "JSON"|"CSV"
    )
  )
)
}
}

\keyword{internal}
