% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quicksight_operations.R
\name{quicksight_list_groups}
\alias{quicksight_list_groups}
\title{Lists all user groups in Amazon QuickSight}
\usage{
quicksight_list_groups(AwsAccountId, NextToken, MaxResults, Namespace)
}
\arguments{
\item{AwsAccountId}{[required] The ID for the AWS account that the group is in. Currently, you use the
ID for the AWS account that contains your Amazon QuickSight account.}

\item{NextToken}{A pagination token that can be used in a subsequent request.}

\item{MaxResults}{The maximum number of results to return.}

\item{Namespace}{[required] The namespace. Currently, you should set this to \code{default}.}
}
\description{
Lists all user groups in Amazon QuickSight.
}
\details{
The permissions resource is
\code{arn:aws:quicksight:us-east-1:<i>&lt;aws-account-id&gt;</i>:group/default/*}.

The response is a list of group objects.

\strong{CLI Sample:}

\code{aws quicksight list-groups -\\-aws-account-id=111122223333 -\\-namespace=default }
}
\section{Request syntax}{
\preformatted{svc$list_groups(
  AwsAccountId = "string",
  NextToken = "string",
  MaxResults = 123,
  Namespace = "string"
)
}
}

\keyword{internal}
