% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/axistetra.R
\name{axistetra}
\alias{axistetra}
\title{Plot reference axes in a static tetrahedral colorspace}
\usage{
axistetra(x = 0.6, y = 0.8, z = 0.7, size = 0.1, arrowhead = 0.05,
  col = par("fg"), lty = par("lty"), lwd = par("lwd"), label = TRUE,
  adj.label = 0.03, label.cex = 1, label.col = NULL)
}
\arguments{
\item{x, y, z}{coordinates for the origin position of the arrows}

\item{size}{length of the arrows. Can be either a single value 
(applied for x, y and z) or a vector of 3 separate values for each axis.}

\item{arrowhead}{size of the arrowhead.}

\item{col, lty, lwd}{graphical parameters for the arrows.}

\item{label}{logical, include x, y and z labels (defaults to TRUE).}

\item{adj.label}{position adjustment for the labels. Can be either a 
single value (applied for x, y and z) or a vector of 3 separate values
for each axis.}

\item{label.cex, label.col}{graphical parameters for the labels.}
}
\value{
\code{axistetra} adds reference arrows showing the direction of the 
3-dimensional axes in a static tetrahedral colorspace plot.
}
\description{
Plots reference x, y and z arrows showing the direction of
the axes in a static tetrahedral colorspace plot.
}
\author{
Rafael Maia \email{rm72@zips.uakron.edu}
}

