% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectedNNsInfo.R
\name{projectedNNsInfo_Lite}
\alias{projectedNNsInfo_Lite}
\title{Projected Nearest Neighbors Information (Lite Version)}
\usage{
projectedNNsInfo_Lite(My, Dy, SMy, PSMy, timesX, i, h)
}
\arguments{
\item{My}{Matrix of coordinates in the original space.}

\item{Dy}{Precomputed distance matrix for all elements.}

\item{SMy}{Matrix of signatures.}

\item{PSMy}{Matrix of patterns.}

\item{timesX}{Index at which the projection starts.}

\item{i}{Index of the specific element for which information is being extracted.}

\item{h}{Horizon over which the projection is considered.}
}
\value{
A list similar to \code{projectedNNsInfo}, containing details about the element, projected times, distances, weights, signatures, patterns, and coordinates.
}
\description{
Simplified version of \code{projectedNNsInfo} function, intended for contexts where the distance matrix is directly passed as a parameter, applicable in scenarios where distances are precomputed or not dependent on dynamic indices.
}
\examples{
set.seed(123)
E <- 3
tau <- 1
Mx <- matrix(rnorm(200), nrow = 20)
My <- matrix(rnorm(200), nrow = 20)
CCSPAN <- (E - 1) * tau
NNSPAN <- E + 1
i <- 15
h <- 2
Dx <- distanceVector(point = Mx[i, ], candidateNNs = Mx[1:(i - CCSPAN - h), ], n = 2)
Dy <- distanceVector(point = My[i, ], candidateNNs = My[1:(i - CCSPAN - h), ], n = 2)
SMx <- signatureSpace(Mx, E)
SMy <- signatureSpace(My, E)
PSMx <- patternSpace(SMx, E)
PSMy <- patternSpace(SMy, E)
NNx <- pastNNsInfo_Lite(CCSPAN, NNSPAN, Mx, Dx, SMx, PSMx, i, h)
timesX <- NNx$times
projNNy <- projectedNNsInfo_Lite(My, Dy, SMy, PSMy, timesX, i, h)
print(projNNy)
}
