% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/active_snw_search.R
\name{filterActiveSnws}
\alias{filterActiveSnws}
\title{Parse Active Subnetwork Search Output File and Filter the Subnetworks}
\usage{
filterActiveSnws(
  active_snw_path,
  sig_genes_vec,
  score_quan_thr = 0.8,
  sig_gene_thr = 0.02
)
}
\arguments{
\item{active_snw_path}{path to the output of an Active Subnetwork Search}

\item{sig_genes_vec}{vector of significant gene symbols. In the scope of this
package, these are the input genes that were used for active subnetwork search}

\item{score_quan_thr}{active subnetwork score quantile threshold. Must be
between 0 and 1 or set to -1 for not filtering. (Default = 0.8)}

\item{sig_gene_thr}{threshold for the minimum proportion of significant genes in
the subnetwork (Default = 0.02) If the number of genes to use as threshold is
calculated to be < 2 (e.g. 50 signif. genes x 0.01 = 0.5), the threshold number
is set to 2}
}
\value{
A list containing \code{subnetworks}: a list of of genes in every
active subnetwork that has a score greater than the \code{score_quan_thr}th
quantile and that contains at least \code{sig_gene_thr} of significant genes
and \code{scores} the score of each filtered active subnetwork
}
\description{
Parse Active Subnetwork Search Output File and Filter the Subnetworks
}
\examples{
path2snw_list <- system.file(
  "extdata/resultActiveSubnetworkSearch.txt",
  package = "pathfindR"
)
filtered <- filterActiveSnws(
  active_snw_path = path2snw_list,
  sig_genes_vec = example_pathfindR_input$Gene.symbol
)
}
\seealso{
See \code{\link{run_pathfindR}} for the wrapper function of the
  pathfindR enrichment workflow
}
