% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{create_kappa_matrix}
\alias{create_kappa_matrix}
\title{Create Kappa Statistics Matrix}
\usage{
create_kappa_matrix(enrichment_res, use_names = FALSE,
  use_active_snw_genes = FALSE)
}
\arguments{
\item{enrichment_res}{data frame of pathway enrichment results. Must-have
columns are "Pathway" or "ID", "Down_regulated", and "Up_regulated". If
`use_active_snw_genes = TRUE`, "non_DEG_Active_Snw_Genes" must also be provided.}

\item{use_names}{boolean to indicate whether to use pathway names instead of IDs (default = FALSE, i.e. use IDs)}

\item{use_active_snw_genes}{boolean to indicate whether or not to use non-input active subnetwork genes
in the calculation of kappa statistics (default = FALSE, i.e. use only affected genes)}
}
\value{
a matrix of kappa statistics between each term in the enrichment results.
}
\description{
Create Kappa Statistics Matrix
}
\examples{
sub_df <- RA_output[1:3,]
create_kappa_matrix(sub_df)
}
