% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper.R
\name{enrichment_chart}
\alias{enrichment_chart}
\title{Plot the Bubble Chart of Enrichment Results}
\usage{
enrichment_chart(result_df, plot_by_cluster = FALSE)
}
\arguments{
\item{result_df}{a data frame that must contain the following columns:\describe{
  \item{Pathway}{Description of the enriched pathway}
  \item{Fold_Enrichment}{Fold enrichment value for the enriched pathway}
  \item{lowest_p}{the lowest adjusted-p value of the given pathway over all iterations}
  \item{Up_regulated}{the up-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Down_regulated}{the down-regulated genes in the input involved in the given pathway, comma-separated}
  \item{Cluster(OPTIONAL)}{the cluster to which the pathway is assigned}
}}

\item{plot_by_cluster}{boolean value indicating whether or not to group the
pathways by cluster (works if "Cluster" is a column of `result_df`).}
}
\value{
a `ggplot2` object containing the bubble chart. The x-axis corresponds to
fold enrichment values while the y-axis indicates the enriched pathways. Size of
the bubble indicates the number of DEGs in the given pathway. Color indicates
the -log10(lowest-p) value. The closer the color is to red, the more significant
the enrichment is. Optionally, if "Cluster" is a column of `result_df` and
plot_by_cluster == TRUE, the pathways are grouped by clusters.
}
\description{
This function is used to plot a bubble chart displaying the enrichment
results.
}
\examples{
g <- enrichment_chart(RA_output)
}
