% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aab-helper.R
\docType{methods}
\name{entropy}
\alias{entropy}
\alias{entropy,numeric,numeric-method}
\alias{entropy,Partition,numeric-method}
\alias{entropy,ANY,missing-method}
\title{Entropy}
\usage{
entropy(x, log_base)

\S4method{entropy}{numeric,numeric}(x, log_base)

\S4method{entropy}{Partition,numeric}(x, log_base)

\S4method{entropy}{ANY,missing}(x, log_base = exp(1))
}
\arguments{
\item{x}{A probability distribution}

\item{log_base}{Optional base of the logarithm (default: \eqn{e})}
}
\description{
Compute the Shannon entropy
\deqn{-\sum_{i} p_i \log_b p_i}
}
\section{Methods (by class)}{
\itemize{
\item \code{x = Partition,log_base = numeric}: Entropy of a partition represented by \code{x}
}}

\section{Hint}{

This method is used internally for measures based on information theory
}

\examples{
entropy(c(.5, .5)) == log(2)
entropy(c(.5, .5), 2) == 1
entropy(c(.5, .5), 4) == .5

# Entropy of a partition
entropy(new("Partition", c(0, 0, 1, 1, 1))) == entropy(c(2/5, 3/5))

}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
