% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bag_mlp.R
\name{bag_mlp}
\alias{bag_mlp}
\title{Ensembles of neural networks}
\usage{
bag_mlp(
  mode = "unknown",
  hidden_units = NULL,
  penalty = NULL,
  epochs = NULL,
  engine = "nnet"
)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
Possible values for this model are "unknown", "regression", or
"classification".}

\item{hidden_units}{An integer for the number of units in the hidden model.}

\item{penalty}{A non-negative numeric value for the amount of weight
decay.}

\item{epochs}{An integer for the number of training iterations.}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}
}
\description{
\code{bag_mlp()} defines an ensemble of single layer, feed-forward neural networks.
This function can fit classification and regression models.

\Sexpr[stage=render,results=rd]{parsnip:::make_engine_list("bag_mlp")}

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\seealso{
\Sexpr[stage=render,results=rd]{parsnip:::make_seealso_list("bag_mlp")}
}
