% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_all.R
\encoding{UTF-8}
\name{load_all}
\alias{load_all}
\title{Loads allergy data information into R.}
\usage{
load_all(
  file,
  merge_id = "EMPI",
  sep = ":",
  id_length = "standard",
  perc = 0.6,
  na = TRUE,
  identical = TRUE,
  nThread = parallel::detectCores() - 1,
  mrn_type = FALSE
)
}
\arguments{
\item{file}{string, full file path to All.txt.}

\item{merge_id}{string, column name to use to create \emph{ID_MERGE} column used to merge different datasets. Defaults to \emph{EPIC_PMRN},
as it is the preferred MRN in the RPDR system.}

\item{sep}{string, divider between hospital ID and MRN. Defaults to \emph{:}.}

\item{id_length}{string, indicating whether to modify MRN length based-on required values \emph{id_length = standard}, or to keep lengths as is \emph{id_length = asis}.
If \emph{id_length = standard} then in case of \emph{MGH, BWH, MCL, EMPI and PMRN} the length of the MRNs are corrected accordingly by adding zeros, or removing numeral from the beginning.
In other cases the lengths are unchanged. Defaults to \emph{standard}.}

\item{perc}{numeric, a number between 0-1 indicating which parsed ID columns to keep. Data present in \emph{perc x 100\%} of patients are kept.}

\item{na}{boolean, whether to remove columns with only NA values. Defaults to \emph{TRUE}.}

\item{identical}{boolean, whether to remove columns with identical values. Defaults to \emph{TRUE}.}

\item{nThread}{integer, number of threads to use to load data.}

\item{mrn_type}{boolean, should data in \emph{MRN_Type} and \emph{MRN} be parsed. Defaults to \emph{FALSE}, as it is not advised to parse these for all data sources as it takes considerable time.}
}
\value{
data table, with allergy information.
\describe{
 \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
 \item{ID_all_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
 from \emph{all} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_all_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
 from \emph{all} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_all_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
 \item{time_all}{POSIXct, Date when the allergy was first noted, corresponds to Noted_Date in RPDR. Converted to POSIXct format.}
 \item{all_all}{string, Name of the allergen, corresponds to Allergen in RPDR.}
 \item{all_all_code}{string, Epic internal identifier for the specific allergen, corresponds to Allergen_Code in RPDR.}
 \item{all_all_type}{string, Hierarchy for the type of allergy noted. Denotes known level of specificity of allergen, corresponds to Allergen_Type in RPDR.}
 \item{all_reac}{string, Noted reactions to the allergen, corresponds to Reactions in RPDR.}
 \item{all_reac_type}{string, Category of reaction to the allergen, corresponds to Reaction_Type in RPDR.}
 \item{all_severity}{string, Degree of severity of noted reactions, corresponds to Severity in RPDR.}
 \item{all_status}{string, Last known status of allergen, either active or deleted from the patient's allergy record, corresponds to Status in RPDR.}
 \item{all_system}{string, The source system where the data was collected, corresponds to System in RPDR.}
 \item{all_comment}{string, Free-text information about the allergen, corresponds to Comments in RPDR.}
 \item{all_del_reason}{string, Free-text information about why the allergen was removed from the patient's allergy list, corresponds to Deleted_Reason in RPDR.}
 }
}
\description{
Loads allergy information into the R environment.
}
\examples{
\dontrun{
#Using defaults
d_all <- load_all(file = "test_All.txt")

#Use sequential processing
d_all <- load_all(file = "test_All.txt", nThread = 1)

#Use parallel processing and parse data in MRN_Type and MRN columns and keep all IDs
d_all <- load_all(file = "test_All.txt", nThread = 20, mrn_type = TRUE, perc = 1)
}
}
