% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_med.R
\docType{data}
\encoding{UTF-8}
\name{data_med}
\alias{data_med}
\title{Example of processed med.txt output from RPDR using the load_med() function.}
\format{
data.table
}
\usage{
data_med
}
\value{
data table, with encounter information.
\describe{
 \item{ID_MERGE}{numeric, defined IDs by \emph{merge_id}, used for merging later.}
 \item{ID_med_EMPI}{string, Unique Partners-wide identifier assigned to the patient used to consolidate patient information
 from \emph{enc} datasource, corresponds to EMPI in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_med_PMRN}{string, Epic medical record number. This value is unique across Epic instances within the Partners network
 from \emph{enc} datasource, corresponds to EPIC_PMRN in RPDR. Data is formatted using pretty_mrn().}
 \item{ID_med_loc}{string, if mrn_type == TRUE, then the data in \emph{MRN_Type} and \emph{MRN} are parsed into IDs corresponding to locations \emph{(loc)}. Data is formatted using pretty_mrn().}
 \item{med_enc_numb}{string, Unique identifier of the record/visit, displayed in the following format: Source System - Institution Number, corresponds to Encounter_number in RPDR.}
 \item{time_med}{POSIXct, Completion status of the requested test/transfusion. Converted to POSIXct format, corresponds to Medication_Date in RPDR.}
 \item{time_med_detail}{string, To clarify when patients may have stopped taking a medication, this column provides the statuses of 'Listed' or 'Removed'. This is provided on pre-Epic (LMR) medication dates (1997-2017).
 The 'Listed' value denotes that a medication was on the patient's medication list on the date indicated.
 The 'Removed' value denotes that a medication was removed from a patient's medication list on the date indicated. Corresponds to Medication_Date_Detail in RPDR.}
 \item{med}{string, Name of the medication. This may be appended with the source system in the case of OnCall and LMR medications, corresponds to Medication in RPDR.}
 \item{med_code}{string, Medication code associated with the "Code_type" value, corresponds to Code in RPDR.}
 \item{med_code_type}{string, Standardized classification system or custom source value used to identify the medication, corresponds to Code_Type in RPDR.}
 \item{med_quant}{string, Number of units of the medication ordered, corresponds to Quantity in RPDR.}
 \item{med_prov}{string, Ordering provider for the medication, corresponds to Provider in RPDR. Punctuation marks are removed.}
 \item{med_clinic}{string, Specific department/location where the medication was ordered or administered, corresponds to Clinic in RPDR. Punctuation marks are removed.}
 \item{med_hosp}{string, Facility where the medication was ordered or administered, corresponds to Hospital in RPDR.}
 \item{med_inpatient}{string, Identifies whether the medication was ordered with an Inpatient or Outpatient indication, corresponds to Inpatient_Outpatient in RPDR. Punctuation marks are removed.}
 \item{med_add_info}{string, Additional administration information about the medication, corresponds to Additional_Info in RPDR.}
 }
}
\description{
Result of a med.txt output from RPDR loaded into a data table in R using \emph{load_med()}.

**NOTE**: Due to potential issues with PHI and PPI, the example datasets can be downloaded from the
Partners Gitlab repository under *parserpdr-sample-data*.
}
