% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_enc_raw.R
\docType{data}
\encoding{UTF-8}
\name{data_enc_raw}
\alias{data_enc_raw}
\title{Example of enc.txt output from RPDR.}
\format{
data.table
}
\usage{
data_enc_raw
}
\value{
data table, imported from enc.txt
\describe{
 \item{EMPI}{numeric, Unique Partners-wide identifier assigned to the patient used to consolidate patient information.}
 \item{EPIC_PMRN}{numeric, Epic medical record number. This value is unique across Epic instances within the Partners network.}
 \item{MRN_Type}{string, Indicates the institution associated with a specific MRN. This can appear as a comma-delimited list if MRNs from multiple Partners Health System institutions are available.}
 \item{MRN}{string, Unique Medical Record Number for the site identified in the 'MRN_Type' field. This can appear as a comma-delimited list if multiple MRNs from Partners hospitals are available.}
 \item{Encounter_number}{string, Unique identifier of the record/visit. This values includes the source system, hospital, and a unique identifier within the source system.}
 \item{Encounter_Status}{string, Billing account-related notes about the encounter. This will not be populated for all encounters.}
 \item{Hospital}{string, Facility where the encounter occurred.}
 \item{Inpatient_Outpatient}{string, Classifies the type of encounter as either Inpatient or Outpatient. ED visits are currently classified under the 'Outpatient' label.}
 \item{Service_Line}{string, Hospital service line assigned to the encounter.}
 \item{Attending_MD}{string, The attending provider associated with the encounter. For Epic professional billing, this is the billing provider.}
 \item{Admit_Date}{string, Date when the patient was admitted or entered the facility.}
 \item{Discharge_Date}{string, Date when the patient was discharged or left the facility.}
 \item{LOS_Days}{numeric, Length of stay for the encounter.}
 \item{Clinic_Name}{string, Specific department/location where the encounter occured.}
 \item{Admit_Source}{string, Location where the patient was admitted when entering the hospital/clinic.}
 \item{Discharge_Disposition}{string, Patient's anticipated location or status following the encounter.}
 \item{Payor}{string, Payors responsible for the hospital account. Multiple payors (primary, secondary, etc.) may be listed.}
 \item{Admitting_Diagnosis}{string, Initial working diagnosis documented by the admitting or attending physician.}
 \item{Principal_Diagnosis}{string, Condition established, after study, to be chiefly responsible for occasioning the admission of the patient to the hospital for care.}
 \item{Diagnosis_1}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_1 in RPDR.}
 \item{Diagnosis_2}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_2 in RPDR.}
 \item{Diagnosis_3}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_3 in RPDR.}
 \item{Diagnosis_4}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_4 in RPDR.}
 \item{Diagnosis_5}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_5 in RPDR.}
 \item{Diagnosis_6}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_6 in RPDR.}
 \item{Diagnosis_7}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_7 in RPDR.}
 \item{Diagnosis_8}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_8 in RPDR.}
 \item{Diagnosis_9}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_9 in RPDR.}
 \item{Diagnosis_10}{string, Additional diagnoses associated with this encounter or visit, corresponds to Diagnosis_10 in RPDR.}
 \item{DRG}{string, Diagnosis-Related Group for the encounter, in the following format: SYSTEM:CODE - Description.}
 \item{Patient_Type}{string, Provides information regarding the specific patient classifications and status of the patient visit. This field is only populated for McLean Hospital encounters.}
 \item{Referrer_Discipline}{string, Location where the patient has been directed for treatment or follow-up by a staff member. This field is only populated for McLean Hospital encounters.}
 }
}
\description{
A enc.txt output from RPDR loaded into a data table in R using \emph{data.table::fread()}.

**NOTE**: Due to potential issues with PHI and PPI, the example datasets can be downloaded from the
Partners Gitlab repository under *parserpdr-sample-data*.
}
