% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate.R
\name{alembic}
\alias{alembic}
\title{Create the Blending and Distilling Object}
\usage{
alembic(
  f_param,
  f_pop,
  model_partition,
  output_partition,
  pars_interp_opts = interpolate_opts(fun = stats::splinefun, kind = "point", method =
    "natural"),
  pop_interp_opts = interpolate_opts(fun = stats::approxfun, kind = "integral", method =
    "constant", yleft = 0, yright = 0)
)
}
\arguments{
\item{f_param}{a function, \code{f(x)} which transforms the feature (e.g. age),
to yield the parameter values. Alternatively, a \code{data.frame} where the first
column is the feature and the second is the parameter; see
\code{\link[=xy.coords]{xy.coords()}} for details. If the latter, combined with \code{pars_interp_opts},
and defaulting to spline interpolation.}

\item{f_pop}{like \code{f_param}, either a density function (though it does
not have to integrate to 1 like a pdf) or a \code{data.frame} of values. If the
latter, it is treated as a series of populations within intervals, and
then interpolated with \code{pop_interp_opts} to create a density function.}

\item{model_partition}{a numeric vector of cut points, which define the
partitioning that will be used in the model}

\item{output_partition}{the partition of the underlying feature}

\item{pars_interp_opts}{a list, minimally with an element \code{fun},
corresponding to an interpolation function. Defaults to \code{\link[=splinefun]{splinefun()}}
"natural" interpolation.}

\item{pop_interp_opts}{ibid, but for density. Defaults to \code{\link[=approxfun]{approxfun()}}
"constant" interpolation.}
}
\value{
a \code{data.table} with columns \code{model_partition}, \code{output_partition}, \code{weight} and
\code{relpop}. The first two columns identify partition lower bounds, for both the model
and output, the other values are associated with; the combination of
\code{model_partition} and \code{output_partition} forms a unique identifier, but individually they
may appear multiple times. Generally, this object is only useful as an input
to the \code{\link[=blend]{blend()}} and \code{\link[=distill]{distill()}} tools.
}
\description{
Create the Blending and Distilling Object
}
\examples{
ifr_levin <- function(age_in_years) {
  (10^(-3.27 + 0.0524 * age_in_years))/100
}
age_limits <- c(seq(0, 69, by = 5), 70, 80, 101)
age_pyramid <- data.frame(
  from = 0:101, weight = ifelse(0:101 < 65, 1, .99^(0:101-64))
)
age_pyramid$weight[102] <- 0
# flat age distribution, then 1\% annual deaths, no one lives past 101
ifr_alembic <- alembic(ifr_levin, age_pyramid, age_limits, 0:101)

}
