% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_parameters.R,
%   R/select_parameters.stanreg.R
\name{select_parameters}
\alias{select_parameters}
\alias{select_parameters.lm}
\alias{select_parameters.merMod}
\alias{select_parameters.stanreg}
\title{Automated selection of model parameters}
\usage{
select_parameters(model, ...)

\method{select_parameters}{lm}(model, direction = "both", steps = 1000, k = 2, ...)

\method{select_parameters}{merMod}(model, direction = "backward", steps = 1000, ...)

\method{select_parameters}{stanreg}(model, method = NULL, cross_validation = FALSE, ...)
}
\arguments{
\item{model}{A statistical model (of class \code{lm}, \code{glm}, \code{merMod}, \code{stanreg} or \code{brmsfit}).}

\item{...}{Arguments passed to or from other methods.}

\item{direction}{
    the mode of stepwise search, can be one of \code{"both"},
    \code{"backward"}, or \code{"forward"}, with a default of \code{"both"}.
    If the \code{scope} argument is missing the default for
    \code{direction} is \code{"backward"}.  Values can be abbreviated.
  }

\item{steps}{
    the maximum number of steps to be considered.  The default is 1000
    (essentially as many as required).  It is typically used to stop the
    process early.
  }

\item{k}{
    the multiple of the number of degrees of freedom used for the penalty.
    Only \code{k = 2} gives the genuine AIC: \code{k = log(n)} is sometimes
    referred to as BIC or SBC.
  }

\item{method}{The method used in the variable selection. Can be \code{NULL} (default), \code{"forward"} or \code{"L1"}. See \code{projpred::varsel}.}

\item{cross_validation}{Select with cross-validation.}
}
\value{
The model refitted with optimal number of parameters.
}
\description{
This function performs an automated selection of the 'best' parameters, updating and returning the "best" model.
}
\details{
\subsection{Classical lm and glm}{
    For frequentist GLMs, \code{select_parameters()} performs an AIC-based
    stepwise selection.
  }
  \subsection{Mixed models}{
    For mixed models of class \code{merMod}, stepwise selection is
    based on \code{\link[cAIC4:stepcAIC]{stepcAIC()}}. This step function
    only searches the "best" model based on the random effects structure,
    i.e. \code{select_parameters()} adds or excludes random effects until
    the cAIC can't be improved further.
  }
  \subsection{Bayesian models}{
    For Bayesian models, it uses the \code{projpred} package.
  }
}
\examples{
model <- lm(mpg ~ ., data = mtcars)
select_parameters(model)

model <- lm(mpg ~ cyl * disp * hp * wt, data = mtcars)
select_parameters(model)
\donttest{
# lme4 -------------------------------------------
if (require("lme4")) {
  model <- lmer(
    Sepal.Width ~ Sepal.Length * Petal.Width * Petal.Length + (1 | Species),
    data = iris
  )
  select_parameters(model)
}

# rstanarm -------------------------------------------
if (require("rstanarm")) {
  model <- stan_glm(
    mpg ~ ., data = mtcars,
    iter = 500, refresh = 0, verbose = FALSE
  )
  select_parameters(model, cross_validation = TRUE)

  model <- stan_glm(
    mpg ~ cyl * disp * hp, data = mtcars,
    iter = 500, refresh = 0, verbose = FALSE
  )
  select_parameters(model, cross_validation = FALSE)
}
}
}
