% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_discrimination.R
\name{cluster_discrimination}
\alias{cluster_discrimination}
\title{Compute a linear discriminant analysis on classified cluster groups}
\usage{
cluster_discrimination(x, cluster_groups = NULL, ...)
}
\arguments{
\item{x}{A data frame}

\item{cluster_groups}{Group classification of the cluster analysis, which can
be retrieved from the \code{\link[=cluster_analysis]{cluster_analysis()}} function.}

\item{...}{Other arguments to be passed to or from.}
}
\description{
Computes linear discriminant analysis (LDA) on classified cluster groups, and
determines the goodness of classification for each cluster group. See \code{MASS::lda()}
for details.
}
\examples{
\dontshow{if (requireNamespace("MASS", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Retrieve group classification from hierarchical cluster analysis
clustering <- cluster_analysis(iris[, 1:4], n = 3)

# Goodness of group classification
cluster_discrimination(clustering)
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=n_clusters]{n_clusters()}} to determine the number of clusters to extract,
\code{\link[=cluster_analysis]{cluster_analysis()}} to compute a cluster analysis and
\code{\link[performance:check_clusterstructure]{performance::check_clusterstructure()}} to check suitability of data for
clustering.
}
