% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.lm.R,
%   R/model_parameters.polr.R
\name{model_parameters.lm}
\alias{model_parameters.lm}
\alias{model_parameters.polr}
\title{Parameters of (General) Linear Models}
\usage{
\method{model_parameters}{lm}(model, ci = 0.95, standardize = FALSE,
  standardize_robust = FALSE, bootstrap = FALSE, iterations = 1000,
  ...)

\method{model_parameters}{polr}(model, ci = 0.95, bootstrap = FALSE,
  iterations = 1000, ...)
}
\arguments{
\item{model}{Model object.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{standardize}{Add standardized parameters. Can be \code{FALSE} or a character indicating the standardization method (see \code{\link[=parameters_standardize]{parameters_standardize()}}), such as \code{"refit"}, \code{"2sd"}, \code{"smart"} or \code{"classic"}. The two former are based on model refitting using a standardized version of data. It is the most accurate, although computationally heavy (as it must re-fit a second model). The "smart" and "classic" are post-hoc methods, fast, but inaccurate (especially if the model includes interactions).}

\item{standardize_robust}{Robust standardization. See \code{\link[=parameters_standardize]{parameters_standardize}}.}

\item{bootstrap}{Should estimates be based on bootstrapped model? If \code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian regressions} apply (see also \code{\link[=parameters_bootstrap]{parameters_bootstrap()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the case of bootstrapped frequentist models.}

\item{...}{Arguments passed to or from other methods (e.g., to \code{\link[=standardize.lm]{standardize()}}).}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Extract and compute indices and measures to describe parameters of (general) linear models (GLMs).
}
\note{
Standardization (argument \code{standardize}) is not supported by all model objects.
}
\examples{
library(parameters)
model <- lm(mpg ~ wt + cyl, data = mtcars)

model_parameters(model, standardize = "refit")
model_parameters(model, bootstrap = TRUE)

model <- glm(vs ~ wt + cyl, data = mtcars, family = "binomial")
model_parameters(model)
}
\seealso{
\code{\link[=standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
