% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_parameters.htest.R
\name{model_parameters.htest}
\alias{model_parameters.htest}
\title{Correlations and t-test Parameters}
\usage{
\method{model_parameters}{htest}(model, bootstrap = FALSE, ...)
}
\arguments{
\item{model}{Object of class \code{htest}.}

\item{bootstrap}{Should estimates be bootstrapped?}

\item{...}{Arguments passed to or from other methods (e.g., to \link[=standardize.lm]{standardize}).}
}
\value{
A data.frame of indices related to the model's parameters.
}
\description{
Parameters of h-tests (correlations, t-tests).
}
\examples{
model <- cor.test(mtcars$mpg, mtcars$cyl, method = "pearson")
model_parameters(model)

model <- t.test(iris$Sepal.Width, iris$Sepal.Length)
model_parameters(model)

model <- t.test(mtcars$mpg ~ mtcars$vs)
model_parameters(model)

model <- t.test(iris$Sepal.Width, mu = 1)
model_parameters(model)
}
