% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_DirichletReg.R, R/methods_brglm2.R,
%   R/methods_mlm.R, R/methods_ordinal.R
\name{model_parameters.DirichletRegModel}
\alias{model_parameters.DirichletRegModel}
\alias{model_parameters.bracl}
\alias{model_parameters.mlm}
\alias{model_parameters.clm2}
\title{Parameters from multinomial or cumulative link models}
\usage{
\method{model_parameters}{DirichletRegModel}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("all", "conditional", "precision"),
  standardize = NULL,
  exponentiate = FALSE,
  verbose = TRUE,
  ...
)

\method{model_parameters}{bracl}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{mlm}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)

\method{model_parameters}{clm2}(
  model,
  ci = 0.95,
  bootstrap = FALSE,
  iterations = 1000,
  component = c("all", "conditional", "scale"),
  standardize = NULL,
  exponentiate = FALSE,
  p_adjust = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{model}{A model with multinomial or categorical response value.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}

\item{bootstrap}{Should estimates be based on bootstrapped model? If
\code{TRUE}, then arguments of \link[=model_parameters.stanreg]{Bayesian
regressions} apply (see also
\code{\link[=bootstrap_parameters]{bootstrap_parameters()}}).}

\item{iterations}{The number of bootstrap replicates. This only apply in the
case of bootstrapped frequentist models.}

\item{component}{Model component for which parameters should be shown. May be
one of \code{"conditional"}, \code{"precision"} (\pkg{betareg}),
\code{"scale"} (\pkg{ordinal}), \code{"extra"} (\pkg{glmx}),
\code{"marginal"} (\pkg{mfx}), \code{"conditional"} or \code{"full"} (for
\code{MuMIn::model.avg()}) or \code{"all"}.}

\item{standardize}{The method used for standardizing the parameters. Can be
\code{"refit"}, \code{"posthoc"}, \code{"smart"}, \code{"basic"},
\code{"pseudo"} or \code{NULL} (default) for no standardization. See
'Details' in \code{\link[effectsize]{standardize_parameters}}.
\strong{Important:} Categorical predictors (i.e. factors) are \emph{never}
standardized by default, which may be a different behaviour compared to
other R packages or other software packages (like SPSS). If standardizing
categorical predictors is desired, either use \code{standardize="basic"}
to mimic behaviour of SPSS or packages such as \pkg{lm.beta}, or standardize
the data with \code{effectsize::standardize(force=TRUE)} before fitting
the model. Robust estimation (i.e. \code{robust=TRUE}) of standardized
parameters only works when \code{standardize="refit"}.}

\item{exponentiate}{Logical, indicating whether or not to exponentiate the
the coefficients (and related confidence intervals). This is typical for
logistic regression, or more generally speaking, for models with log
or logit links. \strong{Note:} Delta-method standard errors are also
computed (by multiplying the standard errors by the transformed
coefficients). This is to mimic behaviour of other software packages, such
as Stata, but these standard errors poorly estimate uncertainty for the
transformed coefficient. The transformed confidence interval more clearly
captures this uncertainty. For \code{compare_parameters()},
\code{exponentiate = "nongaussian"} will only exponentiate coefficients
from non-Gaussian families.}

\item{verbose}{Toggle warnings and messages.}

\item{...}{Arguments passed to or from other methods. For instance, when
\code{bootstrap = TRUE}, arguments like \code{type} or \code{parallel} are
passed down to \code{bootstrap_model()}, and arguments like \code{ci_method}
are passed down to \code{\link[bayestestR]{describe_posterior}}.}

\item{p_adjust}{Character vector, if not \code{NULL}, indicates the method to
adjust p-values. See \code{\link[stats]{p.adjust}} for details. Further
possible adjustment methods are \code{"tukey"}, \code{"scheffe"},
\code{"sidak"} and \code{"none"} to explicitly disable adjustment for
\code{emmGrid} objects (from \pkg{emmeans}).}
}
\value{
A data frame of indices related to the model's parameters.
}
\description{
Parameters from multinomial or cumulative link models
}
\details{
Multinomial or cumulative link models, i.e. models where the
  response value (dependent variable) is categorical and has more than two
  levels, usually return coefficients for each response level. Hence, the
  output from \code{model_parameters()} will split the coefficient tables
  by the different levels of the model's response.
}
\examples{
library(parameters)
if (require("brglm2", quietly = TRUE)) {
  data("stemcell")
  model <- bracl(
    research ~ as.numeric(religion) + gender,
    weights = frequency,
    data = stemcell,
    type = "ML"
  )
  model_parameters(model)
}
}
\seealso{
\code{\link[insight:standardize_names]{standardize_names()}} to rename
  columns into a consistent, standardized naming scheme.
}
