% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robust_estimation.R
\name{standard_error_robust}
\alias{standard_error_robust}
\alias{p_value_robust}
\alias{ci_robust}
\title{Robust estimation}
\usage{
standard_error_robust(
  model,
  vcov_estimation = "HC",
  vcov_type = NULL,
  vcov_args = NULL,
  ...
)

p_value_robust(
  model,
  vcov_estimation = "HC",
  vcov_type = NULL,
  vcov_args = NULL,
  ...
)

ci_robust(
  model,
  ci = 0.95,
  vcov_estimation = "HC",
  vcov_type = NULL,
  vcov_args = NULL,
  ...
)
}
\arguments{
\item{model}{A model.}

\item{vcov_estimation}{String, indicating the suffix of the \code{vcov*()}-function
from the \pkg{sandwich} or \pkg{clubSandwich} package, e.g. \code{vcov_estimation = "CL"}
(which calls \code{\link[sandwich]{vcovCL}} to compute clustered covariance matrix
estimators), or \code{vcov_estimation = "HC"} (which calls
\code{\link[sandwich:vcovHC]{vcovHC()}} to compute heteroskedasticity-consistent
covariance matrix estimators).}

\item{vcov_type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich:vcovHC]{vcovHC()}}
or \code{clubSandwich::vcovCR()} for details).}

\item{vcov_args}{List of named vectors, used as additional arguments that
are passed down to the \pkg{sandwich}-function specified in \code{vcov_estimation}.}

\item{...}{Arguments passed to or from other methods. For \code{standard_error()},
if \code{method = "robust"}, arguments \code{vcov_estimation}, \code{vcov_type}
and \code{vcov_args} can be passed down to \code{standard_error_robust()}.}

\item{ci}{Confidence Interval (CI) level. Default to 0.95 (95\%).}
}
\value{
A data frame.
}
\description{
\code{standard_error_robust()}, \code{ci_robust()} and \code{p_value_robust()}
attempt to return indices based on robust estimation of the variance-covariance
matrix, using the packages \pkg{sandwich} and \pkg{clubSandwich}.
}
\note{
These functions rely on the \pkg{sandwich} or \pkg{clubSandwich} package
  (the latter if \code{vcov_estimation = "CR"} for cluster-robust standard errors)
  and will thus only work for those models supported by those packages.
}
\examples{
if (require("sandwich", quietly = TRUE)) {
  # robust standard errors, calling sandwich::vcovHC(type="HC3") by default
  model <- lm(Petal.Length ~ Sepal.Length * Species, data = iris)
  standard_error_robust(model)
}
\dontrun{
if (require("clubSandwich", quietly = TRUE)) {
  # cluster-robust standard errors, using clubSandwich
  iris$cluster <- factor(rep(LETTERS[1:8], length.out = nrow(iris)))
  standard_error_robust(
    model,
    vcov_type = "CR2",
    vcov_args = list(cluster = iris$cluster)
  )
}
}
}
\seealso{
Working examples cam be found \href{https://easystats.github.io/parameters/articles/model_parameters_robust.html}{in this vignette}.
}
