% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetTD}
\alias{GetTD}
\title{GetTD}
\usage{
GetTD(L, dissim_file)
}
\arguments{
\item{L}{A list of two numeric vectors, L["med","clasif"], as returned by ApplyPAM (please, consult the help of ApplyPAM for details)}

\item{dissim_file}{A string with the name of the binary file that contains the symmetric matrix of dissimilarities. Such matrix
should have been generated by CalcAndWriteDissimilarityMatrix and it is a matrix of type 'disttype' (currently defined as float).}
}
\value{
TD          The value of the TD function.
}
\description{
Function that takes a PAM classification (as returned by ApplyPAM) and the dissimilarity matrix and returns the value of the TD function
(sum of dissimilarities between each point and its closest medoid, divided by the number of points).
This function is mainly for debugging/internal use.
}
\examples{
# Synthetic problem: 10 random seeds with coordinates in [0..20]
# to which random values in [-0.1..0.1] are added
M<-matrix(0,100,500)
rownames(M)<-paste0("rn",c(1:100))
for (i in (1:10))
{
 p<-20*runif(500)
 Rf <- matrix(0.2*(runif(5000)-0.5),nrow=10)
 for (k in (1:10))
 {
  M[10*(i-1)+k,]=p+Rf[k,]
 }
}
JWriteBin(M,"pamtest.bin",dtype="float",dmtype="full")
CalcAndWriteDissimilarityMatrix("pamtest.bin","pamDL2.bin",distype="L2",restype="float",nthreads=0)
L <- ApplyPAM("pamDL2.bin",10,init_method="BUILD")
# Final value of sum of distances to closest medoid
GetTD(L,"pamDL2.bin")
}
