% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParamLgl.R
\docType{data}
\name{ParamLgl}
\alias{ParamLgl}
\title{Logical Parameter}
\format{\link[R6:R6Class]{R6::R6Class} object inheriting from \link{Param}.}
\description{
A \link{Param} to describe logical parameters.
}
\section{Construction}{
\preformatted{ParamLgl$new(id, special_vals = list(), default = NO_DEF, tags = character())
}

See Arguments of \link{Param}.
}

\section{Fields}{

Fields of \link{Param}, and additionally:
\itemize{
\item \code{lower} :: \code{numeric(1)}\cr
Lower bound.
Always \code{NA} for this parameter.
\item \code{upper} :: \code{numeric(1)}\cr
Upper bound.
Always \code{NA} for this parameter.
\item \code{levels} :: \code{logical(2)}\cr
Allowed levels.
Always \code{c(TRUE, FALSE)} for this parameter.
\item \code{nlevels} :: \code{Inf} \cr
Number of categorical levels.
Always 2 for this parameter.
\item \code{is_bounded} :: \code{TRUE}\cr
Are the bounds finite?
Always \code{TRUE} for this parameter.
}
}

\section{Methods}{

See \link{Param}.
}

\examples{
ParamLgl$new("flag", default = TRUE)
}
\seealso{
Other Params: \code{\link{ParamDbl}},
  \code{\link{ParamFct}}, \code{\link{ParamInt}},
  \code{\link{ParamUty}}, \code{\link{Param}}
}
\concept{Params}
\keyword{datasets}
