% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtimeroc.R
\name{rtimeroc}
\alias{rtimeroc}
\title{rtimeroc}
\usage{
rtimeroc(obj, n, censor.rate = 0, params.x, params.t, params.copula, params.ph)
}
\arguments{
\item{obj}{An initialized 'TimeROC' object.\cr}

\item{n}{An integer of sample size.\cr}

\item{censor.rate}{An integer between 0 to 1 that is used for randomized censoring.\cr}

\item{params.x}{Vector of biomarker parameter.\cr}

\item{params.t}{Vector of time-to-event parameter.\cr}

\item{params.copula}{An integer for copula parameter.\cr}

\item{params.ph}{An integer for association parameter.}
}
\value{
A dataframe with 3 columns (x = biomarker value, t = observable time-to-event, status = censored/not censor (0 or 1))
}
\description{
Function to generate bivariate data from PH or copula model.
}
\examples{
## Copula model
test <- timeroc_obj(dist = 'gompertz-gompertz-copula', copula = "gumbel90")
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0, n=500,
               params.t = c(shape=3,rate=1),
               params.x = c(shape=1,rate=2),
               params.copula=-5)
plot(t~x, rr)

## PH model
test <- timeroc_obj(dist = 'weibull-gompertz-PH')
set.seed(23456)
rr <- rtimeroc(obj = test, censor.rate = 0, n=100,
               params.t = c(shape=2, rate=1),
               params.x = c(shape=2, scale=1),
               params.ph=0.5)
plot(t~x, rr)
}
