% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createMrBayesTipCalibrations.R
\name{createMrBayesTipCalibrations}
\alias{createMrBayesTipCalibrations}
\title{Construct A Block of Tip Age Calibrations for Use with Tip-Dating Analyses in MrBayes}
\usage{
createMrBayesTipCalibrations(tipTimes, ageCalibrationType,
  whichAppearance = "first", treeAgeOffset, minTreeAge = NULL,
  collapseUniform = TRUE, anchorTaxon = TRUE, file = NULL)
}
\arguments{
\item{tipTimes}{This input may be either a timeList object (i.e. a list of length 2, 
composed of a table of interval upper and lower time boundaries (i.e. earlier and latter bounds), and 
a table of first and last intervals for taxa) or a matrix with rownames
for taxa as you want listed in the MrBayes block, with either one, two
or four columns containing ages (respectively) for point occurrences with
precise dates (for a single column), uncertainty bounds on a point occurrence
(for two columns), or uncertainty bounds on the first and
last occurrence (for four columns). Note that precise first and last occurrence
dates should not be entered as a two column matrix, as this will instead be interpreted
as uncertainty bounds on a single occurrence. Instead, either select which you want to
use for tip-dates and give a 1-column matrix, or repeat (and collate) the columns, so that
the first and last appearances has uncertainty bounds of zero.}

\item{ageCalibrationType}{This argument decides how age calibrations are defined, 
and currently allows for four options: \code{"fixedDateEarlier"} which fixes tip
ages at the earlier (lower) bound for the selected age of appearance (see argument
\code{whichAppearance} for how that selection is made), \code{"fixedDateLatter"}
which fixes the date to the latter (upper) bound of the selected age of appearance,
\code{"fixedDateRandom"} which fixes tips to a date that is randomly drawn from a
uniform distribution bounded by the upper and lower bounds on the selected age of
appearance, or (the recommended option) \code{"uniformRange"} which places a uniform
prior on the age of the tip, bounded by the latest and earliest (upper and lower)
bounds on the the selected age.}

\item{whichAppearance}{Which appearance date of the taxa should be used:
their \code{'first'} or their \code{'last'} appearance date? The default
option is to use the 'first' appearance date. Note that use of the last
appearance date means that tips will be constrained to occur before their
last occurrence, and thus could occur long after their first occurrence (!).}

\item{treeAgeOffset}{A parameter given by the user controlling the offset 
between the minimum and expected tree age prior. mean tree age for the
offset exponential prior on tree age will be set to the minimum tree age, 
plus this offset value. Thus, an offset of 10 million years would equate to a prior
assuming that the expected tree age is around 10 million years before the minimum age.}

\item{minTreeAge}{if \code{NULL} (the default), then minTreeAge will
be set as the oldest date among the tip age used (those used being
determine by user choices (or oldest bound on a tip age). Otherwise,
the user can supply their own minimum tree, which must be greater than
whatever the oldest tip age used is.}

\item{collapseUniform}{MrBayes won't accept uniform age priors where the maximum and
minimum age are identical (i.e. its actually a fixed age). Thus, if this argument
is \code{TRUE} (the default), this function
will treat any taxon ages where the maximum and minimum are identical as a fixed age, and
will override setting \code{ageCalibrationType = "uniformRange"} for those dates.
All taxa with their ages set to fixed by the behavior of \code{anchorTaxon} or \code{collapseUniform}
are returned as a list within a commented line of the returned MrBayes block.}

\item{anchorTaxon}{This argument may be a logical (default is \code{TRUE}, or a character string of length = 1.
This argument has no effect if \code{ageCalibrationType} is not set to "uniformRange", but the argument may still be evaluated.
If \code{ageCalibrationType = "uniformRange"}, MrBayes will do a tip-dating analysis with uniform age uncertainties on 
all taxa (if such uncertainties exist; see \code{collapseUniform}). However, MrBayes does not record how each tree sits on an absolute time-scale,
so if the placement of \emph{every} tip is uncertain, lining up multiple dated trees sampled from the posterior (where each tip's true age might
differ) could be a nightmare to back-calculate, if not impossible. Thus, if \code{ageCalibrationType = "uniformRange"}, and there are no tip taxa given
fixed dates due to \code{collapseUniform} (i.e. all of the tip ages have a range of uncertainty on them), then a particular taxon
will be selected and given a fixed date equal to its earliest appearance time for its respective \code{whichAppearance}. This taxon can either be indicated by
the user or instead the first taxon listed in \code{tipTimes} will be arbitrary selected. All taxa with their ages set
to fixed by the behavior of \code{anchorTaxon} or \code{collapseUniform} are returned as a list within a commented line of the returned MrBayes block.}

\item{file}{Filename (possibly with path) as a character string
to a file which will be overwritten with the output tip age calibrations.
If \code{NULL}, tip calibration commands are output to the console.}
}
\value{
If argument \code{file} is \code{NULL}, then the tip age commands
are output as a series of character strings.

All taxa with their ages set to fixed by the behavior of \code{anchorTaxon} or \code{collapseUniform}
are returned as a list within a commented line of the returned MrBayes block.
}
\description{
Takes a set of tip ages (in several possible forms, see below),
and outputs a set of tip age calibrations
for use with tip-dating analyses (sensu Zhang et al., 2016)
in the popular phylogenetics program \emph{MrBayes}.
These calibrations are printed as a set of character strings, as well as a 
line placing an offset exponential prior on the tree age, either
printed in the R console or in a named text file, which can be used as
commands in the \emph{MrBayes} block of a NEXUS file for use with 
(you guessed it!) \emph{MrBayes}.
}
\details{
Beware: some combinations of arguments might not make sense for your data.

(But that's always true, is it not?)
}
\examples{

# load retiolitid dataset
data(retiolitinae)

# uniform prior, with a 10 million year offset for
	# the expected tree age from the earliest first appearance

createMrBayesTipCalibrations(tipTimes=retioRanges, whichAppearance="first",
	ageCalibrationType="uniformRange", treeAgeOffset=10)

# fixed prior, at the earliest bound for the first appearance

createMrBayesTipCalibrations(tipTimes=retioRanges, whichAppearance="first",
	ageCalibrationType="fixedDateEarlier", treeAgeOffset=10)

# fixed prior, sampled from between the bounds on the last appearance
	# you should probably never do this, fyi

createMrBayesTipCalibrations(tipTimes=retioRanges, whichAppearance="first",
	ageCalibrationType="fixedDateRandom", treeAgeOffset=10)


\dontrun{

createMrBayesTipCalibrations(tipTimes=retioRanges, whichAppearance="first",
	ageCalibrationType="uniformRange", treeAgeOffset=10, file="tipCalibrations.txt")

}

}
\references{
Zhang, C., T. Stadler, S. Klopfstein, T. A. Heath, and F. Ronquist. 2016. 
Total-Evidence Dating under the Fossilized Birth-Death Process.
\emph{Systematic Biology} 65(2):228-249.
}
\seealso{
\code{\link{createMrBayesConstraints}}, \code{\link{createMrBayesTipDatingNexus}}
}
\author{
David W. Bapst. This code was produced as part of a project 
funded by National Science Foundation grant EAR-1147537 to S. J. Carlson.
}
