\name{make.set}
\alias{make.set}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{ Function to simulate species data
%%  ~~function to do ... ~~
}
\description{ Function to simulate species data following Minchin (1987). This functions generates species response functions, simulates environmental variables and simulates species assemblages based on species response functions and environmental variables. Users can as well supply own species parameters (e.g. when simulating calibration and fossil datasets) and own environmental variables. 
%%  ~~ A concise (1-5 lines) description of what the function does. ~~
}
\usage{
make.set(ndim, n, elen, emean, edistr, ecor, cnt, spec, env,...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{ 
  \item{ndim}{ Number of environmental variables to generate. 
%%     ~~Describe \code{ndim} here~~
}
  \item{n}{ Number of samples to be generated.
%%     ~~Describe \code{n} here~~
}
  \item{elen}{ Range of the environmental variables. Single number or vector of length ndim.  
%%     ~~Describe \code{elen} here~~
}
  \item{emean}{ Mean of the environmental variables. Single number or vector of length ndim. 
%%     ~~Describe \code{mean} here~~
}
  \item{edistr}{ Distribution of the environmental variables. Currently 'uniform' and 'Gaussian' are supported.  
%%     ~~Describe \code{distr} here~~
}
  \item{ecor}{ Correlation matrix of the environmental variables supplied by user. Object generated by \code{\link{cor.mat.fun}}. If omitted environmental variables are uncorrelated.
%%     ~~Describe \code{cor.mat} here~~
}
 \item{cnt}{ Number of counts to be simulated.
%%     ~~Describe \code{cnt} here~~
}
  \item{spec}{ Users may supply their own species paramters.
%%     ~~Describe \code{spec} here~~
}              
  \item{env}{  Users may supply their own environmental variables.
%%     ~~Describe \code{env} here~~
}   
  \item{...}{ Arguments passed to \code{\link{species}}
}  

}
\value{
\item{spp }{Species abundance data.}
\item{env }{Environmental variables used to simulate species abundance data.}
\item{spec }{Species parameters.}
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
\references{ Minchin, P.R. (1987) Multidimensional Community Patterns: Towards a Comprehensive Model. Vegetatio, 71, 145-156.
%% ~put references to the literature/web site here ~
}
\author{ Mathias Trachsel and Richard J. Telford
%%  ~~who you are~~
}
%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{  \code{\link{make.env}}, \code{\link{species}}, \code{\link{cor.mat.fun}}
%% ~~objects to See Also as \code{\link{help}}, ~~~
}
\examples{
calib <- make.set(nspp = 90,ndim = 3,Amax = runif,fun = runif, xpar = c(-50,150), 
    srange = 400, alpha = 4, gamma = 4,n = 100,elen =rep(100,3),emean = rep(50,3),
    edistr ='uniform', cnt = 1000)

# Provide species parameters generated above, so that the fossil data use the 
#    same species parameters.
fos <- make.set(ndim = 3,n = 100,elen =rep(100,3),emean = rep(50,3), edistr ='uniform',
    cnt = 1000, spec = calib$spec)  

# Supplying own environmental variables and species parameters.
env.vars <- make.env(100,elen =rep(100,3),emean = rep(50,3), edistr ='uniform',ndim = 3)
fos <- make.set(cnt = 1000, spec = calib$spec, env = env.vars)  


}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ datagen }
