% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/local.R
\name{local_deps_explain}
\alias{local_deps_explain}
\alias{local_dev_deps_explain}
\title{Explain dependencies of a package tree}
\usage{
local_deps_explain(deps, root = ".", upgrade = TRUE, dependencies = NA)

local_dev_deps_explain(deps, root = ".", upgrade = TRUE, dependencies = TRUE)
}
\arguments{
\item{deps}{Package names of the dependencies to explain.}

\item{root}{Path to the package tree.}

\item{upgrade}{Whether to use the most recent available package
versions.}

\item{dependencies}{What kinds of dependencies to install. Most commonly
one of the following values:
\itemize{
\item \code{NA}: only required (hard) dependencies,
\item \code{TRUE}: required dependencies plus optional and development
dependencies,
\item \code{FALSE}: do not install any dependencies. (You might end up with a
non-working package, and/or the installation might fail.)
See \link{Package dependency types} for other possible values and more
information about package dependencies.
}}
}
\description{
These functions are similar to \code{\link[=pkg_deps_explain]{pkg_deps_explain()}}, but work on a
local package tree. \code{local_dev_deps_explain()} also includes development
dependencies.
}
\seealso{
Other local package trees: 
\code{\link{local_deps}()},
\code{\link{local_install_deps}()},
\code{\link{local_install_dev_deps}()},
\code{\link{local_install}()},
\code{\link{local_package_trees}},
\code{\link{pak}()}
}
\concept{local package trees}
