% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{Installing pak}
\alias{Installing pak}
\title{All about installing pak.}
\description{
Read this if the default installation methods do not work for you or
if you want the release candidate or development version.
\subsection{Pre-built binaries}{

Our pre-built binaries have the advantage that they are completely
self-containted and dependency free.
No additional R packages, system libraries or tools (e.g. compilers) are
needed for them.
Install a pre-built binary build of pak from our repository on GitHub:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pak", repos = sprintf(
  "https://r-lib.github.io/p/pak/stable/\%s/\%s/\%s",
  .Platform$pkgType,
  R.Version()$os,
  R.Version()$arch
))
}\if{html}{\out{</div>}}

This is supported for the following systems:\tabular{lll}{
   OS \tab CPU \tab R version \cr
   Linux \tab x86_64 \tab R 3.4.0 - R-devel \cr
   Linux \tab aarch64 \tab R 3.4.0 - R-devel \cr
   macOS High Sierra+ \tab x86_64 \tab R 3.4.0 - R-devel \cr
   macOS Big Sur+ \tab aarch64 \tab R 4.1.0 - R-devel \cr
   Windows \tab x86_64 \tab R 3.4.0 - R-devel \cr
   FreeBSD 13.x or later \tab x86_64 \tab R 4.4.x \cr
   OpenBSD 7.4, 7.5, 7.6 \tab x86_64 \tab R 4.2.x (7.4, 7.5), R 4.4.x (7.6) \cr
   NetBSD 10.0 \tab x86_64 \tab R 4.4.x \cr
   DragonFly BSD 6.4 \tab x86_64 \tab R 4.3.x \cr
}

\subsection{Notes}{
\itemize{
\item For macOS we only support the official CRAN R build. Other builds, e.g.
Homebrew R, are not supported.
\item We only support R builds that have an R shared library. CRAN's Windows
and macOS installers are such, so the the R builds in the common Linux
distributions. But this might be an issue if you build R yourself without
the \code{--enable-R-shlib} option.
}
}

}

\subsection{Install from CRAN}{

Install the released version of the package from CRAN as usual:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pak")
}\if{html}{\out{</div>}}

This potentially needs a C compiler on platforms CRAN does not have
binaries packages for.
}

\subsection{Nightly builds}{

We have nightly binary builds, for the same systems as the table above:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{install.packages("pak", repos = sprintf(
  "https://r-lib.github.io/p/pak/devel/\%s/\%s/\%s",
  .Platform$pkgType,
  R.Version()$os,
  R.Version()$arch
))
}\if{html}{\out{</div>}}
\subsection{\code{stable}, \code{rc} and \code{devel} streams}{

We have three types of binaries available:
\itemize{
\item \code{stable} corresponds to the latest CRAN release of CRAN.
\item \code{rc} is a release candidate build, and it is available about 1-2 weeks
before a release. Otherwise it is the same as the \code{stable} build.
\item \code{devel} has builds from the development tree. Before release it might be
the same as the \code{rc} build.
}

The streams are available under different repository URLs:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{stream <- "rc"
install.packages("pak", repos = sprintf(
  "https://r-lib.github.io/p/pak/\%s/\%s/\%s/\%s",
  stream,
  .Platform$pkgType,
  R.Version()$os,
  R.Version()$arch
))
}\if{html}{\out{</div>}}
}

}
}
