% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/circleLayout.R
\name{circleLayout}
\alias{circleLayout}
\title{Find an arrangement of circles given circle radii and initial positions.}
\usage{
circleLayout(xyr, xlim, ylim, maxiter = 1000, wrap = TRUE, weights = 1)
}
\arguments{
\item{xyr}{3-column matrix or data.frame (centre X, centre Y, radius)}

\item{xlim}{bounds in the X direction; either a vector for [xmin, xmax)
or a single value interpreted as [0, xmax)}

\item{ylim}{bounds in the Y direction; either a vector for [ymin, ymax)
or a single value interpreted as [0, ymax)}

\item{maxiter}{maximum number of iterations to attempt}

\item{wrap}{whether to allow coordinate wrapping across bounds. If `true`,
coordinate wrapping results in a toroidal space; if `false`, ordinates
are simply restricted to bounds.}

\item{weights}{an optional vector of numeric weights (0 to 1 inclusive)
  to apply to the distance each circle moves during pair-repulsion.
  A weight of 0 prevents any movement. A weight of 1 gives the default
  movement distance. A single value can be supplied for uniform weights.
  A vector with length less than the number of circles will be silently
  extended by repeating the final value. Any values outside the range
  [0, 1] will be clamped to 0 or 1.}
}
\value{
A list with components:
  \describe{
    \item{layout}{A 3-column matrix or data.frame (centre x, centre y, radius).}
    \item{niter}{Number of iterations performed.}
  }
}
\description{
Attempts to find a layout for a given set of circles
within a rectangle such that is no overlap between circles.
}

