% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/help_parameter_estimation_functions.R
\name{form_expression_glm}
\alias{form_expression_glm}
\title{Form expression to use with glm()}
\usage{
form_expression_glm(
  param_to_be_estimated,
  indep_var,
  family,
  covariates,
  interaction,
  naaction,
  link
)
}
\arguments{
\item{param_to_be_estimated}{parameter of interest}

\item{indep_var}{the independent variable (column name in data file)}

\item{family}{distribution name  eg. for logistic regression -binomial}

\item{covariates}{list of covariates}

\item{interaction}{boolean value to indicate interaction in the case of
generalised linear models, false by default}

\item{naaction}{action to be taken with the missing values}

\item{link}{link function if not the default for each family}
}
\value{
the formula for glm
}
\description{
Form expression to use with glm()
}
\details{
Form expression for the method glm
}
\examples{
formula <- form_expression_glm("admit",
  indep_var = "gre", family = "binomial",
  covariates = c("gpa", "rank"), interaction = FALSE, naaction = "na.omit",
  link = NA)
}
